/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.flow;

import com.ef_prime.rflow.core.app.r.base.R;
import com.ef_prime.rflow.core.app.r.base.RPackage;
import com.ef_prime.rflow.core.common.keyvalue.ValueError;
import com.ef_prime.rflow.core.flow.BoxConnectionError;
import com.ef_prime.rflow.core.flow.CacheData;
import com.ef_prime.rflow.core.flow.FlowEdge;
import com.ef_prime.rflow.core.flow.FlowError;
import com.ef_prime.rflow.core.flow.FlowGraph;
import com.ef_prime.rflow.core.flow.FlowModel;
import com.ef_prime.rflow.core.flow.FlowNode;
import com.ef_prime.rflow.core.flow.FlowNodeSelectionEvent;
import com.ef_prime.rflow.core.flow.FlowNodeSelectionEventHandler;
import com.ef_prime.rflow.core.flow.FlowStateEvent;
import com.ef_prime.rflow.core.flow.FlowUtil;
import com.ef_prime.rflow.core.flow.RPackageError;
import com.ef_prime.rflow.core.flow.RSyntaxFlowError;
import com.ef_prime.rflow.core.flow.ValueFlowError;
import com.ef_prime.rflow.core.flow.task.NodeTask;
import com.ef_prime.rflow.node.NodeModelChangeListener;
import com.ef_prime.rflow.node.base.SubflowNodeModel;
import com.ef_prime.rflow.node.ui.UINodeModel;
import com.ef_prime.rflow.ui.base.ActiveViewerListener;
import com.ef_prime.rflow.ui.common.event.EventManager;
import com.ef_prime.rflow.ui.common.event.SimpleEvent;
import com.ef_prime.rflow.ui.common.event.SimpleEventHandler;
import com.ef_prime.rflow.ui.flow.CacheEvent;
import com.ef_prime.rflow.ui.flow.FlowErrorEvent;
import com.ef_prime.rflow.ui.flow.FlowViewer;
import com.ef_prime.rflow.ui.flow.HighlightChangedEvent;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.graph.event.GraphEvent;
import edu.uci.ics.jung.graph.event.GraphEventListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Popup;

public class FlowState
implements NodeModelChangeListener,
FlowNodeSelectionEventHandler,
GraphEventListener,
SimpleEventHandler,
ActiveViewerListener {
    public static final String PROPERTY_FLAG_NODE = "PROPERTY_FLAG_NODE";
    public static final String PROPERTY_NEXT_STEP_TASK = "PROPERTY_NEXT_STEP_TASK";
    public static final String PROPERTY_POPED_COMMENT = "PROPERTY_POPED_COMMENT";
    public static final String PROPERTY_ROLLOVER_NODE = "PROPERTY_ROLLOVER_NODE";
    public static final String PROPERTY_ROLLOVER_COMMENT = "PROPERTY_ROLLOVER_COMMENT";
    public static final String PROPERTY_HIGHLIGHT = "PROPERTY_HILIGHT";
    private FlowNode flagNode;
    private Set<FlowNode> flagBoxSet = new HashSet<FlowNode>();
    private FlowNode highlightNode;
    private Set<FlowNode> taskHighlight = new HashSet<FlowNode>();
    private Set<FlowNode> executingNode = new HashSet<FlowNode>();
    private List<FlowNode> taskHighlightFlow = new ArrayList<FlowNode>();
    private List<FlowEdge> taskHighlightEdgeFlow = new ArrayList<FlowEdge>();
    private NodeTask nextStepTask;
    private FlowNode nextStepNode;
    private Set<FlowNode> cacheSet = new HashSet<FlowNode>();
    private Set<FlowNode> cacheScopeSet = new HashSet<FlowNode>();
    private Map<FlowNode, List<FlowError>> errorMap = new HashMap<FlowNode, List<FlowError>>();
    private FlowNode poppedComment;
    private Popup popup;
    private FlowNode rollOverNode;
    private FlowNode rollOverComment;
    private FlowEdge creatingEdge;
    private Boolean hierarchyVisible;
    private int hierarchySplit;
    private HighlightChangedEvent highlightChangedEvent = new HighlightChangedEvent(this);
    private FlowModel flowModel;

    public void setFlowModel(FlowModel flowModel) {
        this.flowModel = flowModel;
    }

    public void add(FlowState flowState) {
        this.cacheSet.addAll(flowState.cacheSet);
    }

    @Override
    public void flowSelectionChanged(FlowNodeSelectionEvent flowNodeSelectionEvent) {
        this.clearTaskHighlightNode();
    }

    private void addFlowSelection(FlowNode flowNode, List<FlowNode> list, List<FlowEdge> list2) {
        List<FlowNode> list3 = FlowUtil.getStream(flowNode, true, true, false);
        FlowNode flowNode2 = null;
        HashSet<FlowNode> hashSet = new HashSet<FlowNode>();
        for (int i = list3.size() - 1; i >= 0; --i) {
            FlowNode flowNode3 = list3.get(i);
            list.add(flowNode3);
            if (flowNode3.getModel().isSubflow()) {
                hashSet.add(flowNode3);
            }
            if (flowNode2 != null) {
                FlowEdge flowEdge = (FlowEdge)flowNode3.findEdge((Vertex)flowNode2);
                if (flowEdge == null) {
                    FlowNode flowNode4;
                    Iterator iterator = hashSet.iterator();
                    while (iterator.hasNext() && (flowEdge = (FlowEdge)flowNode3.findEdge((Vertex)(flowNode4 = (FlowNode)iterator.next()))) == null) {
                    }
                }
                if (flowEdge != null) {
                    list2.add(flowEdge);
                }
            }
            flowNode2 = flowNode3;
        }
    }

    public FlowNode getFlagNode() {
        return this.flagNode;
    }

    public void setFlagNode(FlowNode flowNode) {
        if (flowNode == null || flowNode.getGraph() == null) {
            this.clearFlagNode();
            return;
        }
        if (this.flagNode != null && flowNode != null && this.flagNode.equals(flowNode)) {
            return;
        }
        this.flagNode = flowNode;
        this.flagBoxSet.clear();
        FlowGraph flowGraph = flowNode.getGraph();
        while (!flowGraph.isRootGraph()) {
            this.flagBoxSet.add(flowGraph.getParentNode());
            flowGraph = flowGraph.getParentNode().getGraph();
        }
        EventManager.getInstance().dispatchEvent(new FlowStateEvent(PROPERTY_FLAG_NODE, this));
    }

    public void clearFlagNode() {
        if (this.flagNode == null) {
            return;
        }
        this.flagNode = null;
        this.flagBoxSet.clear();
        EventManager.getInstance().dispatchEvent(new FlowStateEvent(PROPERTY_FLAG_NODE, this));
    }

    public boolean isFlagNode(FlowNode flowNode) {
        if (this.flagNode == null) {
            return false;
        }
        return this.flagNode.equals(flowNode);
    }

    public Set<FlowNode> getFlagBoxSet() {
        return this.flagBoxSet;
    }

    public FlowNode getHighlightNode() {
        return this.highlightNode;
    }

    public void setHighlightNode(FlowNode flowNode) {
        if (this.highlightNode == flowNode) {
            return;
        }
        this.highlightNode = flowNode;
        EventManager.getInstance().dispatchEvent(new FlowStateEvent(PROPERTY_HIGHLIGHT, this));
    }

    public boolean isHighlightNode(FlowNode flowNode) {
        if (this.highlightNode == null) {
            return false;
        }
        return this.highlightNode.equals(flowNode);
    }

    public void setNextStepTask(NodeTask nodeTask) {
        if (this.nextStepTask != nodeTask) {
            this.nextStepTask = nodeTask;
            this.nextStepNode = nodeTask == null ? null : nodeTask.getNode();
            EventManager.getInstance().dispatchEvent(new FlowStateEvent(PROPERTY_NEXT_STEP_TASK, this));
        }
    }

    public boolean isNextStepNode(FlowNode flowNode) {
        return this.nextStepNode == flowNode;
    }

    public boolean isNextStepTask(NodeTask nodeTask) {
        return this.nextStepTask == nodeTask;
    }

    public NodeTask getNextStepTask() {
        return this.nextStepTask;
    }

    public FlowNode getPoppedCommentNode() {
        return this.poppedComment;
    }

    public void setPoppedComment(FlowNode flowNode) {
        if (this.poppedComment != flowNode) {
            this.poppedComment = flowNode;
            EventManager.getInstance().dispatchEvent(new FlowStateEvent(PROPERTY_POPED_COMMENT, this));
        }
    }

    public boolean isPoppedComment(FlowNode flowNode) {
        return this.poppedComment == flowNode;
    }

    public void setPopup(Popup popup) {
        if (popup == null) {
            if (this.popup != null) {
                this.popup.hide();
            }
        } else {
            popup.show();
        }
        this.popup = popup;
    }

    public Popup getPopup() {
        return this.popup;
    }

    public void setRollOverNode(FlowNode flowNode) {
        if (this.rollOverNode != flowNode) {
            if (this.rollOverNode != null) {
                this.rollOverNode.getModel().mouseExited(this.rollOverNode);
            }
            if (flowNode != null) {
                flowNode.getModel().mouseEntered(flowNode);
            }
            this.rollOverNode = flowNode;
            EventManager.getInstance().dispatchEvent(new FlowStateEvent(PROPERTY_ROLLOVER_NODE, this));
        }
    }

    public boolean isRollOverNode(FlowNode flowNode) {
        return this.rollOverNode == flowNode;
    }

    public void setRollOverCommentNode(FlowNode flowNode) {
        if (this.rollOverComment != flowNode) {
            this.rollOverComment = flowNode;
            EventManager.getInstance().dispatchEvent(new FlowStateEvent(PROPERTY_ROLLOVER_COMMENT, this));
        }
    }

    public boolean isRollOverCommentNode(FlowNode flowNode) {
        return this.rollOverComment == flowNode;
    }

    public void addTaskHighlightNode(Set<FlowNode> set) {
        this.taskHighlight.addAll(set);
        this.taskHighlightFlow.clear();
        this.taskHighlightEdgeFlow.clear();
        for (FlowNode flowNode : this.taskHighlight) {
            this.addFlowSelection(flowNode, this.taskHighlightFlow, this.taskHighlightEdgeFlow);
        }
        EventManager.getInstance().dispatchEvent(this.highlightChangedEvent);
    }

    public void clearTaskHighlightNode() {
        if (!this.taskHighlight.isEmpty()) {
            this.taskHighlight.clear();
            this.taskHighlightFlow.clear();
            this.taskHighlightEdgeFlow.clear();
            EventManager.getInstance().dispatchEvent(this.highlightChangedEvent);
        }
    }

    public boolean isTaskHighlightNode(FlowNode flowNode) {
        return this.taskHighlight.contains(flowNode);
    }

    public boolean isTaskHighlight() {
        return !this.taskHighlight.isEmpty();
    }

    public List<FlowEdge> getTaskHighlightEdgeFlow() {
        return this.taskHighlightEdgeFlow;
    }

    public void setExecutingNode(FlowNode flowNode) {
        if (flowNode == null) {
            this.executingNode.clear();
        } else {
            this.executingNode.clear();
            this.executingNode.add(flowNode);
            FlowNode flowNode2 = flowNode;
            while (flowNode2.getGraph() != null && !flowNode2.getGraph().isRootGraph()) {
                flowNode2 = flowNode2.getParentNode();
                this.executingNode.add(flowNode2);
            }
        }
    }

    public Set<FlowNode> getExecutingNode() {
        return this.executingNode;
    }

    public boolean isExecutingNode(FlowNode flowNode) {
        if (this.executingNode.isEmpty()) {
            return false;
        }
        return this.executingNode.contains(flowNode);
    }

    public Set<FlowNode> getCacheNodes() {
        return this.cacheSet;
    }

    public boolean isCacheFile(String string) {
        for (FlowNode flowNode : this.getCacheNodes()) {
            if (!string.equals(flowNode.getCacheData().getFile().getName())) continue;
            return true;
        }
        return false;
    }

    public void setCache(FlowNode flowNode, CacheData cacheData) {
        if (cacheData == null) {
            throw new IllegalArgumentException("cacheData must not null");
        }
        this.cacheSet.add(flowNode);
        cacheData.setFlagExists(true);
        flowNode.setCacheData(cacheData);
    }

    public void removeCacheNode(FlowNode flowNode) {
        this.cacheSet.remove(flowNode);
        flowNode.getCacheData().setFlagExists(false);
    }

    public boolean isinCacheScope(FlowNode flowNode) {
        return this.cacheScopeSet.contains(flowNode);
    }

    public void setError(FlowNode flowNode, FlowError flowError) {
        this.removeError(flowNode, flowError.getClass());
        List<FlowError> list = this.errorMap.get(flowNode);
        if (list == null) {
            list = new ArrayList<FlowError>(2);
            this.errorMap.put(flowNode, list);
        }
        list.add(flowError);
        EventManager.getInstance().dispatchEvent(new FlowErrorEvent(flowNode, flowError, 0));
    }

    public void removeError(FlowNode flowNode, Class<? extends FlowError> clazz) {
        List<FlowError> list = this.errorMap.get(flowNode);
        if (list == null) {
            return;
        }
        for (FlowError flowError : new LinkedHashSet<FlowError>(list)) {
            if (!clazz.isInstance(flowError)) continue;
            list.remove(flowError);
            if (list.isEmpty()) {
                this.errorMap.remove(flowNode);
            }
            EventManager.getInstance().dispatchEvent(new FlowErrorEvent(flowNode, null, 1));
        }
    }

    private void removeError(FlowNode flowNode) {
        List<FlowError> list = this.errorMap.remove(flowNode);
        if (list != null) {
            EventManager.getInstance().dispatchEvent(new FlowErrorEvent(flowNode, null, 1));
        }
    }

    public List<FlowError> getError(FlowNode flowNode) {
        return this.errorMap.get(flowNode);
    }

    public boolean isError(FlowNode flowNode) {
        return this.getError(flowNode) != null;
    }

    public String getErrorMessageHtml(FlowNode flowNode) {
        return FlowError.errorsToHtml(this.getError(flowNode));
    }

    public void setCreatingEdge(FlowEdge flowEdge) {
        this.creatingEdge = flowEdge;
    }

    public FlowEdge getCreatingEdge() {
        return this.creatingEdge;
    }

    public Boolean isHierarchyVisible() {
        return this.hierarchyVisible;
    }

    public void setHierarchyVisible(boolean bl) {
        this.hierarchyVisible = bl;
    }

    public int getHierarchySplit() {
        return this.hierarchySplit;
    }

    public void setHierarchySplit(int n) {
        this.hierarchySplit = n;
    }

    @Override
    public void nodeModelChanged(FlowNode flowNode) {
        if (this.isFlagNodeValid()) {
            this.checkFlag(flowNode);
        }
        this.checkRSyntax(flowNode);
        this.checkRPackage(flowNode);
        this.checkValueError(flowNode);
    }

    @Override
    public void subflowNodeModelChanged(FlowNode flowNode) {
        if (this.isFlagNodeValid()) {
            this.checkFlag(flowNode);
        }
        this.checkRSyntax(flowNode);
        this.checkRPackage(flowNode);
        this.checkBoxConnection(flowNode);
    }

    private void checkBoxConnection(FlowNode flowNode) {
        if (flowNode.getModel().isSubflow()) {
            SubflowNodeModel subflowNodeModel = (SubflowNodeModel)flowNode.getModel();
            if (subflowNodeModel.isInOutConnected()) {
                this.removeError(flowNode, BoxConnectionError.class);
            } else {
                this.setError(flowNode, new BoxConnectionError());
            }
        }
    }

    public void checkRSyntax(FlowNode flowNode) {
        if (flowNode.getModel() instanceof UINodeModel) {
            return;
        }
        String string = R.client().checkSyntax(flowNode.getModel().getCommandNoTab());
        if (string == null) {
            this.removeError(flowNode, RSyntaxFlowError.class);
        } else {
            this.setError(flowNode, new RSyntaxFlowError(string));
        }
    }

    public void checkRPackage(FlowNode flowNode) {
        RPackage[] rPackageArray = RPackage.getRPackages(flowNode.getModel());
        ArrayList<String> arrayList = null;
        if (rPackageArray != null) {
            for (RPackage rPackage : rPackageArray) {
                if (R.client().isInstalledPackage(rPackage.getName())) continue;
                if (arrayList == null) {
                    arrayList = new ArrayList<String>();
                }
                arrayList.add(rPackage.getName());
            }
        }
        if (arrayList == null) {
            this.removeError(flowNode, RPackageError.class);
        } else {
            this.setError(flowNode, new RPackageError(arrayList));
        }
    }

    public void checkValueError(FlowNode flowNode) {
        ValueError valueError = flowNode.getValueError();
        if (valueError != null && valueError.getLevel() < 4) {
            valueError = null;
        }
        if (valueError == null) {
            this.removeError(flowNode, ValueFlowError.class);
        } else {
            this.setError(flowNode, new ValueFlowError(valueError));
        }
    }

    public void edgeAdded(GraphEvent graphEvent) {
        if (!this.isFlagNodeValid()) {
            return;
        }
        FlowEdge flowEdge = (FlowEdge)graphEvent.getGraphElement();
        FlowNode flowNode = FlowNode.getTopClosedSubflowNode(flowEdge);
        if (flowNode != null) {
            this.checkFlag(flowNode);
        } else {
            this.checkFlagFirst(flowEdge.getSource());
        }
    }

    public void edgeRemoved(GraphEvent graphEvent) {
        if (!this.isFlagNodeValid()) {
            return;
        }
        FlowEdge flowEdge = (FlowEdge)graphEvent.getGraphElement();
        FlowNode flowNode = FlowNode.getTopClosedSubflowNode(flowEdge);
        if (flowNode != null) {
            this.checkFlag(flowNode);
        } else {
            FlowNode flowNode2 = ((FlowEdge)graphEvent.getGraphElement()).getDest();
            this.checkFlagFirst(flowNode2);
        }
    }

    public void vertexAdded(GraphEvent graphEvent) {
        FlowNode flowNode = (FlowNode)graphEvent.getGraphElement();
        FlowGraph flowGraph = (FlowGraph)graphEvent.getGraph();
        if (!flowGraph.isAdjusting()) {
            this.checkRSyntax(flowNode);
            this.checkRPackage(flowNode);
            this.checkValueError(flowNode);
        }
        this.checkBoxConnection(flowNode);
    }

    public void vertexRemoved(GraphEvent graphEvent) {
        FlowNode flowNode = (FlowNode)graphEvent.getGraphElement();
        FlowGraph flowGraph = (FlowGraph)graphEvent.getGraph();
        if (!flowGraph.isAdjusting()) {
            this.removeError(flowNode);
            for (FlowNode object : FlowUtil.getAllDescendants(flowNode)) {
                this.removeError(object);
            }
        }
        if (this.isFlagNodeValid()) {
            if (this.isFlagNode(flowNode)) {
                this.clearFlagNode();
            } else if (flowNode.getModel().isSubflow()) {
                SubflowNodeModel subflowNodeModel = (SubflowNodeModel)flowNode.getModel();
                Set<FlowNode> set = FlowUtil.getAllDescendants(subflowNodeModel);
                for (FlowNode flowNode2 : set) {
                    if (!this.isFlagNode(flowNode2)) continue;
                    this.clearFlagNode();
                    break;
                }
            }
        }
    }

    private void checkFlag(FlowNode flowNode) {
        List<FlowNode> list = FlowUtil.getStream(this.flagNode, false, false, false);
        for (FlowNode flowNode2 : list) {
            if (flowNode2 != flowNode) continue;
            this.clearFlagNode();
            break;
        }
    }

    private void checkFlagFirst(FlowNode flowNode) {
        List<FlowNode> list = FlowUtil.getStream(this.flagNode, false, false, false);
        FlowNode flowNode2 = list.get(0);
        if (flowNode == flowNode2) {
            this.clearFlagNode();
        }
    }

    private boolean isFlagNodeValid() {
        return this.flagNode != null && this.flagNode.getGraph() != null;
    }

    @Override
    public void onEvent(SimpleEvent simpleEvent) {
        if (CacheEvent.class.equals(simpleEvent.getClass())) {
            this.cacheScopeSet.clear();
            for (FlowNode flowNode : this.getCacheNodes()) {
                if (flowNode.getGraph() == null || !flowNode.isCacheData() || !flowNode.getCacheData().isValid()) continue;
                List<FlowNode> list = FlowUtil.getStream(flowNode, true, false, false);
                this.cacheScopeSet.addAll(list);
            }
        }
    }

    @Override
    public void activeViewerChanged(FlowViewer flowViewer) {
        boolean bl;
        boolean bl2 = bl = flowViewer != null && flowViewer.getFlowModel() == this.flowModel;
        if (!bl || flowViewer == null) {
            this.setHighlightNode(null);
        } else {
            this.setHighlightNode(flowViewer.getGraph().getParentNode());
        }
    }
}

