/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.flow;

import com.ef_prime.rflow.core.flow.FlowEdge;
import com.ef_prime.rflow.core.flow.FlowError;
import com.ef_prime.rflow.core.flow.FlowGraph;
import com.ef_prime.rflow.core.flow.FlowLayout;
import com.ef_prime.rflow.core.flow.FlowModel;
import com.ef_prime.rflow.core.flow.FlowNode;
import com.ef_prime.rflow.core.flow.FlowSegment;
import com.ef_prime.rflow.core.flow.FlowState;
import com.ef_prime.rflow.core.flow.NodeSelectionInfo;
import com.ef_prime.rflow.node.base.SubflowNodeModel;
import com.ef_prime.rflow.node.base.TunnelNodeModel;
import com.ef_prime.rflow.ui.flow.UndoableEditFactory;
import edu.uci.ics.jung.graph.ArchetypeVertex;
import edu.uci.ics.jung.graph.Edge;
import edu.uci.ics.jung.graph.Vertex;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.swing.undo.CompoundEdit;
import org.apache.commons.collections.buffer.UnboundedFifoBuffer;

public class FlowUtil {
    public static List<FlowNode> getStream(FlowNode flowNode, boolean bl, boolean bl2, boolean bl3) {
        ArrayList<FlowNode> arrayList = new ArrayList<FlowNode>();
        FlowUtil.getStream(flowNode, arrayList, bl, bl3);
        if (!arrayList.isEmpty() && flowNode.getGraph() != null && !flowNode.getGraph().isRootGraph()) {
            FlowGraph flowGraph = flowNode.getGraph();
            FlowNode flowNode2 = (FlowNode)arrayList.get(arrayList.size() - 1);
            while (flowGraph != null && !flowGraph.isRootGraph() && flowNode2.getModel() == TunnelNodeModel.inModel && flowGraph.contains((Vertex)flowNode2)) {
                FlowNode flowNode3;
                FlowNode flowNode4 = flowGraph.getParentNode();
                if (!(!bl2 || bl3 && flowNode4.getModel().isDisabled())) {
                    arrayList.add(flowNode4);
                }
                if ((flowNode3 = flowNode4.getPreviousNode()) != null) {
                    FlowUtil.getStream(flowNode3, arrayList, bl, bl3);
                }
                flowGraph = flowNode4.getGraph();
                flowNode2 = (FlowNode)arrayList.get(arrayList.size() - 1);
            }
        }
        Collections.reverse(arrayList);
        return arrayList;
    }

    private static void getStream(FlowNode flowNode, List<FlowNode> list, boolean bl, boolean bl2) {
        Object object;
        if (!bl2 || !flowNode.getModel().isDisabled()) {
            list.add(flowNode);
            if (flowNode.getModel().isOpenSubflow()) {
                object = (SubflowNodeModel)flowNode.getModel();
                if (!bl) {
                    list.remove(list.size() - 1);
                }
                FlowUtil.getStream(((SubflowNodeModel)object).getOut(), list, bl, bl2);
            }
        }
        if (flowNode.getModel().isSubflow() && !((SubflowNodeModel)flowNode.getModel()).isInOutConnected()) {
            return;
        }
        object = flowNode.getPreviousNode();
        if (object != null) {
            FlowUtil.getStream((FlowNode)object, list, bl, bl2);
        }
    }

    public static List<FlowNode> getStreamSimple(FlowNode flowNode) {
        ArrayList<FlowNode> arrayList = new ArrayList<FlowNode>();
        FlowUtil.getStreamSimple(flowNode, arrayList);
        Collections.reverse(arrayList);
        return arrayList;
    }

    private static void getStreamSimple(FlowNode flowNode, List<FlowNode> list) {
        list.add(flowNode);
        if (flowNode.getModel().isSubflow() && !((SubflowNodeModel)flowNode.getModel()).isInOutConnected()) {
            return;
        }
        FlowNode flowNode2 = flowNode.getPreviousNode();
        if (flowNode2 != null) {
            FlowUtil.getStreamSimple(flowNode2, list);
        }
    }

    public static boolean isEdgeAddable(FlowEdge flowEdge) {
        FlowNode flowNode = flowEdge.getDest();
        if (flowNode.inDegree() > 0) {
            return false;
        }
        return FlowUtil.checkLoop(flowEdge.getSource(), flowNode);
    }

    public static boolean checkLoop(FlowNode flowNode, FlowNode flowNode2) {
        if (flowNode2.getPredecessors().contains(flowNode)) {
            return false;
        }
        while (flowNode.inDegree() > 0) {
            if (!(flowNode = flowNode.getPreviousNode()).equals(flowNode2)) continue;
            return false;
        }
        return true;
    }

    public static NodeSelectionInfo[] getNodeSelectionInfos(FlowNode[] flowNodeArray, boolean bl) {
        FlowNode flowNode;
        HashSet<FlowNode> hashSet = new HashSet<FlowNode>(Arrays.asList(flowNodeArray));
        List<Set<FlowNode>> list = FlowUtil.extractCluster(hashSet);
        ArrayList<FlowNode> arrayList = new ArrayList<FlowNode>();
        for (Set<FlowNode> set : list) {
            flowNode = set.iterator().next();
            arrayList.add(FlowUtil.getSource(flowNode, set));
        }
        HashSet hashSet2 = new HashSet();
        for (int i = 0; i < list.size(); ++i) {
            flowNode = (FlowNode)arrayList.get(i);
            if (bl && flowNode.inDegree() == 0) continue;
            FlowNode flowNode2 = !bl && flowNode.inDegree() == 0 ? null : flowNode.getPreviousNode();
            HashSet<FlowNode> hashSet3 = new HashSet<FlowNode>();
            FlowUtil.getOutOfNodes(flowNode, hashSet3, list.get(i));
            if (bl && hashSet3.isEmpty()) continue;
            if (!bl && hashSet3.isEmpty()) {
                hashSet2.add(new NodeSelectionInfo(flowNode2, null, flowNode));
                continue;
            }
            for (FlowNode flowNode3 : hashSet3) {
                hashSet2.add(new NodeSelectionInfo(flowNode2, flowNode3, flowNode));
            }
        }
        return hashSet2.toArray(new NodeSelectionInfo[0]);
    }

    public static FlowNode getSource(FlowNode flowNode, Set<FlowNode> set) {
        if (flowNode.inDegree() == 0) {
            return flowNode;
        }
        FlowNode flowNode2 = flowNode.getPreviousNode();
        if (set.contains(flowNode2)) {
            return FlowUtil.getSource(flowNode2, set);
        }
        return flowNode;
    }

    private static void getOutOfNodes(FlowNode flowNode, Set<FlowNode> set, Set<FlowNode> set2) {
        if (flowNode.outDegree() == 0) {
            return;
        }
        for (Object e : flowNode.getSuccessors()) {
            FlowNode flowNode2 = (FlowNode)e;
            if (set2.contains(flowNode2)) {
                FlowUtil.getOutOfNodes(flowNode2, set, set2);
                continue;
            }
            set.add(flowNode2);
        }
    }

    public static Set<FlowNode> getEndOfNodes(FlowNode flowNode, Set<FlowNode> set) {
        HashSet<FlowNode> hashSet = new HashSet<FlowNode>();
        FlowUtil.getEndOfNodes(flowNode, hashSet, set);
        return hashSet;
    }

    private static void getEndOfNodes(FlowNode flowNode, Set<FlowNode> set, Set<FlowNode> set2) {
        if (flowNode.outDegree() == 0) {
            set.add(flowNode);
        } else {
            boolean bl = false;
            for (Object e : flowNode.getSuccessors()) {
                FlowNode flowNode2 = (FlowNode)e;
                if (!set2.contains(flowNode2)) continue;
                FlowUtil.getEndOfNodes(flowNode2, set, set2);
                bl = true;
            }
            if (!bl) {
                set.add(flowNode);
            }
        }
    }

    public static List<Set<FlowNode>> extractCluster(Set<FlowNode> set) {
        ArrayList<Set<FlowNode>> arrayList = new ArrayList<Set<FlowNode>>();
        HashSet<FlowNode> hashSet = new HashSet<FlowNode>(set);
        while (!hashSet.isEmpty()) {
            HashSet<FlowNode> hashSet2 = new HashSet<FlowNode>();
            FlowNode flowNode = hashSet.iterator().next();
            hashSet.remove(flowNode);
            hashSet2.add(flowNode);
            UnboundedFifoBuffer unboundedFifoBuffer = new UnboundedFifoBuffer();
            unboundedFifoBuffer.add((Object)flowNode);
            while (!unboundedFifoBuffer.isEmpty()) {
                ArchetypeVertex archetypeVertex = (ArchetypeVertex)unboundedFifoBuffer.remove();
                Set set2 = archetypeVertex.getNeighbors();
                for (FlowNode flowNode2 : set2) {
                    if (!hashSet.contains(flowNode2)) continue;
                    unboundedFifoBuffer.add((Object)flowNode2);
                    hashSet.remove(flowNode2);
                    hashSet2.add(flowNode2);
                }
            }
            arrayList.add(hashSet2);
        }
        return arrayList;
    }

    public static void takeOut(FlowNode[] flowNodeArray, boolean bl, UndoableEditFactory undoableEditFactory, CompoundEdit compoundEdit) {
        NodeSelectionInfo[] nodeSelectionInfoArray;
        for (NodeSelectionInfo nodeSelectionInfo : nodeSelectionInfoArray = FlowUtil.getNodeSelectionInfos(flowNodeArray, false)) {
            FlowUtil.takeOut(nodeSelectionInfo, bl, undoableEditFactory, compoundEdit);
        }
    }

    public static void takeOut(NodeSelectionInfo nodeSelectionInfo, boolean bl, UndoableEditFactory undoableEditFactory, CompoundEdit compoundEdit) {
        FlowEdge flowEdge;
        FlowGraph flowGraph = nodeSelectionInfo.getSource().getGraph();
        if (flowGraph == null) {
            return;
        }
        if (!bl && nodeSelectionInfo.getIn() != null && (flowEdge = nodeSelectionInfo.getIn().findEdge((Vertex)nodeSelectionInfo.getSource())) != null && flowGraph.getEdges().contains((Object)flowEdge)) {
            flowGraph.removeEdge((Edge)flowEdge);
            compoundEdit.addEdit(undoableEditFactory.createDeleteEdit(null, new FlowEdge[]{flowEdge}));
        }
        if (nodeSelectionInfo.getOut() != null) {
            FlowEdge flowEdge2;
            flowEdge = nodeSelectionInfo.getOut().getInEdge();
            if (flowEdge != null && flowGraph.getEdges().contains((Object)flowEdge)) {
                flowGraph.removeEdge((Edge)flowEdge);
                compoundEdit.addEdit(undoableEditFactory.createDeleteEdit(null, new FlowEdge[]{flowEdge}));
            }
            if (nodeSelectionInfo.getIn() != null && FlowUtil.isEdgeAddable(flowEdge2 = new FlowEdge((Vertex)nodeSelectionInfo.getIn(), (Vertex)nodeSelectionInfo.getOut()))) {
                flowGraph.addEdge((Edge)flowEdge2);
                compoundEdit.addEdit(undoableEditFactory.createAddEdgeEdit(new FlowEdge[]{flowEdge2}));
            }
        }
    }

    public static FlowNode getInOfCluster(Set<FlowNode> set) {
        return FlowUtil.getRootOfCluster(set).getPreviousNode();
    }

    public static FlowNode getRootOfCluster(Set<FlowNode> set) {
        return FlowUtil.getSource(set.iterator().next(), set);
    }

    public static Set<FlowNode> getEndsOfCluster(Set<FlowNode> set) {
        return FlowUtil.getLastChildren(FlowUtil.getRootOfCluster(set), set);
    }

    public static Set<FlowNode> getOutsOfCluster(Set<FlowNode> set) {
        HashSet<FlowNode> hashSet = new HashSet<FlowNode>();
        for (FlowNode flowNode : FlowUtil.getEndsOfCluster(set)) {
            hashSet.addAll(flowNode.getSuccessors());
        }
        return hashSet;
    }

    public static Set<FlowNode> getLastChildren(FlowNode flowNode, Set<FlowNode> set) {
        HashSet<FlowNode> hashSet = new HashSet<FlowNode>();
        FlowUtil.getLastChildren(flowNode, set, hashSet);
        return hashSet;
    }

    private static void getLastChildren(FlowNode flowNode, Set<FlowNode> set, Set<FlowNode> set2) {
        if (flowNode.outDegree() == 0) {
            set2.add(flowNode);
            return;
        }
        for (Object e : flowNode.getSuccessors()) {
            FlowNode flowNode2 = (FlowNode)e;
            if (set.contains(flowNode2)) {
                FlowUtil.getLastChildren(flowNode2, set, set2);
                continue;
            }
            set2.add(flowNode);
        }
    }

    public static boolean isHeadInNode(FlowNode flowNode) {
        FlowNode flowNode2 = flowNode.getPreviousNode();
        while (flowNode2 != null) {
            flowNode = flowNode2;
            flowNode2 = flowNode.getPreviousNode();
        }
        return flowNode.getModel() == TunnelNodeModel.inModel;
    }

    public static boolean isFamilyMember(FlowNode flowNode, FlowNode flowNode2) {
        for (FlowNode flowNode3 = flowNode; flowNode3 != null; flowNode3 = flowNode3.getParentNode()) {
            if (!flowNode3.equals(flowNode2)) continue;
            return true;
        }
        if (flowNode.equals(flowNode2)) {
            return true;
        }
        Set<FlowNode> set = FlowUtil.getAllDescendants(flowNode);
        return set.contains(flowNode2);
    }

    public static Set<FlowNode> getAllNodes(FlowGraph flowGraph) {
        HashSet<FlowNode> hashSet = new HashSet<FlowNode>();
        for (Object e : flowGraph.getVertices()) {
            FlowNode flowNode = (FlowNode)e;
            hashSet.add(flowNode);
            hashSet.addAll(FlowUtil.getAllDescendants(flowNode));
        }
        return hashSet;
    }

    public static Set<FlowNode> getAllDescendants(FlowNode flowNode) {
        if (flowNode.getModel().isSubflow()) {
            return FlowUtil.getAllDescendants((SubflowNodeModel)flowNode.getModel());
        }
        return new HashSet<FlowNode>();
    }

    public static Set<FlowNode> getAllDescendants(SubflowNodeModel subflowNodeModel) {
        HashSet<FlowNode> hashSet = new HashSet<FlowNode>();
        FlowUtil.getAllDescendants(subflowNodeModel, hashSet);
        return hashSet;
    }

    private static void getAllDescendants(SubflowNodeModel subflowNodeModel, Set<FlowNode> set) {
        for (FlowGraph flowGraph : subflowNodeModel.getGraphs()) {
            for (Object e : flowGraph.getVertices()) {
                FlowNode flowNode = (FlowNode)e;
                set.add(flowNode);
                if (!flowNode.getModel().isSubflow()) continue;
                FlowUtil.getAllDescendants((SubflowNodeModel)flowNode.getModel(), set);
            }
        }
    }

    public static FlowSegment getFlowSegment(Set<FlowNode> set) {
        if (set.isEmpty()) {
            return null;
        }
        if (FlowUtil.extractCluster(set).size() > 1) {
            return null;
        }
        FlowNode flowNode = FlowUtil.getSource(set.iterator().next(), set);
        Set<FlowNode> set2 = FlowUtil.getEndOfNodes(flowNode, set);
        if (set2.size() > 1) {
            return null;
        }
        FlowNode flowNode2 = set2.iterator().next();
        if (flowNode == flowNode2 && !flowNode.getModel().isExecutable()) {
            return null;
        }
        return new FlowSegment(flowNode, flowNode2);
    }

    public static boolean isExecutable(FlowSegment flowSegment) {
        if (flowSegment == null) {
            return false;
        }
        FlowNode flowNode = flowSegment.getEnd();
        Optional<FlowModel> optional = flowNode.getFlowModel();
        if (!optional.isPresent()) {
            return true;
        }
        FlowState flowState = optional.get().getState();
        while (flowNode != null) {
            List<FlowError> list = flowState.getError(flowNode);
            if (list != null) {
                for (FlowError flowError : list) {
                    if (flowError.isExecutable()) continue;
                    return false;
                }
            }
            if (flowSegment.getStart().equals(flowNode)) break;
            flowNode = flowNode.getPreviousNode();
        }
        return true;
    }

    public static Map<FlowNode, Integer> smartSortMap(Collection<FlowNode> collection, FlowLayout flowLayout) {
        List<FlowNode> list = FlowUtil.smartSort(collection, flowLayout);
        HashMap<FlowNode, Integer> hashMap = new HashMap<FlowNode, Integer>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            hashMap.put(list.get(i), i);
        }
        return hashMap;
    }

    public static List<FlowNode> smartSort(Collection<FlowNode> collection, FlowLayout flowLayout) {
        ArrayList<FlowNode> arrayList = new ArrayList<FlowNode>(collection.size());
        Set<FlowNode> set = FlowUtil.getRootNodes(collection);
        List<FlowNode> list = FlowUtil.sortByLocation(set, flowLayout);
        for (FlowNode flowNode : list) {
            arrayList.addAll(FlowUtil.sortCluster(flowNode, flowLayout));
        }
        return arrayList;
    }

    public static Set<FlowNode> getRootNodes(Collection<FlowNode> collection) {
        HashSet<FlowNode> hashSet = new HashSet<FlowNode>();
        for (FlowNode flowNode : collection) {
            if (flowNode.inDegree() != 0) continue;
            hashSet.add(flowNode);
        }
        return hashSet;
    }

    public static List<FlowNode> sortByLocation(Collection<FlowNode> collection, FlowLayout flowLayout) {
        ArrayList<FlowNode> arrayList = new ArrayList<FlowNode>(collection);
        Collections.sort(arrayList, flowLayout.getLayoutNodeComparator());
        return arrayList;
    }

    public static List<FlowNode> sortCluster(FlowNode flowNode, FlowLayout flowLayout) {
        ArrayList<FlowNode> arrayList = new ArrayList<FlowNode>();
        ArrayDeque<FlowNode> arrayDeque = new ArrayDeque<FlowNode>();
        arrayDeque.push(flowNode);
        while (!arrayDeque.isEmpty()) {
            FlowNode flowNode2 = (FlowNode)arrayDeque.pop();
            arrayList.add(flowNode2);
            Set<FlowNode> set = flowNode2.getNexts();
            if (set.isEmpty()) continue;
            List<FlowNode> list = FlowUtil.sortByLocation(set, flowLayout);
            for (int i = list.size() - 1; i >= 0; --i) {
                arrayDeque.push(list.get(i));
            }
        }
        return arrayList;
    }
}

