/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.flow;

import com.ef_prime.rflow.core.app.r.RAddonBuilderModel;
import com.ef_prime.rflow.core.app.r.RAddonOp;
import com.ef_prime.rflow.core.app.r.base.RPackage;
import com.ef_prime.rflow.core.common.xml.XmlContext;
import com.ef_prime.rflow.core.common.xml.XmlUtility;
import com.ef_prime.rflow.core.flow.CacheData;
import com.ef_prime.rflow.core.flow.ElementReader;
import com.ef_prime.rflow.core.flow.FlowEdge;
import com.ef_prime.rflow.core.flow.FlowGraph;
import com.ef_prime.rflow.core.flow.FlowLayout;
import com.ef_prime.rflow.core.flow.FlowNode;
import com.ef_prime.rflow.core.flow.FlowProperties;
import com.ef_prime.rflow.core.flow.FlowSettings;
import com.ef_prime.rflow.core.flow.FlowState;
import com.ef_prime.rflow.core.flow.GraphElements;
import com.ef_prime.rflow.core.flow.SingleElementReader;
import com.ef_prime.rflow.core.flow.ViewLayout;
import com.ef_prime.rflow.core.flow.task.NodeTask;
import com.ef_prime.rflow.core.flow.task.NodeTaskEntry;
import com.ef_prime.rflow.core.flow.task.NodeTaskGroup;
import com.ef_prime.rflow.core.flow.task.NodeTaskProperty;
import com.ef_prime.rflow.core.node.UnknownNodeModel;
import com.ef_prime.rflow.core.util.CancelledSaxException;
import com.ef_prime.rflow.core.util.Version;
import com.ef_prime.rflow.core.util.YamlEx;
import com.ef_prime.rflow.node.ModelCreationFailedException;
import com.ef_prime.rflow.node.NodeComment;
import com.ef_prime.rflow.node.NodeModel;
import com.ef_prime.rflow.node.NodeModelController;
import com.ef_prime.rflow.node.NodeModelManager;
import com.ef_prime.rflow.node.NodeProperty;
import com.ef_prime.rflow.node.base.FreeNodeModel;
import com.ef_prime.rflow.node.group.DefaultAppearanceGroup;
import com.ef_prime.rflow.node.ui.OpManager;
import com.ef_prime.rflow.node.ui.Operation;
import com.ef_prime.rflow.node.ui.RAddonOpData;
import com.ef_prime.rflow.node.ui.UINodeModel;
import com.ef_prime.rflow.node.ui.UINodeModelController;
import com.ef_prime.rflow.resource.Messages;
import com.ef_prime.rflow.ui.common.component.ChoiceHandler;
import edu.uci.ics.jung.graph.Edge;
import edu.uci.ics.jung.graph.Vertex;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class GraphReader
extends ElementReader
implements GraphElements {
    private static final Logger LOGGER = Logger.getLogger(GraphReader.class.getName());
    private static Map<String, String> NODETYPE_MAP = new HashMap<String, String>();
    private FlowGraph graph = new FlowGraph();
    private Map<Vertex, Point2D> locationMap = new HashMap<Vertex, Point2D>();
    private Dimension size;
    private boolean loc_type_absolute = false;
    private Point offset = new Point(0, 0);
    private Map<Integer, Vertex> idToNodeMap = new HashMap<Integer, Vertex>();
    private Map<String, String> nodeInfoMap = new HashMap<String, String>();
    private NodeComment comment = null;
    private FlowSettings flowSettings = new FlowSettings();
    private FlowState state = new FlowState();
    private Properties properties = new Properties();
    private List<ViewLayout> subflows = new ArrayList<ViewLayout>();
    private boolean inOption = false;
    private NodeModel currentModel;
    private Operation currentVersionOp;
    private List<RPackage> userPackages;
    private List<RPackage> nodePackages;
    private GraphReader parentReader;
    private boolean isOverlay;
    private GraphReader overlayReader = null;
    private double graphFileVersion;
    private String uidef;
    private FlowProperties flowProperties = new FlowProperties();
    private NodeTask currentTaskGroup = null;
    private NodeTask currentTask = null;
    private boolean inTaskProperty;
    private NodeTaskProperty currentTaskProperty;

    public GraphReader(ChoiceHandler choiceHandler, Dimension dimension) {
        this(choiceHandler, dimension, -1.0, null, null);
    }

    private GraphReader(ChoiceHandler choiceHandler, Dimension dimension, double d, GraphReader graphReader, Map<Integer, Vertex> map) {
        this.size = dimension;
        this.parentReader = graphReader;
        this.graphFileVersion = d;
        if (map != null) {
            this.idToNodeMap = map;
        }
        this.addOverlaySingleElementReader("graph", new GraphElementReader(choiceHandler));
        this.addOverlaySingleElementReader("node", new NodeReader());
        this.addOverlaySingleElementReader("command", new CommandReader());
        this.addOverlaySingleElementReader("property", new PropertyReader());
        this.addOverlaySingleElementReader("comment", new CommentReader());
        this.addOverlaySingleElementReader("cache", new CacheReader());
        this.addOverlaySingleElementReader("break", new BreakpointReader());
        this.addOverlaySingleElementReader("entry", new EntryReader());
        this.addOverlaySingleElementReader("option", new OptionReader());
        this.addOverlaySingleElementReader("package", new PackageReader());
        this.addOverlaySingleElementReader("subflow", new SubflowReader(choiceHandler));
        this.addOverlaySingleElementReader("edge", new EdgeReader());
        this.addOverlaySingleElementReader("properties", new PropertiesReader());
        this.addOverlaySingleElementReader("ui", new UIReader());
        this.addOverlaySingleElementReader("uidef", new UIDefReader());
        this.addOverlaySingleElementReader("taskgroup", new TaskGroupReader());
        this.addOverlaySingleElementReader("taskentry", new TaskEntryReader());
        this.addOverlaySingleElementReader("taskproperty", new TaskPropertyReader());
    }

    public ViewLayout getViewLayout() {
        if (!this.loc_type_absolute) {
            for (Map.Entry object : this.locationMap.entrySet()) {
                Point2D point2D = (Point2D)object.getValue();
                Point2D.Double double_ = new Point2D.Double(this.size.getWidth() * point2D.getX(), this.size.getHeight() * point2D.getY());
                this.locationMap.put((Vertex)object.getKey(), double_);
            }
        }
        FlowLayout flowLayout = new FlowLayout(this.graph);
        for (Map.Entry<Vertex, Point2D> entry : this.locationMap.entrySet()) {
            flowLayout.addVertex(entry.getKey(), entry.getValue().getX(), entry.getValue().getY());
        }
        return new ViewLayout(flowLayout, this.size, this.offset);
    }

    public FlowSettings getFlowSettings() {
        if (this.flowSettings.isEmpty()) {
            return null;
        }
        return this.flowSettings;
    }

    public FlowProperties getFlowProperties() {
        return this.flowProperties;
    }

    public FlowState getFlowState() {
        return this.state;
    }

    public NodeTask getRootTask() {
        return this.currentTask;
    }

    void addOverlaySingleElementReader(String string, SingleElementReader singleElementReader) {
        this.addSingleElementReader(string, new OverlaySingleElementReader(string, singleElementReader));
    }

    static {
        NODETYPE_MAP.put("com.ef_prime.rflow.node.base.SentenceNodeModel", FreeNodeModel.class.getName());
    }

    private final class GraphElementReader
    extends SingleElementReader {
        private ChoiceHandler choiceHandler;

        private GraphElementReader(ChoiceHandler choiceHandler) {
            this.choiceHandler = choiceHandler;
        }

        @Override
        public void startElement(Attributes attributes) throws SAXException {
            String string;
            if (GraphReader.this.graphFileVersion < 0.0) {
                double d = Double.valueOf("0.9");
                string = attributes.getValue("version");
                if (string != null && GraphReader.this.parentReader == null) {
                    int n;
                    GraphReader.this.graphFileVersion = Double.valueOf(attributes.getValue("version"));
                    if (d < GraphReader.this.graphFileVersion && (n = this.choiceHandler.makeChoice(Messages.getString("Error.new_type_file"), 2, 0)) != 0) {
                        throw new CancelledSaxException();
                    }
                } else {
                    GraphReader.this.graphFileVersion = 0.0;
                }
            }
            String string2 = attributes.getValue("width");
            String string3 = attributes.getValue("height");
            if (string2 != null && string3 != null) {
                GraphReader.this.size = new Dimension(Integer.valueOf(string2), Integer.valueOf(string3));
            }
            GraphReader.this.loc_type_absolute = (string = attributes.getValue("locationtype")) != null && string.equals("a");
            String string4 = attributes.getValue("offsetx");
            String string5 = attributes.getValue("offsety");
            if (string4 != null && string5 != null) {
                GraphReader.this.offset = new Point(Integer.valueOf(string4), Integer.valueOf(string5));
            }
        }

        @Override
        public void endElement(String string, Element element) throws SAXException {
            if (GraphReader.this.parentReader != null) {
                GraphReader.this.parentReader.isOverlay = false;
            }
        }
    }

    private final class NodeReader
    extends SingleElementReader {
        private NodeReader() {
        }

        @Override
        public void startElement(Attributes attributes) {
            GraphReader.this.nodeInfoMap.clear();
            GraphReader.this.comment = null;
            GraphReader.this.nodeInfoMap.put("id", attributes.getValue("id"));
            GraphReader.this.nodeInfoMap.put("date", attributes.getValue("date"));
            GraphReader.this.nodeInfoMap.put("uid", attributes.getValue("uid"));
            GraphReader.this.nodeInfoMap.put("title", attributes.getValue("title"));
            GraphReader.this.nodeInfoMap.put("x", attributes.getValue("x"));
            GraphReader.this.nodeInfoMap.put("y", attributes.getValue("y"));
            GraphReader.this.nodeInfoMap.put("cache", attributes.getValue("cache"));
            GraphReader.this.nodeInfoMap.put("disabled", attributes.getValue("disabled"));
            GraphReader.this.nodeInfoMap.put("mode", attributes.getValue("mode"));
            GraphReader.this.currentModel = null;
            GraphReader.this.currentVersionOp = null;
            GraphReader.this.userPackages = new ArrayList<RPackage>();
            GraphReader.this.nodePackages = new ArrayList<RPackage>();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void endElement(String string, Element element) {
            String string2;
            void var8_11;
            String[] stringArray;
            Object object;
            if (GraphReader.this.currentModel == null) {
                GraphReader.this.currentModel = new UnknownNodeModel(element, GraphReader.this.currentVersionOp);
            }
            GraphReader.this.currentModel.setSavedCommand(GraphReader.this.nodeInfoMap.get("command"));
            if (GraphReader.this.currentModel.isSavedCommandMode()) {
                GraphReader.this.currentModel.setSavedElement(element);
            }
            ArrayList<RPackage> arrayList = new ArrayList<RPackage>();
            arrayList.addAll(GraphReader.this.nodePackages);
            arrayList.addAll(GraphReader.this.userPackages);
            GraphReader.this.currentModel.setSavedPackageList(arrayList);
            NodeProperty nodeProperty = NodeProperty.createDefaultProperty();
            nodeProperty.setTitle(GraphReader.this.nodeInfoMap.get("title"));
            String string3 = GraphReader.this.nodeInfoMap.get("shape");
            if (string3 != null && (object = DefaultAppearanceGroup.valueOf(string3)) != null) {
                nodeProperty.setAppearanceGroup(((DefaultAppearanceGroup)((Object)object)).getAppearanceGroup());
            }
            if ((object = GraphReader.this.nodeInfoMap.get("break")) != null && GraphReader.this.currentModel.canSetBreakpoint()) {
                for (String string22 : stringArray = ((String)object).split(",")) {
                    try {
                        GraphReader.this.currentModel.getBreakpoints().add(Integer.valueOf(string22));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                Collections.sort(GraphReader.this.currentModel.getBreakpoints(), NodeModel.ABS_COMPARATOR);
            }
            stringArray = GraphReader.this.nodeInfoMap.get("date");
            String string4 = GraphReader.this.nodeInfoMap.get("uid");
            if (string4 == null) {
                String string5 = "";
            }
            FlowNode flowNode = new FlowNode(GraphReader.this.currentModel, nodeProperty, GraphReader.this.comment, (String)stringArray, (String)var8_11);
            GraphReader.this.graph.addVertex((Vertex)flowNode);
            GraphReader.this.idToNodeMap.put(Integer.valueOf(GraphReader.this.nodeInfoMap.get("id")), (Vertex)flowNode);
            if (!GraphReader.this.loc_type_absolute) {
                double d = Double.valueOf(GraphReader.this.nodeInfoMap.get("x"));
                double d2 = Double.valueOf(GraphReader.this.nodeInfoMap.get("y"));
                GraphReader.this.locationMap.put((Vertex)flowNode, new Point2D.Double(d, d2));
            } else {
                int n = Integer.valueOf(GraphReader.this.nodeInfoMap.get("x"));
                int n2 = Integer.valueOf(GraphReader.this.nodeInfoMap.get("y"));
                GraphReader.this.locationMap.put((Vertex)flowNode, new Point2D.Float(n, n2));
            }
            String string6 = GraphReader.this.nodeInfoMap.get("file");
            if (string6 != null) {
                String string7 = GraphReader.this.nodeInfoMap.get("date");
                String string8 = GraphReader.this.nodeInfoMap.get("size");
                String string9 = GraphReader.this.nodeInfoMap.get("gray");
                boolean bl = string9 == null || !Boolean.parseBoolean(string9);
                long l = string8 == null ? 0L : Long.parseLong(string8);
                File file = new File(string6 + ".RData");
                GraphReader.this.state.setCache(flowNode, new CacheData(file, null, CacheData.parseDate(string7), l, bl));
            }
            if ("true".equals(string2 = GraphReader.this.nodeInfoMap.get("disabled"))) {
                GraphReader.this.currentModel.setDisabled(true);
            }
        }
    }

    private final class CommandReader
    extends SingleElementReader {
        private CommandReader() {
        }

        @Override
        public void endElement(String string, Element element) {
            GraphReader.this.nodeInfoMap.put("command", string);
        }
    }

    private final class PropertyReader
    extends SingleElementReader {
        private PropertyReader() {
        }

        @Override
        public void startElement(Attributes attributes) {
            String string = attributes.getValue("title");
            if (string != null) {
                GraphReader.this.nodeInfoMap.put("title", string);
            }
            GraphReader.this.nodeInfoMap.put("shape", attributes.getValue("shape"));
        }
    }

    private final class CommentReader
    extends SingleElementReader {
        private String state;
        private String x;
        private String y;

        private CommentReader() {
        }

        @Override
        public void startElement(Attributes attributes) throws SAXException {
            this.state = attributes.getValue("state");
            this.x = attributes.getValue("x");
            this.y = attributes.getValue("y");
        }

        @Override
        public void endElement(String string, Element element) {
            NodeComment nodeComment = NodeComment.create();
            nodeComment.createComment();
            nodeComment.setText(string);
            if (this.state != null) {
                nodeComment.setState(this.state);
            }
            if (this.x != null && this.y != null) {
                nodeComment.getOffset().setLocation(Integer.parseInt(this.x), Integer.parseInt(this.y));
            }
            GraphReader.this.comment = nodeComment;
        }
    }

    private final class CacheReader
    extends SingleElementReader {
        private CacheReader() {
        }

        @Override
        public void startElement(Attributes attributes) throws SAXException {
            GraphReader.this.nodeInfoMap.put("file", attributes.getValue("file"));
            GraphReader.this.nodeInfoMap.put("hash", attributes.getValue("hash"));
            GraphReader.this.nodeInfoMap.put("date", attributes.getValue("date"));
            GraphReader.this.nodeInfoMap.put("size", attributes.getValue("size"));
            GraphReader.this.nodeInfoMap.put("gray", attributes.getValue("gray"));
        }
    }

    private final class BreakpointReader
    extends SingleElementReader {
        private BreakpointReader() {
        }

        @Override
        public void endElement(String string, Element element) throws SAXException {
            GraphReader.this.nodeInfoMap.put("break", string);
        }
    }

    private final class EntryReader
    extends SingleElementReader {
        private String key;

        private EntryReader() {
        }

        @Override
        public void startElement(Attributes attributes) {
            this.key = attributes.getValue("key");
        }

        @Override
        public void endElement(String string, Element element) {
            if (GraphReader.this.inTaskProperty) {
                GraphReader.this.currentTaskProperty.put(this.key, string);
            } else if (GraphReader.this.inOption) {
                GraphReader.this.properties.setProperty(this.key, string);
            } else {
                try {
                    GraphReader.this.flowSettings.readEntry(this.key, string);
                }
                catch (Exception exception) {
                    LOGGER.log(Level.SEVERE, "Failed to read a flow settings entry. key: " + this.key, exception);
                }
            }
        }
    }

    private final class OptionReader
    extends SingleElementReader {
        private OptionReader() {
        }

        @Override
        public void startElement(Attributes attributes) {
            String string = attributes.getValue("type");
            GraphReader.this.nodeInfoMap.put("type", string);
            GraphReader.this.properties.clear();
            GraphReader.this.subflows.clear();
            GraphReader.this.inOption = true;
            GraphReader.this.uidef = null;
        }

        @Override
        public void endElement(String string, Element element) {
            String string2;
            GraphReader.this.inOption = false;
            String string3 = GraphReader.this.nodeInfoMap.get("type");
            String string4 = GraphReader.this.nodeInfoMap.get("subflow_type");
            if ("list".equals(string4)) {
                string3 = "com.ef_prime.rflow.node.base.ListNodeModel";
            }
            if ((string2 = NODETYPE_MAP.get(string3)) != null) {
                string3 = string2;
            }
            NodeModelController nodeModelController = NodeModelManager.getModelController(string3);
            String string5 = GraphReader.this.nodeInfoMap.get("command");
            if (!(nodeModelController instanceof UINodeModelController) && nodeModelController != null) {
                try {
                    ViewLayout[] viewLayoutArray = GraphReader.this.subflows.toArray(new ViewLayout[0]);
                    Element element2 = XmlUtility.getChild("entryset", element);
                    GraphReader.this.currentModel = nodeModelController.createModel(GraphReader.this.properties, element2, string5, viewLayoutArray);
                }
                catch (ModelCreationFailedException modelCreationFailedException) {
                    LOGGER.log(Level.FINE, "Failed to read: " + string3, modelCreationFailedException);
                }
            }
        }
    }

    private final class PackageReader
    extends SingleElementReader {
        private PackageReader() {
        }

        @Override
        public void startElement(Attributes attributes) throws SAXException {
            String string = attributes.getValue("name");
            boolean bl = Boolean.valueOf(attributes.getValue("attach"));
            RPackage rPackage = new RPackage(string, true, bl);
            GraphReader.this.nodePackages.add(rPackage);
        }
    }

    private final class SubflowReader
    extends SingleElementReader {
        private ChoiceHandler choiceHandler;

        private SubflowReader(ChoiceHandler choiceHandler) {
            this.choiceHandler = choiceHandler;
        }

        @Override
        public void startElement(Attributes attributes) {
            GraphReader.this.isOverlay = true;
            String string = attributes.getValue("type");
            if ("list".equals(string)) {
                GraphReader.this.nodeInfoMap.put("subflow_type", string);
            }
            GraphReader.this.overlayReader = GraphReader.this.graphFileVersion < 0.3 ? new GraphReader(this.choiceHandler, null, GraphReader.this.graphFileVersion, GraphReader.this, null) : new GraphReader(this.choiceHandler, null, GraphReader.this.graphFileVersion, GraphReader.this, GraphReader.this.idToNodeMap);
        }

        @Override
        public void endElement(String string, Element element) {
            GraphReader.this.subflows.add(GraphReader.this.overlayReader.getViewLayout());
            GraphReader.this.state.add(GraphReader.this.overlayReader.getFlowState());
        }
    }

    private final class EdgeReader
    extends SingleElementReader {
        private EdgeReader() {
        }

        @Override
        public void startElement(Attributes attributes) {
            Vertex vertex = GraphReader.this.idToNodeMap.get(Integer.valueOf(attributes.getValue("from")));
            Vertex vertex2 = GraphReader.this.idToNodeMap.get(Integer.valueOf(attributes.getValue("to")));
            if (vertex == null || vertex2 == null) {
                return;
            }
            FlowEdge flowEdge = new FlowEdge(vertex, vertex2);
            GraphReader.this.graph.addEdge((Edge)flowEdge);
        }
    }

    private final class PropertiesReader
    extends SingleElementReader {
        private PropertiesReader() {
        }

        @Override
        public void endElement(String string, Element element) throws SAXException {
            GraphReader.this.flowProperties.loadElement(element, new XmlContext());
        }
    }

    private final class UIReader
    extends SingleElementReader {
        private XmlContext context = new XmlContext();

        private UIReader() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void endElement(String string, Element element) throws SAXException {
            try {
                Object object;
                Object object2;
                Operation operation = null;
                String string2 = element.getAttribute("cls");
                if (GraphReader.this.uidef != null) {
                    object2 = new RAddonBuilderModel(null);
                    ((RAddonBuilderModel)object2).load(new YamlEx().load(GraphReader.this.uidef));
                    object = ((RAddonBuilderModel)object2).getModelData(string2);
                    operation = new RAddonOp((RAddonOpData)object);
                    operation.loadResource();
                } else {
                    operation = OpManager.getInstance().getInstance(string2);
                    if (operation == null) {
                        LOGGER.severe("Failed to read class: " + string2);
                        return;
                    }
                }
                try {
                    String string3;
                    Object object3;
                    object2 = element.getAttribute("version");
                    object = StringUtils.isEmpty((CharSequence)object2) ? Version.ZERO : Version.parse((String)object2);
                    Version version = operation.getVersion();
                    if (((Version)object).isNewerThan(version)) {
                        GraphReader.this.currentVersionOp = operation;
                        return;
                    }
                    operation.setStopValidation(true);
                    boolean bl = false;
                    try {
                        operation.loadElement(element, this.context);
                        if (version.isNewerThan((Version)object)) {
                            operation.updateVersion((Version)object);
                            boolean bl2 = bl = !version.getVersionString().equals(((Version)object).getVersionString());
                        }
                        if (operation.isUpgradable()) {
                            object3 = operation.upgrade();
                            if (object3 == null) {
                                LOGGER.severe("Failed to upgrade class: " + (string2 == null ? operation.getTitle() : string2));
                            } else {
                                operation = object3;
                                bl = true;
                            }
                        }
                    }
                    finally {
                        operation.setStopValidation(false);
                    }
                    GraphReader.this.currentModel = new UINodeModel(operation);
                    if (bl && !Objects.equals(object3 = GraphReader.this.nodeInfoMap.get("command"), string3 = GraphReader.this.currentModel.getCommand())) {
                        boolean bl3 = "preserved".equals(GraphReader.this.nodeInfoMap.get("mode"));
                        GraphReader.this.currentModel.setNodeMode(bl3 ? NodeModel.NodeMode.PRESERVED : NodeModel.NodeMode.UPDATE);
                        GraphReader.this.currentModel.setRestorable(true);
                    }
                }
                catch (Exception exception) {
                    LOGGER.log(Level.SEVERE, "Failed to create class: " + (string2 == null ? operation.getTitle() : string2), exception);
                }
            }
            catch (Exception exception) {
                LOGGER.log(Level.SEVERE, exception.getMessage(), exception);
            }
        }
    }

    private final class UIDefReader
    extends SingleElementReader {
        private UIDefReader() {
        }

        @Override
        public void endElement(String string, Element element) throws SAXException {
            GraphReader.this.uidef = string;
        }
    }

    private final class TaskGroupReader
    extends SingleElementReader {
        private TaskGroupReader() {
        }

        @Override
        public void startElement(Attributes attributes) {
            GraphReader.this.currentTask = new NodeTaskGroup();
            if (GraphReader.this.currentTaskGroup != null) {
                GraphReader.this.currentTaskGroup.insert(GraphReader.this.currentTask, GraphReader.this.currentTaskGroup.getChildCount());
            }
            GraphReader.this.currentTaskGroup = GraphReader.this.currentTask;
        }

        @Override
        public void endElement(String string, Element element) throws SAXException {
            GraphReader.this.currentTask = GraphReader.this.currentTaskGroup;
            GraphReader.this.currentTaskGroup = (NodeTask)GraphReader.this.currentTaskGroup.getParent();
        }
    }

    private final class TaskEntryReader
    extends SingleElementReader {
        private TaskEntryReader() {
        }

        @Override
        public void startElement(Attributes attributes) {
            GraphReader.this.currentTask = new NodeTaskEntry((FlowNode)GraphReader.this.idToNodeMap.get(Integer.valueOf(attributes.getValue("node"))));
            GraphReader.this.currentTaskGroup.insert(GraphReader.this.currentTask, GraphReader.this.currentTaskGroup.getChildCount());
        }
    }

    private final class TaskPropertyReader
    extends SingleElementReader {
        private TaskPropertyReader() {
        }

        @Override
        public void startElement(Attributes attributes) {
            GraphReader.this.inTaskProperty = true;
            GraphReader.this.currentTaskProperty = new NodeTaskProperty();
        }

        @Override
        public void endElement(String string, Element element) throws SAXException {
            GraphReader.this.inTaskProperty = false;
            GraphReader.this.currentTask.setProperty(GraphReader.this.currentTaskProperty);
        }
    }

    private class OverlaySingleElementReader
    extends SingleElementReader {
        private String qName;
        private SingleElementReader reader;

        public OverlaySingleElementReader(String string, SingleElementReader singleElementReader) {
            this.qName = string;
            this.reader = singleElementReader;
        }

        @Override
        public void startElement(Attributes attributes) throws SAXException {
            if (!GraphReader.this.isOverlay) {
                this.reader.startElement(attributes);
            } else {
                GraphReader.this.overlayReader.getSingleElementReader(this.qName).startElement(attributes);
            }
        }

        @Override
        public void endElement(String string, Element element) throws SAXException {
            if (!GraphReader.this.isOverlay) {
                this.reader.endElement(string, element);
            } else {
                GraphReader.this.overlayReader.getSingleElementReader(this.qName).endElement(string, element);
            }
        }
    }
}

