/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.flow;

import com.ef_prime.rflow.core.app.r.RAddonOp;
import com.ef_prime.rflow.core.app.r.base.RPackage;
import com.ef_prime.rflow.core.common.xml.XmlContext;
import com.ef_prime.rflow.core.common.xml.XmlUtility;
import com.ef_prime.rflow.core.flow.CacheData;
import com.ef_prime.rflow.core.flow.ElementWriter;
import com.ef_prime.rflow.core.flow.FlowDataWriter;
import com.ef_prime.rflow.core.flow.FlowEdge;
import com.ef_prime.rflow.core.flow.FlowGraph;
import com.ef_prime.rflow.core.flow.FlowNode;
import com.ef_prime.rflow.core.flow.FlowProperties;
import com.ef_prime.rflow.core.flow.FlowSettings;
import com.ef_prime.rflow.core.flow.GraphElements;
import com.ef_prime.rflow.core.flow.ViewLayout;
import com.ef_prime.rflow.core.flow.task.NodeTask;
import com.ef_prime.rflow.core.flow.task.NodeTaskEntry;
import com.ef_prime.rflow.core.flow.task.NodeTaskGroup;
import com.ef_prime.rflow.core.node.UnknownNodeModel;
import com.ef_prime.rflow.core.util.XMLException;
import com.ef_prime.rflow.core.util.XMLWriter;
import com.ef_prime.rflow.core.util.YamlEx;
import com.ef_prime.rflow.node.NodeComment;
import com.ef_prime.rflow.node.NodeModel;
import com.ef_prime.rflow.node.NodeModelController;
import com.ef_prime.rflow.node.NodeModelManager;
import com.ef_prime.rflow.node.NodeProperty;
import com.ef_prime.rflow.node.base.ListNodeModel;
import com.ef_prime.rflow.node.base.SubflowNodeModel;
import com.ef_prime.rflow.node.group.DefaultAppearanceGroup;
import com.ef_prime.rflow.node.ui.Operation;
import com.ef_prime.rflow.node.ui.RAddonOpData;
import com.ef_prime.rflow.node.ui.UINodeModel;
import com.ef_prime.rflow.ui.util.StringUtility;
import edu.uci.ics.jung.graph.Vertex;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.FilenameUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class GraphWriter
implements ElementWriter,
GraphElements {
    private ViewLayout layout;
    private FlowGraph graph;
    private FlowSettings flowSettings;
    private NodeTask rootTask;
    private FlowProperties flowProperties;
    private Map<Vertex, Integer> nodeToIdMap;
    private XmlContext xmlContext;
    private Document document;

    public GraphWriter(ViewLayout viewLayout, FlowSettings flowSettings, NodeTask nodeTask, FlowProperties flowProperties) {
        this.layout = viewLayout;
        this.graph = this.layout.getGraph();
        this.flowSettings = flowSettings;
        this.rootTask = nodeTask;
        this.flowProperties = flowProperties;
        this.nodeToIdMap = new HashMap<Vertex, Integer>();
        this.xmlContext = new XmlContext();
        this.document = XmlUtility.createDocument();
    }

    private GraphWriter(ViewLayout viewLayout, Map<Vertex, Integer> map) {
        this(viewLayout, null, null, null);
        this.nodeToIdMap = map;
    }

    @Override
    public void write(XMLWriter xMLWriter) throws XMLException {
        Object object;
        if (this.graph == null) {
            return;
        }
        Dimension dimension = this.getSize();
        xMLWriter.writeStartElement("graph");
        xMLWriter.writeAttribute("version", "0.9");
        if (dimension != null) {
            xMLWriter.writeAttribute("width", String.valueOf(dimension.width));
            xMLWriter.writeAttribute("height", String.valueOf(dimension.height));
        }
        xMLWriter.writeAttribute("locationtype", this.getLocationType());
        Point point = this.getLayoutOffset();
        if (point != null) {
            xMLWriter.writeAttribute("offsetx", String.valueOf(point.x));
            xMLWriter.writeAttribute("offsety", String.valueOf(point.y));
        }
        this.writeFlowSettings(xMLWriter);
        this.writeFlowProperties(xMLWriter);
        for (Object e : this.graph.getVertices()) {
            object = (FlowNode)e;
            NodeModel nodeModel = ((FlowNode)object).getModel();
            int n = this.nodeToIdMap.size();
            this.nodeToIdMap.put((Vertex)object, n);
            String string = String.valueOf(n);
            Point2D point2D = this.getLocation((FlowNode)object);
            String string2 = String.valueOf((int)point2D.getX());
            String string3 = String.valueOf((int)point2D.getY());
            if (nodeModel instanceof UnknownNodeModel || nodeModel.isSavedCommandMode() && nodeModel.getSavedElement() != null) {
                Element element = nodeModel instanceof UnknownNodeModel ? ((UnknownNodeModel)nodeModel).getElement() : nodeModel.getSavedElement();
                element.setAttribute("id", string);
                element.setAttribute("x", string2);
                element.setAttribute("y", string3);
                if (nodeModel.isDisabled()) {
                    element.setAttribute("disabled", "true");
                } else {
                    element.removeAttribute("disabled");
                }
                if (nodeModel.getNodeMode() == NodeModel.NodeMode.PRESERVED) {
                    element.setAttribute("mode", "preserved");
                } else {
                    element.removeAttribute("mode");
                }
                xMLWriter.writeElement(element);
                continue;
            }
            xMLWriter.writeStartElement("node");
            xMLWriter.writeAttribute("id", string);
            xMLWriter.writeAttribute("date", String.valueOf(((FlowNode)object).getDate()));
            xMLWriter.writeAttribute("uid", ((FlowNode)object).getUid());
            xMLWriter.writeAttribute("x", string2);
            xMLWriter.writeAttribute("y", string3);
            if (nodeModel.isDisabled()) {
                xMLWriter.writeAttribute("disabled", "true");
            }
            xMLWriter.writeStartElement("command");
            xMLWriter.writeCharacters(nodeModel.isSavedCommandMode() ? nodeModel.getSavedCommand() : nodeModel.getCommand());
            xMLWriter.writeEndElement();
            xMLWriter.writeStartElement("packages");
            boolean bl = nodeModel instanceof SubflowNodeModel;
            for (RPackage rPackage : bl ? nodeModel.getRequiredPackageList() : nodeModel.getAutoPackageList()) {
                xMLWriter.writeStartElement("package");
                xMLWriter.writeAttribute("name", rPackage.getName());
                xMLWriter.writeAttribute("attach", Boolean.toString(rPackage.isAttach()));
                xMLWriter.writeEndElement();
            }
            xMLWriter.writeEndElement();
            this.writeProperty(xMLWriter, (FlowNode)object);
            if (!nodeModel.getBreakpoints().isEmpty()) {
                xMLWriter.writeStartElement("break");
                xMLWriter.writeCharacters(StringUtility.join(nodeModel.getBreakpoints(), ","));
                xMLWriter.writeEndElement();
            }
            this.writeOption(xMLWriter, nodeModel);
            xMLWriter.writeEndElement();
        }
        for (Object e : this.graph.getEdges()) {
            object = (FlowEdge)((Object)e);
            xMLWriter.writeEmptyElement("edge");
            xMLWriter.writeAttribute("from", this.nodeToIdMap.get(((FlowEdge)((Object)object)).getSource()).toString());
            xMLWriter.writeAttribute("to", this.nodeToIdMap.get(((FlowEdge)((Object)object)).getDest()).toString());
        }
        xMLWriter.writeEndElement();
        if (this.rootTask != null) {
            xMLWriter.writeStartElement("task");
            this.writeTask(xMLWriter, this.rootTask, this.nodeToIdMap);
            xMLWriter.writeEndElement();
        }
    }

    private void writeFlowProperties(XMLWriter xMLWriter) throws XMLException {
        if (this.flowProperties == null) {
            return;
        }
        Element element = this.document.createElement("properties");
        this.flowProperties.storeToElement(this.xmlContext, this.document, element);
        xMLWriter.writeElement(element);
    }

    private void writeProperty(XMLWriter xMLWriter, FlowNode flowNode) throws XMLException {
        NodeComment nodeComment;
        NodeProperty nodeProperty = flowNode.getProperty();
        xMLWriter.writeStartElement("property");
        if (nodeProperty.getTitle() != null) {
            xMLWriter.writeAttribute("title", nodeProperty.getTitle());
        }
        if (nodeProperty.getAppearanceGroup() != null) {
            xMLWriter.writeAttribute("shape", DefaultAppearanceGroup.valueOf(nodeProperty.getAppearanceGroup()).toString());
        }
        if ((nodeComment = flowNode.getComment()).exists()) {
            xMLWriter.writeStartElement("comment");
            xMLWriter.writeAttribute("state", nodeComment.getState());
            xMLWriter.writeAttribute("x", Integer.toString(nodeComment.getOffset().x));
            xMLWriter.writeAttribute("y", Integer.toString(nodeComment.getOffset().y));
            xMLWriter.writeCharacters(nodeComment.getText());
            xMLWriter.writeEndElement();
        }
        if (flowNode.isCacheData()) {
            CacheData cacheData = flowNode.getCacheData();
            xMLWriter.writeStartElement("cache");
            xMLWriter.writeAttribute("file", FilenameUtils.removeExtension((String)cacheData.getFile().getName()));
            if (cacheData.isDate()) {
                xMLWriter.writeAttribute("date", CacheData.toString(cacheData.getDate()));
            }
            if (cacheData.isSize()) {
                xMLWriter.writeAttribute("size", Long.toString(cacheData.getSize()));
            }
            if (!cacheData.isValid()) {
                xMLWriter.writeAttribute("gray", Boolean.toString(true));
            }
            xMLWriter.writeEndElement();
        }
        xMLWriter.writeEndElement();
    }

    private void writeOption(XMLWriter xMLWriter, NodeModel nodeModel) throws XMLException {
        xMLWriter.writeStartElement("option");
        xMLWriter.writeAttribute("type", nodeModel.getTypeID());
        if (nodeModel instanceof UINodeModel) {
            Object object;
            Object object2;
            Operation operation = ((UINodeModel)nodeModel).getModel();
            if (operation instanceof RAddonOp) {
                object2 = ((RAddonOp)operation).getData();
                object = ((RAddonOpData)object2).getBuilderModel();
                StringWriter stringWriter = new StringWriter();
                new YamlEx().dump(YamlEx.yamlValueWithType("r-default", object), stringWriter);
                xMLWriter.writeStartElement("uidef");
                xMLWriter.writeCharacters(stringWriter.toString());
                xMLWriter.writeEndElement();
            }
            object2 = this.document.createElement("ui");
            object = operation.getId();
            object2.setAttribute("cls", (String)object);
            if (operation.getVersion() != null) {
                object2.setAttribute("version", operation.getVersion().toString());
            }
            operation.storeToElement(this.xmlContext, this.document, (Element)object2);
            xMLWriter.writeElement((Element)object2);
        } else {
            Object object;
            Object object3;
            NodeModelController nodeModelController = NodeModelManager.getModelController(nodeModel.getClass());
            if (nodeModelController != null) {
                object3 = nodeModelController.getOptionProperties(nodeModel);
                if (object3 != null) {
                    for (Map.Entry object4 : ((Properties)object3).entrySet()) {
                        xMLWriter.writeStartElement("entry");
                        xMLWriter.writeAttribute("key", (String)object4.getKey());
                        xMLWriter.writeCharacters((String)object4.getValue());
                        xMLWriter.writeEndElement();
                    }
                }
                if (nodeModelController.saveAsXMLElement()) {
                    object = this.document.createElement("entryset");
                    nodeModelController.storeToXMLElement(nodeModel, this.document, (Element)object);
                    xMLWriter.writeElement((Element)object);
                }
            }
            if (nodeModel.isSubflow()) {
                object3 = (SubflowNodeModel)nodeModel;
                object = new FlowDataWriter();
                ViewLayout[] viewLayoutArray = ((SubflowNodeModel)object3).getLayouts();
                String string = null;
                if (object3 instanceof ListNodeModel) {
                    string = "list";
                }
                for (ViewLayout viewLayout : viewLayoutArray) {
                    xMLWriter.writeStartElement("subflow");
                    if (string != null) {
                        xMLWriter.writeAttribute("type", string);
                    }
                    ((FlowDataWriter)object).write(xMLWriter, new ElementWriter[]{new GraphWriter(viewLayout, this.nodeToIdMap)}, false, false);
                    xMLWriter.writeEndElement();
                }
            }
        }
        xMLWriter.writeEndElement();
    }

    Point getLayoutOffset() {
        return this.layout.getOffset();
    }

    Point2D getLocation(FlowNode flowNode) {
        return this.layout.getLocation((Vertex)flowNode);
    }

    Dimension getSize() {
        return this.layout.getSize();
    }

    String getLocationType() {
        return "a";
    }

    FlowProperties getFlowProperties() {
        return this.flowProperties;
    }

    private void writeFlowSettings(XMLWriter xMLWriter) throws XMLException {
        if (this.flowSettings == null) {
            return;
        }
        xMLWriter.writeStartElement("setting");
        for (Map.Entry<String, String> entry : this.flowSettings.stringEntryMap().entrySet()) {
            xMLWriter.writeStartElement("entry");
            xMLWriter.writeAttribute("key", entry.getKey());
            xMLWriter.writeCharacters(entry.getValue());
            xMLWriter.writeEndElement();
        }
        xMLWriter.writeEndElement();
    }

    private void writeTask(XMLWriter xMLWriter, NodeTask nodeTask, Map<Vertex, Integer> map) throws XMLException {
        if (nodeTask instanceof NodeTaskEntry) {
            NodeTaskEntry nodeTaskEntry = (NodeTaskEntry)nodeTask;
            Integer n = map.get(nodeTaskEntry.getNode());
            if (n != null) {
                xMLWriter.writeStartElement("taskentry");
                xMLWriter.writeAttribute("node", n.toString());
                this.writeTaskProperty(xMLWriter, nodeTask);
                xMLWriter.writeEndElement();
            }
        } else if (nodeTask instanceof NodeTaskGroup) {
            NodeTaskGroup nodeTaskGroup = (NodeTaskGroup)nodeTask;
            xMLWriter.writeStartElement("taskgroup");
            this.writeTaskProperty(xMLWriter, nodeTask);
            for (NodeTask nodeTask2 : nodeTaskGroup.getTaskEntrys()) {
                this.writeTask(xMLWriter, nodeTask2, map);
            }
            xMLWriter.writeEndElement();
        }
    }

    private void writeTaskProperty(XMLWriter xMLWriter, NodeTask nodeTask) throws XMLException {
        xMLWriter.writeStartElement("taskproperty");
        for (Map.Entry entry : nodeTask.getProperty().entrySet()) {
            String string = (String)entry.getKey();
            if (nodeTask == this.rootTask && string.equals("title")) continue;
            xMLWriter.writeStartElement("entry");
            xMLWriter.writeAttribute("key", string);
            xMLWriter.writeCharacters((String)entry.getValue());
            xMLWriter.writeEndElement();
        }
        xMLWriter.writeEndElement();
    }
}

