/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.flow;

import com.ef_prime.rflow.core.flow.FlowEdge;
import com.ef_prime.rflow.core.flow.FlowGraph;
import com.ef_prime.rflow.core.flow.FlowLayout;
import com.ef_prime.rflow.core.flow.FlowNode;
import com.ef_prime.rflow.core.flow.ViewLayout;
import edu.uci.ics.jung.graph.Edge;
import edu.uci.ics.jung.graph.Vertex;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.util.HashSet;

public class ListViewLayout
extends ViewLayout {
    public ListViewLayout(FlowLayout flowLayout, Dimension dimension, Point point) {
        super(flowLayout, dimension, point);
    }

    public ListViewLayout(ViewLayout viewLayout) {
        Object object;
        FlowGraph flowGraph = this.createGraph();
        this.layout = new FlowLayout(flowGraph);
        this.size = (Dimension)viewLayout.getSize().clone();
        this.offset = (Point)viewLayout.getOffset().clone();
        HashSet hashSet = new HashSet(viewLayout.getGraph().getVertices());
        HashSet hashSet2 = new HashSet(viewLayout.getGraph().getEdges());
        viewLayout.getGraph().removeAllVertices();
        for (Object e : hashSet) {
            object = (FlowNode)e;
            flowGraph.addVertex((Vertex)object);
            Point2D point2D = viewLayout.getLocation((Vertex)object);
            this.layout.addVertex((Vertex)object, point2D.getX(), point2D.getY());
        }
        for (Object e : hashSet2) {
            object = (FlowEdge)((Object)e);
            flowGraph.addEdge((Edge)new FlowEdge((Vertex)((FlowEdge)((Object)object)).getSource(), (Vertex)((FlowEdge)((Object)object)).getDest()));
        }
    }

    public ListViewLayout(ViewLayout viewLayout, boolean bl) {
        super(viewLayout, bl);
    }

    @Override
    public Point2D getLocation(Vertex vertex) {
        int n = 0;
        FlowNode flowNode = (FlowNode)vertex;
        while (flowNode != null) {
            flowNode = flowNode.getPreviousNode();
            ++n;
        }
        Point point = this.getOffset();
        return new Point2D.Float(point.x + n * 80, point.y + 80);
    }

    @Override
    public ViewLayout copy() {
        return new ListViewLayout(this, false);
    }

    @Override
    public ViewLayout fullCopy() {
        return new ListViewLayout(this, true);
    }
}

