/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.flow;

import com.ef_prime.rflow.core.app.r.base.RPackage;
import com.ef_prime.rflow.core.app.r.base.RUtility;
import com.ef_prime.rflow.core.app.r.console.Executor;
import com.ef_prime.rflow.core.flow.FlowRunOption;
import com.ef_prime.rflow.core.flow.task.NodeTask;
import com.ef_prime.rflow.core.flow.task.NodeTaskEntry;
import com.ef_prime.rflow.core.flow.task.NodeTaskGroup;
import com.ef_prime.rflow.core.util.ScriptBuilder;
import com.ef_prime.rflow.ui.util.UIUtility;

public class RScriptExporter {
    public static String script(Executor executor, NodeTask nodeTask, String string, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        FlowRunOption flowRunOption = FlowRunOption.createScriptOption().setIncludeTitle(bl2).setIncludeComment(bl3);
        String string2 = nodeTask.getChildCount() == 0 ? null : "###";
        Object object = RScriptExporter.buildScript(executor, flowRunOption, nodeTask, string, string2);
        RPackage[] rPackageArray = RPackage.getRPackages(nodeTask, false);
        if (rPackageArray.length > 0) {
            if (bl) {
                object = RScriptExporter.getLibraryCommand(rPackageArray) + (String)object;
            }
            if (bl4) {
                object = RScriptExporter.getCheckRequiredPackages(rPackageArray) + (String)object;
            }
        }
        return object;
    }

    private static String getCheckRequiredPackages(RPackage[] rPackageArray) {
        Object object = "package <- ";
        if (rPackageArray.length == 1) {
            object = (String)object + RUtility.quote(rPackageArray[0].getName());
        } else {
            object = (String)object + "c(";
            boolean bl = true;
            for (RPackage rPackage : rPackageArray) {
                if (bl) {
                    bl = false;
                } else {
                    object = (String)object + ", ";
                }
                object = (String)object + RUtility.quote(rPackage.getName());
            }
            object = (String)object + ")";
        }
        ScriptBuilder scriptBuilder = new ScriptBuilder();
        scriptBuilder.appendLn("## Check required packages");
        scriptBuilder.appendLn("local({");
        scriptBuilder.indent();
        scriptBuilder.appendLn((CharSequence)object);
        scriptBuilder.appendLn("missing <- package[!sapply(package, requireNamespace, quietly = TRUE)]");
        scriptBuilder.appendLn();
        scriptBuilder.appendLn("# Stop if any package is missing");
        scriptBuilder.appendLn("if(length(missing) > 0) {");
        scriptBuilder.indent();
        scriptBuilder.appendLn("error <- if(length(missing) == 1) {");
        scriptBuilder.indent();
        scriptBuilder.appendLn("paste0(\"Missing required package: \", missing, \". Try:\\n   install.packages(\\\"\", missing, \"\\\")\")");
        scriptBuilder.unindent();
        scriptBuilder.appendLn("} else {");
        scriptBuilder.indent();
        scriptBuilder.appendLn("paste0(\"Missing required packages: \", paste(missing, collapse = \", \"),");
        scriptBuilder.indent();
        scriptBuilder.appendLn("\". Try:\\n    install.packages(c(\\\"\", paste0(missing, collapse = \"\\\", \\\"\"), \"\\\"))\")");
        scriptBuilder.unindent();
        scriptBuilder.unindent();
        scriptBuilder.appendLn("}");
        scriptBuilder.appendLn("stop(error, call. = FALSE)");
        scriptBuilder.unindent();
        scriptBuilder.appendLn("}");
        scriptBuilder.unindent();
        scriptBuilder.appendLn("})");
        scriptBuilder.appendLn();
        return scriptBuilder.toString();
    }

    private static String getLibraryCommand(RPackage[] rPackageArray) {
        ScriptBuilder scriptBuilder = new ScriptBuilder();
        for (RPackage rPackage : rPackageArray) {
            if (!rPackage.isAttach()) continue;
            scriptBuilder.appendLn(String.format("library(%s)", rPackage.getName()));
        }
        if (scriptBuilder.toString().isEmpty()) {
            return "";
        }
        scriptBuilder.appendLn();
        return scriptBuilder.toString();
    }

    public static void copyToClipboard(Executor executor, NodeTask nodeTask) {
        String string = RScriptExporter.buildScript(executor, nodeTask);
        UIUtility.copyToClipboard(string);
    }

    public static String buildScript(Executor executor, NodeTask nodeTask) {
        FlowRunOption flowRunOption = FlowRunOption.createScriptOption();
        String string = nodeTask.getChildCount() == 0 ? null : "###";
        return RScriptExporter.buildScript(executor, flowRunOption, nodeTask, "\n", string);
    }

    private static String buildScript(Executor executor, FlowRunOption flowRunOption, NodeTask nodeTask, String string, String string2) {
        String string3;
        StringBuilder stringBuilder = new StringBuilder();
        RScriptExporter.buildScript(stringBuilder, executor, flowRunOption, nodeTask, 0, string2, "");
        String string4 = string3 = stringBuilder.length() > 1 ? stringBuilder.substring(0, stringBuilder.length() - 1) : "";
        if (string.equals("\r\n")) {
            string3 = string3.replace("\n", "\r\n");
        } else if (string.equals("\r")) {
            string3 = string3.replace('\n', '\r');
        }
        return string3;
    }

    private static void buildScript(StringBuilder stringBuilder, Executor executor, FlowRunOption flowRunOption, NodeTask nodeTask, int n, String string, String object) {
        int n2;
        boolean bl;
        boolean bl2 = bl = string != null;
        if (bl) {
            for (n2 = 0; n2 < n; ++n2) {
                stringBuilder.append(string);
            }
            if (n == 0) {
                stringBuilder.append(string);
            }
            stringBuilder.append(" ");
        }
        if (nodeTask instanceof NodeTaskGroup) {
            if (bl && n > 0 && nodeTask.getParent() != null) {
                object = (String)object + (nodeTask.getParent().getIndex(nodeTask) + 1) + ".";
                stringBuilder.append((String)object);
            }
            stringBuilder.append(nodeTask.getProperty().getTitle());
            if (bl) {
                stringBuilder.append("\n");
            }
            stringBuilder.append("\n");
            for (n2 = 0; n2 < nodeTask.getChildCount(); ++n2) {
                RScriptExporter.buildScript(stringBuilder, executor, flowRunOption, (NodeTask)nodeTask.getChildAt(n2), n + 1, string, (String)object);
            }
        } else if (nodeTask instanceof NodeTaskEntry) {
            if (bl) {
                if (nodeTask.getParent() != null) {
                    stringBuilder.append((String)object + (nodeTask.getParent().getIndex(nodeTask) + 1) + ".");
                }
                stringBuilder.append(nodeTask.getProperty().getTitle());
                stringBuilder.append("\n");
                stringBuilder.append("\n");
            }
            stringBuilder.append(executor.getScript(nodeTask, null, flowRunOption));
            stringBuilder.append("\n");
        }
    }
}

