/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.flow;

import com.ef_prime.rflow.core.flow.FlowEdge;
import com.ef_prime.rflow.core.flow.FlowGraph;
import com.ef_prime.rflow.core.flow.FlowNode;
import com.ef_prime.rflow.core.flow.FlowNodeSelectionEvent;
import com.ef_prime.rflow.core.flow.FlowNodeSelectionEventHandler;
import com.ef_prime.rflow.core.flow.FlowUtil;
import com.ef_prime.rflow.ui.common.event.ChangeEvent;
import com.ef_prime.rflow.ui.common.event.ChangeEventHandler;
import com.ef_prime.rflow.ui.common.event.Event;
import com.ef_prime.rflow.ui.common.event.EventManager;
import com.ef_prime.rflow.ui.common.event.EventSupport;
import edu.uci.ics.jung.graph.ArchetypeEdge;
import edu.uci.ics.jung.graph.ArchetypeGraph;
import edu.uci.ics.jung.graph.ArchetypeVertex;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.graph.event.GraphEvent;
import edu.uci.ics.jung.graph.event.GraphEventListener;
import edu.uci.ics.jung.visualization.MultiPickedState;
import java.awt.ItemSelectable;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class SubflowState
extends MultiPickedState
implements ItemListener,
GraphEventListener {
    private Set<FlowNode> activeNodes;
    private List<FlowNode> selectionFlow = new ArrayList<FlowNode>();
    private List<FlowEdge> selectionEdgeFlow = new ArrayList<FlowEdge>();
    private Set<FlowNode> rectangleSelection = new HashSet<FlowNode>();
    private FlowNode connectTargetNode;
    private FlowEdge insertTargetEdge;
    private EventSupport<ChangeEvent, ChangeEventHandler> eventSupport = new EventSupport();
    private EventSupport<FlowNodeSelectionEvent, FlowNodeSelectionEventHandler> selectionEventSupport = new EventSupport();
    private int adjusting;
    private boolean adjustingDirty;

    public SubflowState() {
        this.addItemListener(this);
    }

    public void startAdjusting() {
        if (this.adjusting == 0) {
            this.adjustingDirty = false;
        }
        ++this.adjusting;
    }

    public void endAdjusting() {
        --this.adjusting;
        if (this.adjustingDirty) {
            this.dispatchFlowNodeSelectionEvent();
        }
    }

    private void start() {
        ++this.adjusting;
        this.adjustingDirty = true;
    }

    private void end() {
        --this.adjusting;
        this.dispatchFlowNodeSelectionEvent();
    }

    public void clearPickedVertices() {
        this.start();
        try {
            if (this.getPickedVertices().isEmpty()) {
                this.fireItemStateChanged(new ItemEvent((ItemSelectable)((Object)this), 701, null, 2));
            } else {
                super.clearPickedVertices();
            }
        }
        finally {
            this.end();
        }
    }

    public void clearPickedEdges() {
        this.start();
        try {
            super.clearPickedEdges();
        }
        finally {
            this.end();
        }
    }

    public void clear() {
        this.start();
        try {
            this.clearPickedEdges();
            this.clearPickedVertices();
        }
        finally {
            this.end();
        }
    }

    public void setPicked(ArchetypeVertex archetypeVertex) {
        this.start();
        try {
            this.clearPickedVertices();
            this.pick(archetypeVertex, true);
        }
        finally {
            this.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean pick(ArchetypeVertex archetypeVertex, boolean bl) {
        this.start();
        try {
            this.clearPickedEdges();
            boolean bl2 = super.pick(archetypeVertex, bl);
            return bl2;
        }
        finally {
            this.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pick(Collection<FlowNode> collection, boolean bl) {
        this.start();
        try {
            for (FlowNode flowNode : collection) {
                this.pick((ArchetypeVertex)flowNode, bl);
            }
        }
        finally {
            this.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pick(FlowNode[] flowNodeArray, boolean bl) {
        this.start();
        try {
            for (FlowNode flowNode : flowNodeArray) {
                this.pick((ArchetypeVertex)flowNode, bl);
            }
        }
        finally {
            this.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean pick(ArchetypeEdge archetypeEdge, boolean bl) {
        this.start();
        try {
            this.clearPickedVertices();
            boolean bl2 = super.pick(archetypeEdge, bl);
            return bl2;
        }
        finally {
            this.end();
        }
    }

    public void setPicked(ArchetypeEdge archetypeEdge) {
        this.start();
        try {
            this.clearPickedEdges();
            this.pick(archetypeEdge, true);
        }
        finally {
            this.end();
        }
    }

    public FlowNode getSelectedNode() {
        if (this.getPickedVertices().size() != 1) {
            return null;
        }
        return this.getPickedVertices().iterator().next();
    }

    public Set<FlowNode> getPickedVertices() {
        return super.getPickedVertices();
    }

    public Set<FlowEdge> getPickedEdges() {
        return super.getPickedEdges();
    }

    protected void fireItemStateChanged(ItemEvent itemEvent) {
        EventListener[] eventListenerArray = this.listenerList.getListeners(ItemListener.class);
        for (int i = eventListenerArray.length - 1; i >= 0; --i) {
            ((ItemListener)eventListenerArray[i]).itemStateChanged(itemEvent);
        }
    }

    public boolean isFlowSelected() {
        return this.selectionFlow.size() > 0;
    }

    public List<FlowNode> getSelectionNodeFlow() {
        return this.selectionFlow;
    }

    public List<FlowEdge> getSelectionEdgeFlow() {
        return this.selectionEdgeFlow;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectInterval(FlowNode flowNode) {
        this.start();
        try {
            Set<FlowNode> set = this.getPickedVertices();
            if (set.size() == 1) {
                FlowNode flowNode2 = set.iterator().next();
                List<FlowNode> list = FlowUtil.getStreamSimple(flowNode2);
                List<FlowNode> list2 = FlowUtil.getStreamSimple(flowNode);
                boolean bl = list.contains(flowNode);
                if (!bl && !list2.contains(flowNode2)) {
                    this.clearPickedVertices();
                    this.pick((ArchetypeVertex)flowNode, true);
                    return;
                }
                FlowNode flowNode3 = !bl ? flowNode2 : flowNode;
                List<FlowNode> list3 = !bl ? list2 : list;
                list3 = list3.subList(list3.indexOf(flowNode3), list3.size());
                this.clearPickedVertices();
                for (FlowNode flowNode4 : list3) {
                    this.pick((ArchetypeVertex)flowNode4, true);
                }
            } else {
                this.clearPickedVertices();
                this.pick((ArchetypeVertex)flowNode, true);
            }
        }
        finally {
            this.end();
        }
    }

    private void addFlowSelection(FlowNode flowNode, List<FlowNode> list, List<FlowEdge> list2) {
        List<FlowNode> list3 = FlowUtil.getStream(flowNode, true, true, false);
        FlowNode flowNode2 = null;
        HashSet<FlowNode> hashSet = new HashSet<FlowNode>();
        for (int i = list3.size() - 1; i >= 0; --i) {
            FlowNode flowNode3 = list3.get(i);
            list.add(flowNode3);
            if (flowNode3.getModel().isSubflow()) {
                hashSet.add(flowNode3);
            }
            if (flowNode2 != null) {
                FlowEdge flowEdge = (FlowEdge)flowNode3.findEdge((Vertex)flowNode2);
                if (flowEdge == null) {
                    FlowNode flowNode4;
                    Iterator iterator = hashSet.iterator();
                    while (iterator.hasNext() && (flowEdge = (FlowEdge)flowNode3.findEdge((Vertex)(flowNode4 = (FlowNode)iterator.next()))) == null) {
                    }
                }
                if (flowEdge != null) {
                    list2.add(flowEdge);
                }
            }
            flowNode2 = flowNode3;
        }
    }

    public void addRectangleSelectionNode(FlowNode flowNode) {
        this.rectangleSelection.add(flowNode);
    }

    public void clearRectangleSelectionNodes() {
        this.rectangleSelection.clear();
    }

    public boolean isRectangleSelectionNode(FlowNode flowNode) {
        return this.rectangleSelection.contains(flowNode);
    }

    public void setActiveNodes(Set<FlowNode> set) {
        if (this.activeNodes != set) {
            this.activeNodes = set;
            this.eventSupport.dispatchEvent(new ChangeEvent(this));
        }
    }

    public boolean isActiveNode(FlowNode flowNode) {
        return this.activeNodes != null && this.activeNodes.contains(flowNode);
    }

    public FlowNode getConnectTargetNode() {
        return this.connectTargetNode;
    }

    public void setConnectTargetNode(FlowNode flowNode) {
        if (Objects.equals(this.connectTargetNode, flowNode)) {
            return;
        }
        this.connectTargetNode = flowNode;
        this.eventSupport.dispatchEvent(new ChangeEvent(this));
    }

    public void clearConnectTargetNode() {
        this.setConnectTargetNode(null);
    }

    public void clearInsertTargetEdge() {
        this.setInsertTargetEdge(null);
    }

    public void setInsertTargetEdge(FlowEdge flowEdge) {
        if (Objects.equals((Object)this.insertTargetEdge, (Object)flowEdge)) {
            return;
        }
        this.insertTargetEdge = flowEdge;
        this.eventSupport.dispatchEvent(new ChangeEvent(this));
    }

    public FlowEdge getInsertTargetEdge() {
        return this.insertTargetEdge;
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        Vertex vertex;
        ArchetypeGraph archetypeGraph;
        if (itemEvent.getStateChange() == 1 && itemEvent.getItem() instanceof Vertex && (archetypeGraph = (vertex = (Vertex)itemEvent.getItem()).getGraph()) != null && archetypeGraph instanceof FlowGraph) {
            ((FlowGraph)archetypeGraph).toTop(vertex);
        }
        this.dispatchFlowNodeSelectionEvent();
    }

    public void vertexAdded(GraphEvent graphEvent) {
    }

    public void vertexRemoved(GraphEvent graphEvent) {
        FlowNode flowNode = (FlowNode)graphEvent.getGraphElement();
        this.pick((ArchetypeVertex)flowNode, false);
    }

    public void edgeAdded(GraphEvent graphEvent) {
    }

    public void edgeRemoved(GraphEvent graphEvent) {
    }

    public void addChangeEventHandler(ChangeEventHandler changeEventHandler) {
        this.eventSupport.addEventHandler(changeEventHandler);
    }

    public void removeChangeEventHandler(ChangeEventHandler changeEventHandler) {
        this.eventSupport.removeEventHandler(changeEventHandler);
    }

    public void addSelectionEventHandler(FlowNodeSelectionEventHandler flowNodeSelectionEventHandler) {
        this.selectionEventSupport.addEventHandler(flowNodeSelectionEventHandler);
    }

    public void removeSelectionEventHandler(FlowNodeSelectionEventHandler flowNodeSelectionEventHandler) {
        this.selectionEventSupport.removeEventHandler(flowNodeSelectionEventHandler);
    }

    private void dispatchFlowNodeSelectionEvent() {
        Object object;
        if (this.adjusting > 0) {
            return;
        }
        this.clearRectangleSelectionNodes();
        this.selectionFlow.clear();
        this.selectionEdgeFlow.clear();
        if (this.getPickedVertices().size() == 1) {
            object = this.getPickedVertices().iterator().next();
            this.addFlowSelection((FlowNode)object, this.selectionFlow, this.selectionEdgeFlow);
        }
        object = new FlowNodeSelectionEvent(this);
        EventManager.getInstance().dispatchEvent((Event)object);
        this.selectionEventSupport.dispatchEvent((FlowNodeSelectionEvent)object);
    }
}

