/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.flow;

import com.ef_prime.rflow.core.flow.FlowEdge;
import com.ef_prime.rflow.core.flow.FlowGraph;
import com.ef_prime.rflow.core.flow.FlowLayout;
import com.ef_prime.rflow.core.flow.FlowNode;
import com.ef_prime.rflow.node.NodeModel;
import com.ef_prime.rflow.ui.flow.FlowUndoManager;
import edu.uci.ics.jung.graph.ArchetypeVertex;
import edu.uci.ics.jung.graph.Edge;
import edu.uci.ics.jung.graph.Vertex;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;

public class ViewLayout {
    private static final Point DEFAULT_FIRSTNODE_POINT = new Point(80, 80);
    protected FlowLayout layout;
    protected Dimension size;
    protected Point offset;
    private FlowUndoManager undoManager;

    public ViewLayout() {
        this.layout = new FlowLayout(this.createGraph());
        this.size = new Dimension();
        this.offset = new Point();
    }

    public ViewLayout(FlowLayout flowLayout, Dimension dimension, Point point) {
        if (flowLayout == null || dimension == null || point == null) {
            throw new IllegalArgumentException();
        }
        this.layout = flowLayout;
        this.size = dimension;
        this.offset = point;
    }

    public ViewLayout(NodeModel[] nodeModelArray) {
        ArrayList<FlowNode> arrayList = new ArrayList<FlowNode>(nodeModelArray.length);
        for (int i = 0; i < nodeModelArray.length; ++i) {
            arrayList.add(new FlowNode(nodeModelArray[i]));
        }
        this.init(arrayList, DEFAULT_FIRSTNODE_POINT);
    }

    public ViewLayout(Collection<FlowNode> collection) {
        this.init(collection, new Point());
    }

    public ViewLayout(FlowNode flowNode, Point point) {
        FlowGraph flowGraph = this.createGraph();
        flowGraph.addVertex((Vertex)flowNode);
        this.layout = new FlowLayout(flowGraph);
        this.layout.addVertex((Vertex)flowNode, 0.0, 0.0);
        this.size = new Dimension(point.x * 2, point.y * 2);
        this.offset = new Point(point.x, point.y);
    }

    protected ViewLayout(ViewLayout viewLayout, boolean bl) {
        Object object;
        FlowGraph flowGraph = this.createGraph();
        this.layout = new FlowLayout(flowGraph);
        this.size = (Dimension)viewLayout.getSize().clone();
        this.offset = (Point)viewLayout.getOffset().clone();
        HashMap<Object, FlowNode> hashMap = new HashMap<Object, FlowNode>();
        for (Object e : viewLayout.getGraph().getVertices()) {
            object = (FlowNode)e;
            FlowNode flowNode = bl ? ((FlowNode)object).fullCopy() : ((FlowNode)object).copy();
            flowGraph.addVertex((Vertex)flowNode);
            Point2D point2D = viewLayout.getLocation((Vertex)object);
            this.layout.addVertex((Vertex)flowNode, point2D.getX(), point2D.getY());
            hashMap.put(object, flowNode);
        }
        for (Object e : viewLayout.getGraph().getEdges()) {
            object = (FlowEdge)((Object)e);
            flowGraph.addEdge((Edge)new FlowEdge((Vertex)hashMap.get(((FlowEdge)((Object)object)).getSource()), (Vertex)hashMap.get(((FlowEdge)((Object)object)).getDest())));
        }
    }

    private void init(Collection<FlowNode> collection, Point point) {
        FlowGraph flowGraph = this.createGraph();
        this.layout = new FlowLayout(flowGraph);
        FlowNode flowNode = null;
        int n = 80;
        int n2 = 80;
        int n3 = point.x;
        int n4 = point.y;
        for (FlowNode flowNode2 : collection) {
            flowGraph.addVertex((Vertex)flowNode2);
            this.layout.addVertex((Vertex)flowNode2, n3, n4);
            n3 += n;
            if (flowNode != null) {
                flowGraph.addEdge((Edge)new FlowEdge((Vertex)flowNode, (Vertex)flowNode2));
            }
            flowNode = flowNode2;
        }
        this.size = new Dimension((collection.size() + 1) * n, n2 * 2);
        this.offset = new Point();
    }

    protected FlowGraph createGraph() {
        return new FlowGraph();
    }

    public FlowUndoManager getUndoManager() {
        if (this.undoManager == null) {
            this.undoManager = new FlowUndoManager();
        }
        return this.undoManager;
    }

    public FlowLayout getLayout() {
        return this.layout;
    }

    public FlowGraph getGraph() {
        return this.layout.getGraph();
    }

    public Dimension getSize() {
        return this.size;
    }

    public void setSize(Dimension dimension) {
        this.size = dimension;
    }

    public Point getOffset() {
        return this.offset;
    }

    public void setOffset(Point point) {
        this.offset = point;
    }

    public Point2D getLocation(Vertex vertex) {
        return this.layout.getLocation((ArchetypeVertex)vertex);
    }

    public Point2D getOffsetLocation(Vertex vertex) {
        Point2D point2D = this.getLocation(vertex);
        return new Point2D.Double(point2D.getX() + (double)this.offset.x, point2D.getY() + (double)this.offset.y);
    }

    public static Point getDefaultFirstnodePoint() {
        return (Point)DEFAULT_FIRSTNODE_POINT.clone();
    }

    public ViewLayout copy() {
        return new ViewLayout(this, false);
    }

    public ViewLayout fullCopy() {
        return new ViewLayout(this, true);
    }
}

