/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.flow.task;

import com.ef_prime.rflow.core.common.util.Utility;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

public class BatchExporter {
    public static final int BAT = 0;
    public static final int SH = 1;

    public static void exportBatch(File file, File file2, int n) throws IOException {
        switch (n) {
            case 0: {
                BatchExporter.exportBat(file, file2);
                break;
            }
            default: {
                BatchExporter.export(file, file2);
            }
        }
    }

    private static void exportBat(File file, File file2) throws IOException {
        try (BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));){
            bufferedWriter.write("set RFLOW_HOME=\"" + Utility.PROGRAM_DIR + "\"");
            bufferedWriter.newLine();
            bufferedWriter.newLine();
            bufferedWriter.write("set PATH=%RFLOW_HOME%;%PATH%");
            bufferedWriter.newLine();
            bufferedWriter.write("rflow-batch.exe \"%~p0" + file2.getName() + "\"");
            bufferedWriter.newLine();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void export(File file, File file2) throws IOException {
        try (BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));){
            String string = "\n";
            bufferedWriter.write("#!/bin/sh" + string);
            bufferedWriter.write(string);
            bufferedWriter.write("RFLOW_HOME=\"" + Utility.PROGRAM_DIR + "\"");
            bufferedWriter.write(string);
            bufferedWriter.write("BASEDIR=$(cd $(dirname $0) && pwd)" + string);
            bufferedWriter.write("export PATH=$RFLOW_HOME:$BASEDIR:$PATH" + string);
            bufferedWriter.write("rflow BATCH $BASEDIR/" + file2.getName() + string);
        }
        file.setExecutable(true, true);
    }
}

