/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.flow.task;

import com.ef_prime.rflow.core.common.util.Utility;
import com.ef_prime.rflow.core.flow.FlowNode;
import com.ef_prime.rflow.core.flow.task.NodeTaskEntry;
import com.ef_prime.rflow.core.flow.task.NodeTaskGroup;
import com.ef_prime.rflow.core.flow.task.NodeTaskProperty;
import java.beans.PropertyChangeListener;
import java.util.ArrayDeque;
import java.util.Enumeration;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;

public abstract class NodeTask
implements MutableTreeNode {
    private NodeTaskProperty property = new NodeTaskProperty();
    private MutableTreeNode parent = null;

    public NodeTask() {
    }

    protected NodeTask(NodeTask nodeTask) {
        this.property = nodeTask.property.copy();
    }

    public abstract NodeTaskEntry[] getChildEntrys();

    public abstract NodeTask copy();

    public abstract FlowNode getNode();

    public FlowNode getLastNode() {
        NodeTaskEntry[] nodeTaskEntryArray = this.getChildEntrys();
        if (nodeTaskEntryArray.length > 0 && nodeTaskEntryArray[nodeTaskEntryArray.length - 1].getStartNode() == null) {
            return nodeTaskEntryArray[nodeTaskEntryArray.length - 1].getNode();
        }
        return null;
    }

    public NodeTaskProperty getProperty() {
        return this.property;
    }

    public void setProperty(NodeTaskProperty nodeTaskProperty) {
        PropertyChangeListener[] propertyChangeListenerArray = this.property.getPropertyChangeListeners();
        for (int i = 0; i < propertyChangeListenerArray.length; ++i) {
            this.property.removePropertyChangeListener(propertyChangeListenerArray[i]);
            nodeTaskProperty.addPropertyChangeListener(propertyChangeListenerArray[i]);
        }
        this.property = nodeTaskProperty;
    }

    public NodeTask getMainTask() {
        NodeTask nodeTask = null;
        ArrayDeque<NodeTask> arrayDeque = new ArrayDeque<NodeTask>();
        arrayDeque.add(this);
        while (!arrayDeque.isEmpty()) {
            NodeTask nodeTask2 = (NodeTask)arrayDeque.poll();
            if (nodeTask2.getProperty().isMain()) {
                nodeTask = nodeTask2;
                break;
            }
            if (!(nodeTask2 instanceof NodeTaskGroup)) continue;
            Enumeration enumeration = (Enumeration)Utility.cast(nodeTask2.children());
            while (enumeration.hasMoreElements()) {
                arrayDeque.add((NodeTask)enumeration.nextElement());
            }
        }
        return nodeTask;
    }

    public String toString() {
        return this.getProperty().getTitle();
    }

    @Override
    public void removeFromParent() {
        if (this.parent != null) {
            this.parent.remove(this);
        }
    }

    @Override
    public void setParent(MutableTreeNode mutableTreeNode) {
        this.parent = mutableTreeNode;
    }

    @Override
    public TreeNode getParent() {
        return this.parent;
    }

    @Override
    public void setUserObject(Object object) {
        this.getProperty().setTitle(object.toString());
    }
}

