/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.node;

import com.ef_prime.rflow.core.common.keyvalue.ObjectKey;
import com.ef_prime.rflow.core.flow.FlowRunOption;
import com.ef_prime.rflow.core.task.NodeModelTask;
import com.ef_prime.rflow.core.task.Task;
import com.ef_prime.rflow.core.task.TaskEvent;
import com.ef_prime.rflow.core.task.TaskEventHandler;
import com.ef_prime.rflow.core.task.TaskQueue;
import com.ef_prime.rflow.node.PreviewOption;
import com.ef_prime.rflow.node.ui.Operation;
import com.ef_prime.rflow.node.ui.UINodeModel;
import java.util.ArrayList;
import java.util.List;

public class OpExecutor
implements TaskEventHandler {
    public static final ObjectKey PROPERTY_EXECUTOR = new ObjectKey("property.executor", (Object)null);
    private Operation model;
    private List<TaskEventHandler> taskEventHandlers = new ArrayList<TaskEventHandler>();
    private Task lastTask;
    private boolean focusResult;
    private boolean weakFocusResult;

    public OpExecutor(Operation operation) {
        this.model = operation;
    }

    public boolean isFocusResult() {
        return this.focusResult;
    }

    public void setFocusResult(boolean bl) {
        this.focusResult = bl;
    }

    public boolean isWeakFocusResult() {
        return this.weakFocusResult;
    }

    public void setWeakFocusResult(boolean bl) {
        this.weakFocusResult = bl;
    }

    public void run() {
        FlowRunOption flowRunOption = new FlowRunOption().setCheckError(true).setNoRecover(true).setFocusResult(this.focusResult).setWeakFocusResult(this.weakFocusResult).setInteractive(true);
        NodeModelTask nodeModelTask = new NodeModelTask(flowRunOption, new UINodeModel(this.model.copy()));
        this.run(nodeModelTask);
    }

    public void run(Task task) {
        task.setLogError(false);
        task.addTaskEventHandler(this);
        for (TaskEventHandler taskEventHandler : this.taskEventHandlers) {
            task.addTaskEventHandler(taskEventHandler);
        }
        TaskQueue.getInstance().addTask(task);
    }

    public void error(PreviewOption previewOption, final Exception exception) {
        FlowRunOption flowRunOption = new FlowRunOption().setRunImmediately(true);
        NodeModelTask nodeModelTask = new NodeModelTask(flowRunOption, new UINodeModel(this.model.copy())){

            @Override
            protected void runImpl() throws Exception {
                throw exception;
            }
        };
        nodeModelTask.setPreviewOption(previewOption);
        this.run(nodeModelTask);
    }

    public Task getLastTask() {
        return this.lastTask;
    }

    public void addTaskEventHandler(TaskEventHandler taskEventHandler) {
        this.taskEventHandlers.add(taskEventHandler);
    }

    public void removeTaskEventHandler(TaskEventHandler taskEventHandler) {
        this.taskEventHandlers.remove(taskEventHandler);
    }

    @Override
    public void taskStateChanged(TaskEvent taskEvent) {
        if (taskEvent.isDone()) {
            this.lastTask = taskEvent.getTask();
        }
    }
}

