/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.node;

import com.ef_prime.rflow.core.app.r.base.RPackage;
import com.ef_prime.rflow.core.app.r.base.RUtility;
import com.ef_prime.rflow.core.common.xml.XmlUtility;
import com.ef_prime.rflow.core.flow.CompatibilityWarning;
import com.ef_prime.rflow.core.flow.ErrorLevel;
import com.ef_prime.rflow.core.flow.FlowError;
import com.ef_prime.rflow.core.flow.FlowRunOption;
import com.ef_prime.rflow.node.NodeModel;
import com.ef_prime.rflow.node.ui.Operation;
import com.ef_prime.rflow.ui.base.Icons;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import org.w3c.dom.Element;

public class UnknownNodeModel
extends NodeModel {
    private Element element;
    private Operation currentVersionModel;
    private String command;
    private String optionType;
    private String uiType;

    public UnknownNodeModel(Element element) {
        this(element, null);
    }

    public UnknownNodeModel(Element element, Operation operation) {
        Element element2;
        this.element = element;
        this.currentVersionModel = operation;
        this.command = null;
        Element element3 = XmlUtility.getChild("command", element);
        if (element3 != null) {
            this.command = element3.getTextContent();
        }
        if ((element2 = XmlUtility.getChild("option", element)) != null) {
            this.optionType = element2.getAttribute("type");
            Element element4 = XmlUtility.getChild("ui", element2);
            if (element4 != null) {
                this.uiType = element4.getAttribute("cls");
            }
        }
    }

    public Element getElement() {
        return this.element;
    }

    public boolean hasRScript() {
        return this.command != null;
    }

    public boolean isNewerVersionNode() {
        return this.currentVersionModel != null;
    }

    @Override
    public String getDefaultTitle() {
        if (this.currentVersionModel != null) {
            return this.currentVersionModel.getTitle();
        }
        if (this.command != null) {
            return RUtility.titleForScript(this.command);
        }
        if (this.uiType != null) {
            return UnknownNodeModel.getClassName(this.uiType);
        }
        if (this.optionType != null) {
            return UnknownNodeModel.getClassName(this.optionType);
        }
        return null;
    }

    private static String getClassName(String string) {
        int n = string.lastIndexOf(46);
        if (n < 0) {
            return string;
        }
        return string.substring(n, string.length());
    }

    @Override
    public Icon getSmallIcon() {
        if (this.currentVersionModel != null) {
            return this.currentVersionModel.getSmallIcon();
        }
        return Icons.getIcon("16/help.png");
    }

    @Override
    public Icon getIcon() {
        if (this.currentVersionModel != null) {
            return this.currentVersionModel.getIcon();
        }
        return Icons.getIcon("32/help.png");
    }

    @Override
    public String getCommandImpl(boolean bl, FlowRunOption flowRunOption) {
        return this.command == null ? "" : this.command;
    }

    @Override
    public ErrorLevel getErrorLevel() {
        if (this.currentVersionModel != null) {
            return super.getErrorLevel().getMaxLevel(CompatibilityWarning.getInstance().getLevel());
        }
        return super.getErrorLevel();
    }

    @Override
    public List<FlowError> getErrors() {
        List<FlowError> list = super.getErrors();
        if (this.currentVersionModel != null) {
            list.add(CompatibilityWarning.getInstance());
        }
        return list;
    }

    @Override
    public NodeModel copy() {
        UnknownNodeModel unknownNodeModel = new UnknownNodeModel(this.element);
        ArrayList<RPackage> arrayList = new ArrayList<RPackage>();
        arrayList.addAll(this.getSavedPackageList());
        unknownNodeModel.setSavedPackageList(arrayList);
        return unknownNodeModel;
    }

    @Override
    public List<RPackage> getAutoPackageList() {
        return this.getSavedPackageList();
    }
}

