/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.task;

import com.ef_prime.rflow.Rflow;
import com.ef_prime.rflow.core.app.r.ROperation;
import com.ef_prime.rflow.core.app.r.base.R;
import com.ef_prime.rflow.core.app.r.base.RPackage;
import com.ef_prime.rflow.core.app.r.console.Command;
import com.ef_prime.rflow.core.app.r.console.CommandUtility;
import com.ef_prime.rflow.core.app.r.console.ConsoleEntry;
import com.ef_prime.rflow.core.flow.FlowRunOption;
import com.ef_prime.rflow.core.task.NodeModelTask;
import com.ef_prime.rflow.node.base.FreeNodeModel;
import com.ef_prime.rflow.ui.app.r.RActions;
import java.util.List;

public class RCommandTask
extends NodeModelTask {
    private Command command;
    private List<ConsoleEntry> consoleEntries;
    private ROperation model;

    public RCommandTask() {
    }

    public RCommandTask(FlowRunOption flowRunOption, Command command) {
        super(flowRunOption, new FreeNodeModel(CommandUtility.getString(command, false)));
        this.command = command;
    }

    @Override
    protected void runImpl() throws Exception {
        if (this.model != null) {
            RPackage[] rPackageArray = this.model.getRPackages();
            RActions.getInstance().askInstallMissingPackages(rPackageArray);
        }
        if (this.command != null) {
            R.receiver().passCommand(this.command);
            this.waitForCommand(this.command);
            this.consoleEntries = this.command.getConsoleEntries();
            if (this.command.isError()) {
                throw new Exception(ConsoleEntry.getError(this.consoleEntries, "Error occurred while running R."));
            }
        } else {
            super.runImpl();
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.command = null;
    }

    public void setROperation(ROperation rOperation) {
        this.model = rOperation;
    }

    public ROperation getROperation() {
        return this.model;
    }

    public List<ConsoleEntry> getConsoleEntries() {
        return this.consoleEntries;
    }

    protected void waitForCommand(Command command) {
        while (!command.isDone()) {
            try {
                command.waitForCommand(50L);
            }
            catch (InterruptedException interruptedException) {
                if (R.console().isDebugWaitingForInput()) break;
                Rflow.getInstance().getConsole().stopIfBusy();
                break;
            }
        }
    }
}

