/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.task;

import com.ef_prime.rflow.core.common.keyvalue.IntKey;
import com.ef_prime.rflow.core.common.keyvalue.ListKey;
import com.ef_prime.rflow.core.common.keyvalue.LongKey;
import com.ef_prime.rflow.core.common.keyvalue.StrKey;
import com.ef_prime.rflow.core.common.keyvalue.ValueMap;
import com.ef_prime.rflow.core.common.keyvalue.ValueMapKey;
import com.ef_prime.rflow.core.common.util.Utility;
import com.ef_prime.rflow.core.feature.history.TaskTreeTableNode;
import com.ef_prime.rflow.core.flow.FlowNode;
import com.ef_prime.rflow.core.flow.FlowRunOption;
import com.ef_prime.rflow.core.task.TaskError;
import com.ef_prime.rflow.core.task.TaskErrorManager;
import com.ef_prime.rflow.core.task.TaskEvent;
import com.ef_prime.rflow.core.task.TaskEventHandler;
import com.ef_prime.rflow.node.NodeModel;
import com.ef_prime.rflow.node.PreviewOption;
import com.ef_prime.rflow.ui.common.event.EventSupport;
import com.ef_prime.rflow.ui.common.item.ItemName;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.apache.commons.collections.CollectionUtils;
import org.joda.time.Period;
import org.joda.time.ReadablePeriod;
import org.joda.time.format.PeriodFormatter;
import org.joda.time.format.PeriodFormatterBuilder;

public abstract class Task
extends ValueMap
implements RunnableFuture<Void>,
MutableTreeNode {
    private static final Logger LOGGER = Logger.getLogger(Task.class.getName());
    public static final int NONE = 0;
    public static final int QUEUED = 1;
    public static final int RUNNING = 2;
    public static final int DONE = 3;
    private static final StrKey KEY_TITLE = StrKey.builder("title").build();
    private static final IntKey KEY_STATE = new IntKey("state", 0);
    private static final LongKey KEY_ELAPSED_TIME = ((LongKey.Builder)LongKey.builder("elapsed_time", "").setDefaultValue(0L)).build();
    private static final ValueMapKey KEY_ERROR = new ValueMapKey("error", "error", new TaskError());
    private static final ListKey<ValueMap> KEY_WARNINGS = new ListKey<ValueMap>("warnings", "warnings", new ValueMapKey("warning", "warning", new TaskError()));
    private FlowRunOption option;
    private PreviewOption previewOption;
    private FutureTask<Void> futureTask;
    private EventSupport<TaskEvent, TaskEventHandler> taskEventObservable;
    protected Task parent;
    private TaskTreeTableNode treeTableNode;
    private boolean logError;

    public Task() {
        this(FlowRunOption.createRunNodeOption());
    }

    public Task(FlowRunOption flowRunOption) {
        this.option = flowRunOption;
        this.futureTask = new FutureTaskImpl();
        this.taskEventObservable = new EventSupport();
        this.registerKeys(KEY_TITLE, KEY_STATE, KEY_ELAPSED_TIME, KEY_ERROR, KEY_WARNINGS);
        this.treeTableNode = new TaskTreeTableNode(this);
    }

    protected Task(Task task) {
        super(task);
        this.putValueQuietly(KEY_STATE, 0);
        if (task.option != null) {
            this.option = task.option.copy();
        }
        this.previewOption = task.previewOption;
        this.futureTask = new FutureTaskImpl();
        this.taskEventObservable = new EventSupport();
        this.treeTableNode = new TaskTreeTableNode(this);
    }

    protected abstract void runImpl() throws Exception;

    public abstract FlowNode createFlowNode();

    public abstract Task copyTask();

    public NodeModel getModel() {
        return null;
    }

    @Override
    public Task copy() {
        return this.copyTask();
    }

    public String getTitle() {
        return this.getValue(KEY_TITLE);
    }

    public void setTitle(String string) {
        this.putValue(KEY_TITLE, string);
    }

    public PreviewOption getPreviewOption() {
        if (this.previewOption == null) {
            return PreviewOption.OFF;
        }
        return this.previewOption;
    }

    public boolean isPreview() {
        return this.getPreviewOption().isEnabled();
    }

    public void setPreviewOption(PreviewOption previewOption) {
        this.previewOption = previewOption;
    }

    public void setLogError(boolean bl) {
        this.logError = bl;
    }

    public boolean isLogError() {
        return this.logError;
    }

    public abstract Icon getIcon();

    public abstract List<ItemName> getResults();

    public abstract ItemName getPrimaryResult();

    public FlowRunOption getOption() {
        return this.option;
    }

    private void error(TaskError taskError) {
        this.putValue(KEY_ERROR, taskError);
    }

    public void warning(TaskError taskError) {
        ((List)((Object)this.getValue(KEY_WARNINGS))).add(taskError);
    }

    public boolean isError() {
        return !this.getError().isEmpty();
    }

    public boolean isWarning() {
        return !CollectionUtils.isEmpty(this.getWarnings());
    }

    public TaskError getError() {
        return (TaskError)this.getValue(KEY_ERROR);
    }

    public List<TaskError> getWarnings() {
        return (List)Utility.cast(this.getValue(KEY_WARNINGS));
    }

    public long getElapsedTime() {
        return this.getValue(KEY_ELAPSED_TIME);
    }

    public String getElapsedTimeString() {
        PeriodFormatter periodFormatter = new PeriodFormatterBuilder().appendDays().appendSuffix("days").appendHours().appendSuffix("h").appendMinutes().appendSuffix("m").appendSeconds().appendSuffix("s").appendMillis().appendSuffix("ms").printZeroRarelyLast().toFormatter();
        return periodFormatter.print((ReadablePeriod)new Period(this.getElapsedTime()));
    }

    public boolean isGroup() {
        return this.getChildren() != null;
    }

    public boolean isTask() {
        return !this.isGroup();
    }

    public List<Task> getChildren() {
        return null;
    }

    public List<Task> toFlatList() {
        ArrayList<Task> arrayList = new ArrayList<Task>();
        arrayList.add(this);
        return arrayList;
    }

    public int getState() {
        return this.getValue(KEY_STATE);
    }

    protected void setState(int n) {
        if (this.getState() != n) {
            this.putValue(KEY_STATE, n);
            this.fireTaskStateChanged(n);
        }
    }

    public TaskTreeTableNode getTreeTableNode() {
        return this.treeTableNode;
    }

    void queued() {
        this.setState(1);
    }

    public void reset() {
        this.futureTask = new FutureTaskImpl();
        this.putValue(KEY_ERROR, KEY_ERROR.getDefaultValue());
        this.getWarnings().clear();
        this.setState(0);
    }

    public boolean isDoneOrCanceled() {
        return this.isDone() || this.isCancelled();
    }

    public void addTaskEventHandler(TaskEventHandler taskEventHandler) {
        this.taskEventObservable.addEventHandler(taskEventHandler);
    }

    public void removeTaskEventHandler(TaskEventHandler taskEventHandler) {
        this.taskEventObservable.removeEventHandler(taskEventHandler);
    }

    public void fireTaskStateChanged(int n) {
        this.taskEventObservable.dispatchEvent(new TaskEvent(n, this));
    }

    public boolean containsTaskEventHandler(TaskEventHandler taskEventHandler) {
        return this.taskEventObservable.containsEventHandler(taskEventHandler);
    }

    @Override
    public boolean isCancelled() {
        return this.futureTask.isCancelled();
    }

    @Override
    public boolean isDone() {
        return this.getState() == 3;
    }

    @Override
    public boolean cancel(boolean bl) {
        boolean bl2 = this.futureTask.cancel(bl);
        switch (this.getState()) {
            case 1: {
                this.setState(0);
                break;
            }
            case 2: {
                this.setState(3);
            }
        }
        return bl2;
    }

    @Override
    public Void get() throws InterruptedException, ExecutionException {
        return this.futureTask.get();
    }

    @Override
    public Void get(long l, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.futureTask.get(l, timeUnit);
    }

    @Override
    public void run() {
        this.futureTask.run();
    }

    @Override
    public TreeNode getChildAt(int n) {
        return null;
    }

    @Override
    public int getChildCount() {
        return 0;
    }

    @Override
    public TreeNode getParent() {
        return this.parent;
    }

    @Override
    public int getIndex(TreeNode treeNode) {
        return -1;
    }

    @Override
    public boolean getAllowsChildren() {
        return false;
    }

    @Override
    public boolean isLeaf() {
        return this.getChildCount() == 0;
    }

    @Override
    public Enumeration<? extends TreeNode> children() {
        return DefaultMutableTreeNode.EMPTY_ENUMERATION;
    }

    @Override
    public void insert(MutableTreeNode mutableTreeNode, int n) {
    }

    @Override
    public void remove(int n) {
    }

    @Override
    public void remove(MutableTreeNode mutableTreeNode) {
    }

    @Override
    public void setUserObject(Object object) {
    }

    @Override
    public void removeFromParent() {
        if (this.parent == null) {
            return;
        }
        this.parent.remove(this);
    }

    @Override
    public void setParent(MutableTreeNode mutableTreeNode) {
        this.parent = (Task)mutableTreeNode;
    }

    public void add(MutableTreeNode mutableTreeNode) {
        if (mutableTreeNode != null && mutableTreeNode.getParent() == this) {
            this.insert(mutableTreeNode, this.getChildCount() - 1);
        } else {
            this.insert(mutableTreeNode, this.getChildCount());
        }
    }

    public void clear() {
        for (int i = this.getChildCount() - 1; i >= 0; --i) {
            this.remove(i);
        }
    }

    private class FutureTaskImpl
    extends FutureTask<Void> {
        public FutureTaskImpl() {
            super(new RunnableImpl(), null);
        }
    }

    private class RunnableImpl
    implements Runnable {
        private RunnableImpl() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long l = System.currentTimeMillis();
            Task.this.setState(2);
            try {
                Task.this.runImpl();
            }
            catch (Throwable throwable) {
                if (Task.this.isLogError()) {
                    LOGGER.log(Level.SEVERE, throwable.getMessage(), throwable);
                }
                Task.this.error(new TaskError(throwable));
            }
            finally {
                List<TaskError> list = TaskErrorManager.getInstance().getAndRemoveWarnings();
                if (list != null && !list.isEmpty()) {
                    Task.this.getWarnings().addAll(list);
                }
                Task.this.setState(3);
            }
            Task.this.putValue(KEY_ELAPSED_TIME, System.currentTimeMillis() - l);
        }
    }
}

