/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.task;

import com.ef_prime.rflow.core.task.TaskError;
import com.ef_prime.rflow.resource.Messages;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import java.util.HashSet;
import java.util.List;

public class TaskErrorManager {
    private static final TaskErrorManager instance = new TaskErrorManager();
    private Multimap<Thread, TaskError> warningsMap = LinkedListMultimap.create();

    private TaskErrorManager() {
    }

    public static TaskErrorManager getInstance() {
        return instance;
    }

    public void warning(String string) {
        this.warning(new TaskError(Messages.getString("Error.title.warning"), string, null));
    }

    public void warning(TaskError taskError) {
        this.warningsMap.put((Object)Thread.currentThread(), (Object)taskError);
    }

    public List<TaskError> getWarnings() {
        return (List)this.warningsMap.get((Object)Thread.currentThread());
    }

    public List<TaskError> getAndRemoveWarnings() {
        return (List)this.warningsMap.removeAll((Object)Thread.currentThread());
    }

    public void moveWarnings(Thread thread) {
        this.warningsMap.putAll((Object)thread, (Iterable)this.warningsMap.removeAll((Object)Thread.currentThread()));
    }

    public void cleanUp() {
        for (Thread thread : new HashSet(this.warningsMap.keySet())) {
            if (thread.isAlive()) continue;
            this.warningsMap.removeAll((Object)thread);
        }
    }
}

