/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.task;

import com.ef_prime.rflow.core.common.keyvalue.ListKey;
import com.ef_prime.rflow.core.common.keyvalue.ValueMap;
import com.ef_prime.rflow.core.common.keyvalue.ValueMapKey;
import com.ef_prime.rflow.core.common.util.Utility;
import com.ef_prime.rflow.core.feature.history.TaskTreeTableNode;
import com.ef_prime.rflow.core.flow.FlowNode;
import com.ef_prime.rflow.core.flow.FlowRunOption;
import com.ef_prime.rflow.core.task.NodeModelTask;
import com.ef_prime.rflow.core.task.RCommandTask;
import com.ef_prime.rflow.core.task.Task;
import com.ef_prime.rflow.core.task.TaskEvent;
import com.ef_prime.rflow.core.task.TaskEventHandler;
import com.ef_prime.rflow.node.base.ListNodeModel;
import com.ef_prime.rflow.ui.base.Icons;
import com.ef_prime.rflow.ui.common.component.TreeIterator;
import com.ef_prime.rflow.ui.common.item.ItemName;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.swing.Icon;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.jdesktop.swingx.treetable.MutableTreeTableNode;

public class TaskGroup
extends Task {
    private static final ValueMapKey LIST_TASK = ((ValueMapKey.Builder)((ValueMapKey.Builder)((ValueMapKey.Builder)((Object)ValueMapKey.builder("task", "task", null).addClass("model", NodeModelTask.class))).addClass("group", TaskGroup.class)).addClass("rcommand", RCommandTask.class)).build();
    private static final ListKey<ValueMap> KEY_CHILDREN = new ListKey<ValueMap>("children", "children", LIST_TASK);
    private ChildEventHandler childEventHandler = new ChildEventHandler();
    private Icon icon;

    public static TaskGroup createRunTaskGroup(FlowRunOption flowRunOption) {
        return new TaskGroup(flowRunOption, "Run");
    }

    public TaskGroup() {
        this(FlowRunOption.createRunNodeOption(), "");
    }

    public TaskGroup(FlowRunOption flowRunOption, String string) {
        super(flowRunOption);
        this.setTitle(string);
        this.registerKeys(KEY_CHILDREN);
        this.init();
    }

    private TaskGroup(TaskGroup taskGroup) {
        super(taskGroup);
        this.init();
    }

    private void init() {
        this.icon = Icons.getIcon("16/resultset_next.png");
    }

    @Override
    public String getTitle() {
        return super.getTitle() + " (" + this.getChildCount() + ")";
    }

    @Override
    public Icon getIcon() {
        return this.icon;
    }

    @Override
    public synchronized List<ItemName> getResults() {
        ArrayList<ItemName> arrayList = new ArrayList<ItemName>();
        for (int i = 0; i < this.getChildCount(); ++i) {
            Task task = (Task)this.getChildAt(i);
            arrayList.addAll(task.getResults());
        }
        return arrayList;
    }

    @Override
    public ItemName getPrimaryResult() {
        if (this.getChildCount() == 0) {
            return null;
        }
        Task task = (Task)this.getChildAt(this.getChildCount() - 1);
        return task.getPrimaryResult();
    }

    @Override
    protected void runImpl() {
    }

    @Override
    public Task copyTask() {
        return new TaskGroup(this);
    }

    @Override
    public List<Task> getChildren() {
        return (List)Utility.cast(this.getValue(KEY_CHILDREN));
    }

    @Override
    public List<Task> toFlatList() {
        ArrayList<Task> arrayList = new ArrayList<Task>();
        ArrayDeque<Task> arrayDeque = new ArrayDeque<Task>();
        arrayDeque.push(this);
        while (!arrayDeque.isEmpty()) {
            Task task = (Task)arrayDeque.pop();
            if (task.isGroup()) {
                List<Task> list = task.getChildren();
                for (int i = list.size() - 1; i >= 0; --i) {
                    arrayDeque.push(list.get(i));
                }
                continue;
            }
            arrayList.add(task);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FlowNode createFlowNode() {
        ListNodeModel listNodeModel = new ListNodeModel();
        FlowNode flowNode = new FlowNode(listNodeModel);
        flowNode.getProperty().setTitle(this.getTitle());
        TaskGroup taskGroup = this;
        synchronized (taskGroup) {
            for (Task task : this.getChildren()) {
                listNodeModel.addNode(task.createFlowNode(), null);
            }
        }
        return flowNode;
    }

    @Override
    public synchronized boolean isError() {
        for (Task task : this.getChildren()) {
            if (!task.isError()) continue;
            return true;
        }
        return false;
    }

    @Override
    public synchronized boolean isWarning() {
        for (Task task : this.getChildren()) {
            if (!task.isWarning()) continue;
            return true;
        }
        return false;
    }

    @Override
    public synchronized boolean isCancelled() {
        for (Task task : this.getChildren()) {
            if (!task.isCancelled()) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() {
        super.reset();
        ArrayList<Task> arrayList = new ArrayList<Task>();
        TaskGroup taskGroup = this;
        synchronized (taskGroup) {
            TreeIterator object = new TreeIterator(this);
            object.next();
            while (object.hasNext()) {
                Task task = (Task)object.next();
                arrayList.add(task);
            }
        }
        for (Task task : arrayList) {
            task.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshState() {
        if (this.getChildCount() == 0) {
            this.setState(0);
            return;
        }
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        TaskGroup taskGroup = this;
        synchronized (taskGroup) {
            for (Task task : this.getChildren()) {
                switch (task.getState()) {
                    case 0: {
                        ++n;
                        break;
                    }
                    case 1: {
                        ++n2;
                        break;
                    }
                    case 2: {
                        bl = true;
                    }
                }
            }
        }
        if (bl) {
            this.setState(2);
        } else if (n2 > 0) {
            this.setState(1);
        } else if (n > 0) {
            this.setState(0);
        } else {
            this.setState(3);
        }
    }

    @Override
    public boolean isDone() {
        return this.getState() == 3;
    }

    @Override
    public synchronized TreeNode getChildAt(int n) {
        return this.getChildren().get(n);
    }

    @Override
    public synchronized int getChildCount() {
        return this.getChildren().size();
    }

    @Override
    public synchronized int getIndex(TreeNode treeNode) {
        return this.getChildren().indexOf(treeNode);
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    @Override
    public synchronized Enumeration<? extends TreeNode> children() {
        return Collections.enumeration(this.getChildren());
    }

    @Override
    public synchronized void insert(MutableTreeNode mutableTreeNode, int n) {
        Task task = (Task)mutableTreeNode;
        Task task2 = (Task)task.getParent();
        if (task2 != null) {
            task2.remove(task);
        }
        task.setParent(this);
        this.getChildren().add(n, task);
        task.addTaskEventHandler(this.childEventHandler);
        TaskTreeTableNode taskTreeTableNode = task.getTreeTableNode().getParent();
        if (taskTreeTableNode != null) {
            taskTreeTableNode.remove((MutableTreeTableNode)task.getTreeTableNode());
        }
        this.getTreeTableNode().insert((MutableTreeTableNode)task.getTreeTableNode(), n);
    }

    @Override
    public synchronized void remove(int n) {
        Task task = (Task)this.getChildAt(n);
        this.getChildren().remove(n);
        task.setParent(null);
        task.removeTaskEventHandler(this.childEventHandler);
        this.getTreeTableNode().remove(n);
    }

    @Override
    public synchronized void remove(MutableTreeNode mutableTreeNode) {
        this.remove(this.getIndex(mutableTreeNode));
    }

    private class ChildEventHandler
    implements TaskEventHandler {
        private ChildEventHandler() {
        }

        @Override
        public void taskStateChanged(TaskEvent taskEvent) {
            if (taskEvent.isRunning()) {
                TaskGroup.this.setState(2);
            } else {
                TaskGroup.this.refreshState();
            }
        }
    }
}

