/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.task;

import com.ef_prime.rflow.Rflow;
import com.ef_prime.rflow.core.common.util.ThreadUtility;
import com.ef_prime.rflow.core.feature.history.HistoryManager;
import com.ef_prime.rflow.core.flow.FlowRunOption;
import com.ef_prime.rflow.core.task.Task;
import com.ef_prime.rflow.core.task.TaskEvent;
import com.ef_prime.rflow.core.task.TaskEventHandler;
import com.ef_prime.rflow.core.task.TaskQueueEvent;
import com.ef_prime.rflow.core.task.TaskQueueEventHandler;
import com.ef_prime.rflow.ui.common.event.EventSupport;
import com.ef_prime.rflow.ui.common.item.ItemName;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.Deque;
import java.util.Iterator;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TaskQueue
implements TaskEventHandler {
    private static final Logger LOGGER = Logger.getLogger(TaskQueue.class.getName());
    private static TaskQueue instance = new TaskQueue();
    private ThreadPoolExecutor executor;
    private Deque<Task> runningList;
    private EventSupport<TaskQueueEvent, TaskQueueEventHandler> taskQueueEventSupport = new EventSupport();
    private FocusResultHandler focusResultHandler = new FocusResultHandler();

    private TaskQueue() {
        this.executor = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
        this.runningList = new ArrayDeque<Task>();
    }

    public static TaskQueue getInstance() {
        return instance;
    }

    public void addTask(Task task) {
        this.taskQueueEventSupport.dispatchEvent(new TaskQueueEvent(0, task));
        if (Rflow.isDevel() && !task.getOption().isNoHistory()) {
            HistoryManager.getInstance().add(task);
        }
        if (task.getOption().isFocusResult() || task.getOption().isWeakFocusResult()) {
            task.addTaskEventHandler(this.focusResultHandler);
        }
        if (task.isGroup()) {
            for (Task task2 : task.toFlatList()) {
                this.runTask(task2);
            }
        } else {
            this.runTask(task);
        }
    }

    private void runTask(Task task) {
        if (task.getOption().isRunImmediately()) {
            ThreadUtility.execute(() -> task.run());
        } else {
            task.addTaskEventHandler(this);
            task.queued();
            this.executor.execute(task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        ArrayList<Runnable> arrayList;
        try {
            arrayList = new ArrayList<Runnable>(this.executor.getQueue());
            for (Runnable runnable : arrayList) {
                Task task = (Task)runnable;
                if (task.isDone() || task.isCancelled()) continue;
                this.remove(task);
                task.cancel(true);
            }
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            LOGGER.log(Level.WARNING, "Unexpected ConcurrentModificationException.", concurrentModificationException);
        }
        arrayList = null;
        Iterator iterator = this.runningList;
        synchronized (iterator) {
            arrayList = new ArrayList<Task>(this.runningList);
        }
        for (Runnable runnable : arrayList) {
            ((Task)runnable).cancel(true);
        }
    }

    public void cancel(Task task) {
        this.remove(task);
        this.cancelTask(task);
    }

    private void remove(Task task) {
        this.executor.remove(task);
        task.removeTaskEventHandler(this);
        if (task.isGroup()) {
            for (Task task2 : task.getChildren()) {
                this.remove(task2);
            }
        }
    }

    private void cancelTask(Task task) {
        if (!task.isDone()) {
            task.cancel(true);
            if (task.isGroup()) {
                for (Task task2 : task.getChildren()) {
                    this.cancelTask(task2);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void taskStateChanged(TaskEvent taskEvent) {
        if (taskEvent.isRunning()) {
            Deque<Task> deque = this.runningList;
            synchronized (deque) {
                this.runningList.add(taskEvent.getTask());
            }
        }
        if (taskEvent.isDone()) {
            Task task = taskEvent.getTask();
            Deque<Task> deque = this.runningList;
            synchronized (deque) {
                this.runningList.remove(task);
            }
            task.removeTaskEventHandler(this);
        }
    }

    public void addTaskQueueEventHandler(TaskQueueEventHandler taskQueueEventHandler) {
        this.taskQueueEventSupport.addEventHandler(taskQueueEventHandler);
    }

    public void removeTaskQueueEventHandler(TaskQueueEventHandler taskQueueEventHandler) {
        this.taskQueueEventSupport.removeEventHandler(taskQueueEventHandler);
    }

    private static class FocusResultHandler
    implements TaskEventHandler {
        private FocusResultHandler() {
        }

        @Override
        public void taskStateChanged(TaskEvent taskEvent) {
            ItemName itemName;
            if (!taskEvent.isDone()) {
                return;
            }
            Task task = taskEvent.getTask();
            FlowRunOption flowRunOption = task.getOption();
            if ((flowRunOption.isFocusResult() || flowRunOption.isWeakFocusResult()) && !task.isPreview() && (itemName = task.getPrimaryResult()) != null) {
                if (flowRunOption.isFocusResult()) {
                    itemName.requestFocus();
                } else {
                    itemName.requestWeakFocus();
                }
            }
        }
    }
}

