/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.util;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.function.Predicate;

public class FileRecord {
    private String path;
    private Predicate<File> filter;
    private boolean isDirectory;
    private long lastModified;
    private List<FileRecord> children;

    public FileRecord(File file, boolean bl, Predicate<File> predicate) {
        this.path = file.getAbsolutePath();
        this.isDirectory = file.isDirectory();
        this.lastModified = file.lastModified();
        this.filter = predicate;
        if (this.isDirectory && bl) {
            File[] fileArray;
            this.children = new ArrayList<FileRecord>();
            for (File file2 : fileArray = file.listFiles()) {
                if (predicate != null && !predicate.test(file2)) continue;
                this.children.add(new FileRecord(file2, true, predicate));
            }
        }
    }

    public String getPath() {
        return this.path;
    }

    public boolean isDirectory() {
        return this.isDirectory;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public List<FileRecord> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    public int getChildCount() {
        return this.children == null ? 0 : this.children.size();
    }

    public boolean hadChanged() {
        int n;
        File file = new File(this.path);
        if (this.filter != null && !this.filter.test(file)) {
            return false;
        }
        if (!file.exists()) {
            return true;
        }
        if (file.isDirectory() != this.isDirectory) {
            return true;
        }
        if (!this.isDirectory) {
            return file.lastModified() != this.lastModified;
        }
        File[] fileArray = file.listFiles();
        int n2 = n = fileArray == null ? 0 : fileArray.length;
        if (n < this.getChildCount()) {
            return true;
        }
        HashSet<Object> hashSet = new HashSet<Object>();
        if (fileArray != null) {
            for (File file2 : fileArray) {
                hashSet.add(file2);
            }
        }
        if (this.children != null) {
            for (FileRecord fileRecord : this.children) {
                hashSet.remove(new File(fileRecord.getPath()));
                if (!fileRecord.hadChanged()) continue;
                return true;
            }
        }
        for (File file3 : hashSet) {
            if (this.filter != null && !this.filter.test(file3)) continue;
            return true;
        }
        return false;
    }
}

