/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.util;

public enum Platform {
    LINUX,
    MAC,
    WINDOWS,
    WINDOWS6,
    OTHER;

    private static Platform platform;

    public static Platform getPlatform() {
        if (platform == null) {
            String string = System.getProperty("os.name");
            if (string == null) {
                platform = OTHER;
            } else if (string.startsWith("Windows")) {
                platform = WINDOWS;
                String string2 = System.getProperty("os.version");
                if (string2 != null) {
                    String[] stringArray = string2.split("\\.", 2);
                    try {
                        int n = Integer.parseInt(stringArray[0]);
                        if (n >= 6) {
                            platform = WINDOWS6;
                        }
                    }
                    catch (Exception exception) {}
                }
            } else {
                platform = string.contains("Linux") ? LINUX : (string.contains("Mac") ? MAC : OTHER);
            }
        }
        return platform;
    }

    public static boolean isWindowsFamily() {
        return Platform.getPlatform() == WINDOWS6 || Platform.getPlatform() == WINDOWS;
    }

    public static boolean isMac() {
        return Platform.getPlatform() == MAC;
    }

    public static boolean isLinux() {
        return Platform.getPlatform() == LINUX;
    }

    public static String getInstallFolder() {
        switch (Platform.getPlatform().ordinal()) {
            case 2: 
            case 3: {
                return "windows";
            }
            case 1: {
                return "mac";
            }
        }
        return "linux";
    }
}

