/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.util;

public class ScriptBuilder {
    private StringBuilder sb;
    private String newline;
    private int indentCount;
    private boolean lineStart = true;
    private String indent = "\t";

    public ScriptBuilder() {
        this("\n");
    }

    public ScriptBuilder(String string) {
        this(string, 16);
    }

    public ScriptBuilder(String string, int n) {
        this.sb = new StringBuilder(n);
        this.newline = string;
    }

    public ScriptBuilder setNewline(String string) {
        this.newline = string;
        return this;
    }

    public ScriptBuilder append(char c) {
        this.insertIndents();
        this.sb.append(c);
        this.lineStart = false;
        return this;
    }

    public ScriptBuilder append(CharSequence charSequence) {
        this.insertIndents();
        this.sb.append(charSequence);
        this.lineStart = false;
        return this;
    }

    public ScriptBuilder appendLn() {
        return this.appendLn("");
    }

    public ScriptBuilder appendLn(CharSequence charSequence) {
        this.insertIndents();
        this.sb.append(charSequence);
        this.sb.append(this.newline);
        this.lineStart = true;
        return this;
    }

    public ScriptBuilder appendIndented(String string) {
        int n = 0;
        int n2 = string.indexOf(this.newline);
        while (n < string.length()) {
            this.sb.append(this.indent);
            if (n2 < 0) {
                this.sb.append(string.subSequence(n, string.length()));
                break;
            }
            this.sb.append(string.subSequence(n, n2 + this.newline.length()));
            n = n2 + this.newline.length();
            n2 = string.indexOf(this.newline, n);
        }
        if (!string.endsWith(this.newline)) {
            this.appendLn();
        }
        return this;
    }

    private void insertIndents() {
        if (this.lineStart) {
            for (int i = 0; i < this.indentCount; ++i) {
                this.sb.append(this.indent);
            }
        }
    }

    public ScriptBuilder indent() {
        ++this.indentCount;
        return this;
    }

    public ScriptBuilder unindent() {
        --this.indentCount;
        if (this.indentCount < 0) {
            this.indentCount = 0;
        }
        return this;
    }

    public ScriptBuilder indentLn(CharSequence charSequence) {
        return this.indent().appendLn(charSequence);
    }

    public ScriptBuilder appLnInd(CharSequence charSequence) {
        return this.appendLn(charSequence).indent();
    }

    public ScriptBuilder unind_Ln(CharSequence charSequence) {
        return this.unindent().appendLn(charSequence);
    }

    public ScriptBuilder unLn_Ind(CharSequence charSequence) {
        return this.unindent().appendLn(charSequence).indent();
    }

    public String toString() {
        return this.sb.toString();
    }
}

