/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.util;

import java.util.logging.Logger;

public class Version
implements Comparable<Version> {
    private static final Logger LOGGER = Logger.getLogger(Version.class.getName());
    public static final Version ZERO = new Version(0, 0, 0, null, null);
    private int major;
    private int minor;
    private int micro;
    private int revision;
    private String label;
    private String date;

    public static Version parse(String string) throws Exception {
        if (string == null || string.isEmpty()) {
            return ZERO;
        }
        int n = 0;
        int n2 = 0;
        String string2 = null;
        String string3 = null;
        String[] stringArray = string.split("\\.");
        int n3 = Integer.parseInt(stringArray[0]);
        if (stringArray.length > 1) {
            n = Integer.parseInt(stringArray[1]);
        }
        if (stringArray.length > 2) {
            n2 = Integer.parseInt(stringArray[2]);
        }
        if (stringArray.length > 3) {
            string3 = stringArray[3];
        }
        if (stringArray.length > 4) {
            string2 = stringArray[4];
        }
        return new Version(n3, n, n2, string3, string2);
    }

    public static Version parseOrDefault(String string, Version version) {
        try {
            return Version.parse(string);
        }
        catch (Exception exception) {
            return version;
        }
    }

    public static boolean isNewer(String string, String string2) {
        try {
            Version version = Version.parse(string);
            Version version2 = Version.parse(string2);
            if (version.compareTo(version2) < 0) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public Version(int n, int n2, int n3) {
        this(n, n2, n3, null);
    }

    public Version(int n, int n2, int n3, String string) {
        this(n, n2, n3, string, null);
    }

    public Version(int n, int n2, int n3, String string, String string2) {
        this.major = n;
        this.minor = n2;
        this.micro = n3;
        this.label = string;
        if (string != null) {
            String string3 = string;
            int n4 = string.indexOf(45);
            if (n4 >= 0) {
                string3 = string.substring(n4);
            }
            if (Version.isDigits(string3)) {
                try {
                    this.revision = Integer.parseInt(string3);
                }
                catch (Exception exception) {
                    LOGGER.warning("Failed to parse revision number");
                }
            }
        }
        this.date = string2;
    }

    public Version(int n, int n2, int n3, int n4) {
        this.major = n;
        this.minor = n2;
        this.micro = n3;
        this.revision = n4;
        this.label = Integer.toString(n4);
        this.date = null;
    }

    private static boolean isDigits(String string) {
        if (string.isEmpty()) {
            return false;
        }
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c >= '0' && c <= '9') continue;
            return false;
        }
        return true;
    }

    public String getVersionMajor() {
        return String.valueOf(this.major);
    }

    public String getVersionMinor() {
        return this.major + "." + this.minor;
    }

    public String getVersionString() {
        return this.getVersionMinor() + "." + this.micro;
    }

    public String getDate() {
        return this.date;
    }

    public String getYear() {
        if (this.date == null || this.date.length() < 4) {
            return null;
        }
        return this.date.substring(0, 4);
    }

    public String getLabel() {
        return this.label;
    }

    public boolean isNewerThan(String string) {
        try {
            Version version = Version.parse(string);
            return this.compareTo(version) > 0;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean isOlderThan(String string) {
        try {
            Version version = Version.parse(string);
            return this.compareTo(version) < 0;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean isNewerThan(Version version) {
        return this.compareTo(version) > 0;
    }

    public boolean isOlderThan(Version version) {
        return this.compareTo(version) < 0;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.major);
        stringBuilder.append(".");
        stringBuilder.append(this.minor);
        stringBuilder.append(".");
        stringBuilder.append(this.micro);
        if (this.label != null && !this.label.isEmpty()) {
            stringBuilder.append(".");
            stringBuilder.append(this.label);
        }
        if (this.date != null && !this.date.isEmpty()) {
            stringBuilder.append(".");
            stringBuilder.append(this.date);
        }
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (object instanceof Version) {
            return this.compareTo((Version)object) == 0;
        }
        return false;
    }

    @Override
    public int compareTo(Version version) {
        int n;
        int n2 = Version.compareInt(this.major, version.major);
        if (n2 != 0) {
            return n2;
        }
        n2 = Version.compareInt(this.minor, version.minor);
        if (n2 != 0) {
            return n2;
        }
        n2 = Version.compareInt(this.micro, version.micro);
        if (n2 != 0) {
            return n2;
        }
        int n3 = this.labelToNumber(this.label);
        n2 = Version.compareInt(n3, n = this.labelToNumber(version.label));
        if (n2 != 0) {
            return n2;
        }
        n2 = Version.compareInt(this.revision, version.revision);
        if (n2 != 0) {
            return n2;
        }
        if (this.date != null && version.date != null && (n2 = this.date.compareTo(version.date)) != 0) {
            return n2;
        }
        return 0;
    }

    public int compareMainPartTo(Version version) {
        int n = Version.compareInt(this.major, version.major);
        if (n != 0) {
            return n;
        }
        n = Version.compareInt(this.minor, version.minor);
        if (n != 0) {
            return n;
        }
        n = Version.compareInt(this.micro, version.micro);
        if (n != 0) {
            return n;
        }
        return 0;
    }

    private int labelToNumber(String string) {
        if (string == null) {
            return 0;
        }
        if ((string = string.toLowerCase()).startsWith("snapshot")) {
            return -20;
        }
        if (string.startsWith("alpha")) {
            return -10;
        }
        if (string.startsWith("beta")) {
            return -5;
        }
        if (string.startsWith("rc")) {
            return -2;
        }
        return 0;
    }

    private static int compareInt(int n, int n2) {
        if (n < n2) {
            return -1;
        }
        if (n > n2) {
            return 1;
        }
        return 0;
    }
}

