/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.util;

import com.sun.jna.Native;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.win32.W32APIOptions;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WindowsUtility {
    private static final Logger LOGGER = Logger.getLogger(WindowsUtility.class.getName());

    public static boolean setCurrentDirectory(String string) {
        return Kernel32Ex.INSTANCE.SetCurrentDirectory(string);
    }

    public static boolean setEnvironmentVariable(String string, String string2) {
        return Kernel32Ex.INSTANCE.SetEnvironmentVariable(string, string2);
    }

    public static String getShortPathName(String string) {
        try {
            char[] cArray = new char[string.length() * 2];
            int n = Kernel32Ex.INSTANCE.GetShortPathName(string, cArray, cArray.length);
            if (n == 0) {
                if (Files.exists(Paths.get(string, new String[0]), new LinkOption[0])) {
                    LOGGER.warning("Failed to convert to short path name.");
                }
                return string;
            }
            if (n == cArray.length) {
                LOGGER.warning("Failed to convert to short path name. Buffer too small.");
                return string;
            }
            return new String(cArray, 0, n);
        }
        catch (Throwable throwable) {
            LOGGER.log(Level.WARNING, "Failed to convert to short path name.", throwable);
            return string;
        }
    }

    public static interface Kernel32Ex
    extends Kernel32 {
        public static final Kernel32Ex INSTANCE = (Kernel32Ex)Native.loadLibrary((String)"kernel32", Kernel32Ex.class, (Map)W32APIOptions.UNICODE_OPTIONS);

        public boolean SetCurrentDirectory(String var1);
    }
}

