/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.util;

import com.ef_prime.rflow.core.app.file.FileUtility;
import com.ef_prime.rflow.core.util.XMLException;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;

public class XMLWriter {
    private Writer out;
    private boolean indent;
    private Stack<Element> openElements;
    private Transformer transformer;

    public XMLWriter(Writer writer) {
        this(writer, true);
    }

    public XMLWriter(Writer writer, boolean bl) {
        this.out = writer;
        this.indent = bl;
        this.openElements = new Stack();
    }

    public String currentElement() {
        if (this.openElements.isEmpty()) {
            return null;
        }
        return this.openElements.peek().name;
    }

    public boolean isCurrentElement(String string) {
        String string2 = this.currentElement();
        return string2 != null && string2.equals(string);
    }

    public void close() throws XMLException {
        try {
            this.out.close();
        }
        catch (IOException iOException) {
            throw new XMLException(iOException);
        }
    }

    public void writeAttribute(String string, String string2) throws XMLException {
        if (this.openElements.isEmpty()) {
            throw new XMLException();
        }
        this.getCurrentOpenElement().addAttribute(new Attribute(string, string2));
    }

    public void writeCharacters(String string) throws XMLException {
        if (this.openElements.isEmpty()) {
            throw new XMLException();
        }
        this.getCurrentOpenElement().isText = true;
        this.flushOpenElement(false);
        try {
            this.out.write(this.replaceChar(string));
        }
        catch (IOException iOException) {
            throw new XMLException(iOException);
        }
    }

    public void writeDTD(String string) throws XMLException {
        try {
            this.out.write(string);
            if (!string.endsWith("\n")) {
                this.newLine();
            }
        }
        catch (IOException iOException) {
            throw new XMLException(iOException);
        }
    }

    public void writeEndDocument() throws XMLException {
    }

    public void writeEndElement() throws XMLException {
        if (this.openElements.isEmpty()) {
            throw new XMLException();
        }
        try {
            if (!this.getCurrentOpenElement().doneWrite && !this.getCurrentOpenElement().isEmpty) {
                this.flushOpenElement(true);
            } else {
                if (this.getCurrentOpenElement().isEmpty) {
                    this.flushOpenElement(true);
                }
                Element element = this.getCurrentOpenElement();
                if (!element.isText) {
                    this.tabs();
                }
                this.out.write("</" + element.name + ">");
                this.newLine();
                this.popOpenElement();
            }
        }
        catch (IOException iOException) {
            throw new XMLException(iOException);
        }
    }

    public void writeEmptyElement(String string) throws XMLException {
        this.flushOpenElement(false);
        this.pushOpenElement(new Element(string, true));
    }

    public void writeStartDocument(String string, String string2) throws XMLException {
        try {
            this.out.write("<?xml version=\"" + string2 + "\" encoding=\"" + string + "\"?>");
            this.newLine();
        }
        catch (IOException iOException) {
            throw new XMLException(iOException);
        }
    }

    public void writeStartElement(String string) throws XMLException {
        this.flushOpenElement(false);
        this.pushOpenElement(new Element(string, false));
    }

    public void writeElement(org.w3c.dom.Element element) throws XMLException {
        this.flushOpenElement(false);
        try {
            StringWriter stringWriter = new StringWriter();
            this.getTransformer().transform(new DOMSource(element), new StreamResult(stringWriter));
            String string = FileUtility.replaceToLF(stringWriter.toString());
            this.out.write(string);
        }
        catch (IOException | TransformerException exception) {
            throw new XMLException(exception);
        }
    }

    private Transformer getTransformer() throws XMLException {
        if (this.transformer == null) {
            try {
                TransformerFactory transformerFactory = TransformerFactory.newInstance();
                this.transformer = transformerFactory.newTransformer();
            }
            catch (Throwable throwable) {
                throw new XMLException(throwable);
            }
            this.transformer.setOutputProperty("encoding", "UTF-8");
            this.transformer.setOutputProperty("method", "xml");
            this.transformer.setOutputProperty("indent", "yes");
            this.transformer.setOutputProperty("omit-xml-declaration", "yes");
        }
        return this.transformer;
    }

    private void pushOpenElement(Element element) {
        this.openElements.push(element);
    }

    private Element getCurrentOpenElement() {
        if (this.openElements.isEmpty()) {
            return null;
        }
        return this.openElements.peek();
    }

    private void flushOpenElement(boolean bl) throws XMLException {
        Element element = this.getCurrentOpenElement();
        if (element != null && !element.doneWrite) {
            try {
                this.tabs();
                this.out.write("<" + element.name);
                for (Attribute attribute : element.attrs) {
                    this.out.write(" " + attribute.name + "=\"" + this.replaceChar(attribute.value) + "\"");
                }
                if (element.isEmpty || bl) {
                    this.out.write("/>");
                } else {
                    this.out.write(">");
                }
                if (!element.isText) {
                    this.newLine();
                }
                element.doneWrite = true;
                if (element.isEmpty || bl) {
                    this.openElements.pop();
                }
            }
            catch (IOException iOException) {
                throw new XMLException(iOException);
            }
        }
    }

    private Element popOpenElement() throws XMLException {
        if (this.openElements.isEmpty()) {
            throw new XMLException();
        }
        return this.openElements.pop();
    }

    private String replaceChar(String string) {
        string = string.replaceAll("&", "&amp;");
        string = string.replaceAll("<", "&lt;");
        string = string.replaceAll(">", "&gt;");
        string = string.replaceAll("'", "&apos;");
        string = string.replaceAll("\"", "&quot;");
        return string;
    }

    private void tabs() throws IOException {
        if (this.indent) {
            for (int i = 0; i < this.openElements.size() - 1; ++i) {
                this.out.write("\t");
            }
        }
    }

    private void newLine() throws IOException {
        if (this.indent) {
            this.out.write("\n");
        }
    }

    private static class Element {
        String name;
        List<Attribute> attrs = new ArrayList<Attribute>();
        boolean doneWrite = false;
        boolean isEmpty;
        boolean isText = false;

        public Element(String string, boolean bl) {
            this.name = string;
            this.isEmpty = bl;
        }

        public void addAttribute(Attribute attribute) {
            this.attrs.add(attribute);
        }
    }

    private static class Attribute {
        String name;
        String value;

        public Attribute(String string, String string2) {
            this.name = string;
            this.value = string2;
        }
    }
}

