/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.util;

import com.ef_prime.rflow.core.util.Yamlable;
import com.google.common.io.Files;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.composer.Composer;
import org.yaml.snakeyaml.emitter.Emitable;
import org.yaml.snakeyaml.emitter.Emitter;
import org.yaml.snakeyaml.error.YAMLException;
import org.yaml.snakeyaml.nodes.MappingNode;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.NodeId;
import org.yaml.snakeyaml.nodes.NodeTuple;
import org.yaml.snakeyaml.nodes.ScalarNode;
import org.yaml.snakeyaml.nodes.SequenceNode;
import org.yaml.snakeyaml.nodes.Tag;
import org.yaml.snakeyaml.parser.Parser;
import org.yaml.snakeyaml.parser.ParserImpl;
import org.yaml.snakeyaml.reader.StreamReader;
import org.yaml.snakeyaml.representer.Represent;
import org.yaml.snakeyaml.representer.Representer;
import org.yaml.snakeyaml.serializer.Serializer;

public class YamlEx
extends Yaml {
    public static final String TYPE = "type";
    public static final String VALUE = "value";

    public YamlEx() {
        super((Representer)new RepresenterEx());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpNode(File file, Node node) throws IOException {
        try (BufferedWriter bufferedWriter = Files.newWriter((File)file, (Charset)StandardCharsets.UTF_8);){
            Serializer serializer = new Serializer((Emitable)new Emitter((Writer)bufferedWriter, this.dumperOptions), this.resolver, this.dumperOptions, null);
            serializer.open();
            serializer.serialize(node);
            serializer.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump(File file, Object object) throws IOException {
        try (BufferedWriter bufferedWriter = Files.newWriter((File)file, (Charset)StandardCharsets.UTF_8);){
            this.dump(object, bufferedWriter);
        }
    }

    public Object load(File file) throws IOException {
        try (BufferedReader bufferedReader = Files.newReader((File)file, (Charset)StandardCharsets.UTF_8);){
            Object object = this.load(bufferedReader);
            return object;
        }
    }

    public void dumpYamlable(File file, Yamlable yamlable) throws IOException {
        this.dump(file, yamlable.toYamlValue(this));
    }

    public void loadYamlable(File file, Yamlable yamlable) throws IOException {
        yamlable.loadYamlValue(this, this.load(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node compose(File file) throws IOException {
        try (BufferedReader bufferedReader = Files.newReader((File)file, (Charset)StandardCharsets.UTF_8);){
            Node node = this.compose(bufferedReader);
            return node;
        }
    }

    public Map<String, Node> toMap(MappingNode mappingNode) {
        HashMap<String, Node> hashMap = new HashMap<String, Node>();
        for (NodeTuple nodeTuple : mappingNode.getValue()) {
            Node node = nodeTuple.getKeyNode();
            if (node.getNodeId() != NodeId.scalar) continue;
            String string = ((ScalarNode)node).getValue();
            this.constructor.setComposer(this.createComposer(string));
            Object object = this.constructor.getSingleData(String.class);
            if (object == null) continue;
            hashMap.put(object.toString(), nodeTuple.getValueNode());
        }
        return hashMap;
    }

    private Composer createComposer(String string) {
        return new Composer((Parser)new ParserImpl(new StreamReader(string)), this.resolver);
    }

    public static Map<Object, Object> map(Object object) {
        return (Map)YamlEx.typeCheck(Map.class, object);
    }

    public static String string(Object object) {
        return (String)YamlEx.typeCheck(String.class, object);
    }

    public static boolean bool(Object object, boolean bl) {
        Boolean bl2 = (Boolean)YamlEx.typeCheck(Boolean.class, object);
        return bl2 == null ? bl : bl2;
    }

    public static <T> T typeCheck(Class<?> clazz, Object object) {
        if (object == null) {
            return null;
        }
        if (clazz.isInstance(object)) {
            return (T)object;
        }
        throw new YAMLException("Incompatible type. value:" + String.valueOf(object.getClass()) + " expected:" + String.valueOf(clazz));
    }

    public static <V> V mapValue(Class<V> clazz, Object object, Map<?, ?> map) {
        Object obj = map.get(object);
        if (obj == null) {
            throw new YAMLException("Required key is missing. key:" + String.valueOf(object));
        }
        return (V)YamlEx.typeCheck(clazz, obj);
    }

    public static <V> V mapValue(V v, Class<V> clazz, Object object, Map<?, ?> map) {
        Object obj = map.get(object);
        if (obj == null) {
            return v;
        }
        return (V)YamlEx.typeCheck(clazz, obj);
    }

    public static Map<String, Object> yamlValueWithType(Object object) {
        return YamlEx.yamlValueWithType(object.getClass().getName(), object);
    }

    public static Map<String, Object> yamlValueWithType(String string, Object object) {
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
        if (string == null) {
            string = "";
        }
        linkedHashMap.put(TYPE, string);
        linkedHashMap.put(VALUE, object);
        return linkedHashMap;
    }

    public static String typeInYamlValue(Object object) {
        Map map = (Map)YamlEx.typeCheck(Map.class, object);
        return (String)map.get(TYPE);
    }

    public static Object valueInYamlValue(Object object) {
        Map map = (Map)YamlEx.typeCheck(Map.class, object);
        return map.get(VALUE);
    }

    public static Yamlable instanceInYamlValue(YamlEx yamlEx, Object object) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        String string = YamlEx.typeInYamlValue(object);
        Yamlable yamlable = (Yamlable)Class.forName(string).newInstance();
        Object object2 = YamlEx.valueInYamlValue(object);
        yamlable.loadYamlValue(yamlEx, object2);
        return yamlable;
    }

    private static class RepresenterEx
    extends Representer {
        public RepresenterEx() {
            this.multiRepresenters.put(Yamlable.class, new YamlableRepresenter());
            this.multiRepresenters.put(int[].class, new IntArrayRepresenter());
            this.multiRepresenters.put(double[].class, new DoubleArrayRepresenter());
        }

        private Node representArraySequence(Tag tag, int[] nArray, Boolean bl) {
            ArrayList<Node> arrayList = new ArrayList<Node>(nArray.length);
            SequenceNode sequenceNode = new SequenceNode(tag, arrayList, bl);
            this.representedObjects.put(this.objectToRepresent, sequenceNode);
            boolean bl2 = true;
            int[] nArray2 = nArray;
            int n = nArray2.length;
            for (int i = 0; i < n; ++i) {
                Integer n2 = nArray2[i];
                Node node = this.representData(n2);
                if (!(node instanceof ScalarNode) || ((ScalarNode)node).getStyle() != null) {
                    bl2 = false;
                }
                arrayList.add(node);
            }
            if (bl == null) {
                if (this.defaultFlowStyle != DumperOptions.FlowStyle.AUTO) {
                    sequenceNode.setFlowStyle(this.defaultFlowStyle.getStyleBoolean());
                } else {
                    sequenceNode.setFlowStyle(Boolean.valueOf(bl2));
                }
            }
            return sequenceNode;
        }

        private Node representArraySequence(Tag tag, double[] dArray, Boolean bl) {
            ArrayList<Node> arrayList = new ArrayList<Node>(dArray.length);
            SequenceNode sequenceNode = new SequenceNode(tag, arrayList, bl);
            this.representedObjects.put(this.objectToRepresent, sequenceNode);
            boolean bl2 = true;
            double[] dArray2 = dArray;
            int n = dArray2.length;
            for (int i = 0; i < n; ++i) {
                Double d = dArray2[i];
                Node node = this.representData(d);
                if (!(node instanceof ScalarNode) || ((ScalarNode)node).getStyle() != null) {
                    bl2 = false;
                }
                arrayList.add(node);
            }
            if (bl == null) {
                if (this.defaultFlowStyle != DumperOptions.FlowStyle.AUTO) {
                    sequenceNode.setFlowStyle(this.defaultFlowStyle.getStyleBoolean());
                } else {
                    sequenceNode.setFlowStyle(Boolean.valueOf(bl2));
                }
            }
            return sequenceNode;
        }

        private class YamlableRepresenter
        implements Represent {
            private YamlableRepresenter() {
            }

            public Node representData(Object object) {
                Yamlable yamlable = (Yamlable)object;
                Object object2 = yamlable.toYamlValue(null);
                if (object2 instanceof Yamlable) {
                    throw new RuntimeException("toYamlValue returns Yamlable");
                }
                return RepresenterEx.this.representData(object2);
            }
        }

        private class IntArrayRepresenter
        implements Represent {
            private IntArrayRepresenter() {
            }

            public Node representData(Object object) {
                return RepresenterEx.this.representArraySequence(Tag.SEQ, (int[])object, (Boolean)null);
            }
        }

        private class DoubleArrayRepresenter
        implements Represent {
            private DoubleArrayRepresenter() {
            }

            public Node representData(Object object) {
                return RepresenterEx.this.representArraySequence(Tag.SEQ, (double[])object, null);
            }
        }
    }
}

