/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.node;

import com.ef_prime.rflow.ui.base.Prefs;
import com.ef_prime.rflow.ui.base.SubstanceUI;
import com.ef_prime.rflow.ui.util.UIUtility;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.geom.Point2D;
import javax.swing.JComponent;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import javax.swing.undo.UndoManager;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class NodeComment {
    public static final String CLOSED = "closed";
    public static final String OPENED = "opened";
    public static final int CLOSE_BUTTON_SIZE = 15;
    public static final Color FILL_COLOR = SubstanceUI.COLOR_TOOLTIP;
    public static final Color DRAW_COLOR = new Color(170, 170, 170);
    public static final Color SELECTED_DRAW_COLOR = Color.ORANGE;
    public static final Color FONT_COLOR = new Color(64, 64, 64);
    public static final Color CLOSE_MARK_COLOR = new Color(50, 50, 50);
    public static final Color CLOSE_FILL_COLOR = FILL_COLOR;
    public static final Stroke CLOSE_MARK_STROKE = new BasicStroke(1.5f);
    private Color fillColor;
    private Color drawColor;
    private boolean transparent;
    public static final int DEFAULT_OFFSET_X = 15;
    public static final int DEFAULT_OFFSET_Y = -45;
    private CommentTextArea component;
    private Point offset = new Point(15, -45);
    private String state = "closed";
    private boolean commentRollOvered = false;
    private boolean selected = false;
    private boolean editing = false;

    public static NodeComment create() {
        NodeComment nodeComment = new NodeComment();
        nodeComment.fillColor = FILL_COLOR;
        nodeComment.drawColor = DRAW_COLOR;
        nodeComment.transparent = false;
        return nodeComment;
    }

    public static NodeComment createNoBorder() {
        NodeComment nodeComment = new NodeComment();
        nodeComment.fillColor = new Color(255, 255, 255, 210);
        nodeComment.drawColor = Color.WHITE;
        nodeComment.transparent = true;
        return nodeComment;
    }

    private NodeComment() {
    }

    private NodeComment(NodeComment nodeComment) {
        this.fillColor = nodeComment.fillColor;
        this.drawColor = nodeComment.drawColor;
        this.transparent = nodeComment.transparent;
        if (nodeComment.component != null) {
            this.createComment();
            this.setText(nodeComment.component.getText());
        }
        this.offset = (Point)nodeComment.offset.clone();
        this.state = nodeComment.state;
        this.commentRollOvered = nodeComment.commentRollOvered;
    }

    public String getText() {
        return this.component == null ? "" : this.component.getText();
    }

    public void setText(String string) {
        if (this.exists()) {
            this.component.setText(string);
            this.component.undoManager.discardAllEdits();
        }
    }

    public void removeComment() {
        if (this.component != null) {
            Container container = this.component.getParent();
            if (container != null) {
                container.remove(this.component);
            }
            this.component = null;
        }
    }

    public JTextComponent createComment() {
        if (this.component == null) {
            this.component = this.createCommentComponent();
            this.component.setOpaque(!this.transparent);
            this.offset.setLocation(15, -45);
        }
        return this.component;
    }

    public boolean exists() {
        return this.component != null;
    }

    public void setSelected(boolean bl) {
        if (this.selected != bl) {
            this.selected = bl;
        }
    }

    private CommentTextArea createCommentComponent() {
        return new CommentTextArea();
    }

    public JTextComponent getCommentComponent() {
        return this.component;
    }

    public Rectangle getCommentRect(int n, int n2) {
        if (this.component == null || this.offset == null) {
            return null;
        }
        Dimension dimension = this.component.getPreferredSize();
        return new Rectangle(n + this.offset.x, n2 + this.offset.y, dimension.width, dimension.height);
    }

    public Rectangle getCommentIconRect(int n, int n2) {
        int n3 = 10;
        int n4 = 26;
        return new Rectangle(n - 22, n2 - n4 - 1, n3, n3);
    }

    public Rectangle getCloseButtonRect(int n, int n2) {
        if (this.component == null || this.offset == null) {
            return null;
        }
        Dimension dimension = this.component.getPreferredSize();
        return new Rectangle(n + this.offset.x + dimension.width - 15, n2 + this.offset.y, 15, 15);
    }

    public void edit(JComponent jComponent, Point2D point2D) {
        this.setState(OPENED);
        CommentTextArea commentTextArea = this.component;
        if (commentTextArea.getParent() != jComponent) {
            jComponent.add(commentTextArea);
            commentTextArea.setBounds(this.getCommentRect((int)point2D.getX(), (int)point2D.getY()));
            commentTextArea.requestFocusInWindow();
        }
    }

    public Point getOffset() {
        return this.offset;
    }

    public String getState() {
        return this.state;
    }

    public boolean isCommentOpened() {
        return this.state.equals(OPENED);
    }

    public void setState(String string) {
        this.state = string;
    }

    public void setRollOvered(boolean bl) {
        this.commentRollOvered = bl;
    }

    public void setEditing(boolean bl) {
        if (this.editing != bl) {
            this.editing = bl;
        }
    }

    public NodeComment copy() {
        return new NodeComment(this);
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.getText()).append((Object)this.getOffset()).append((Object)this.getState()).toHashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof NodeComment)) {
            return false;
        }
        NodeComment nodeComment = (NodeComment)object;
        return new EqualsBuilder().append((Object)this.getText(), (Object)nodeComment.getText()).append((Object)this.getOffset(), (Object)nodeComment.getOffset()).append((Object)this.getState(), (Object)nodeComment.getState()).isEquals();
    }

    private class CommentTextArea
    extends JTextArea
    implements DocumentListener,
    FocusListener {
        private UndoManager undoManager;

        public CommentTextArea() {
            this.setBackground(NodeComment.this.fillColor);
            this.setForeground(FONT_COLOR);
            this.setFont(Prefs.CODE_FONT_12);
            this.setBorder(new EmptyBorder(5, 5, 5, 5));
            this.getDocument().addDocumentListener(this);
            this.addFocusListener(this);
            this.undoManager = UIUtility.setTextComponentUndoable(this);
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D = (Graphics2D)graphics2D.create();
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            if (NodeComment.this.transparent) {
                graphics2D.setColor(this.getBackground());
                graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
            super.paintComponent(graphics);
            graphics2D.setColor(NodeComment.this.selected || NodeComment.this.editing ? SELECTED_DRAW_COLOR : NodeComment.this.drawColor);
            Dimension dimension = this.getPreferredSize();
            graphics2D.drawRect(0, 0, dimension.width - 1, dimension.height - 1);
            if (NodeComment.this.commentRollOvered) {
                int n = 15;
                int n2 = 3;
                Color color = graphics2D.getColor();
                Stroke stroke = graphics2D.getStroke();
                int n3 = dimension.width - n;
                graphics2D.setColor(CLOSE_FILL_COLOR);
                graphics2D.fillRect(n3, 0, n, n);
                graphics2D.setColor(NodeComment.this.selected || NodeComment.this.editing ? SELECTED_DRAW_COLOR : DRAW_COLOR);
                graphics2D.drawRect(n3, 0, n - 1, n);
                graphics2D.setColor(CLOSE_MARK_COLOR);
                graphics2D.setStroke(CLOSE_MARK_STROKE);
                graphics2D.drawLine(n3 + n2, n - n2, dimension.width - 1 - n2, n - n2);
                graphics2D.setColor(color);
                graphics2D.setStroke(stroke);
            }
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            if (dimension.width < 15) {
                dimension.width = 15;
            }
            return dimension;
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.updateSize();
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.updateSize();
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            this.updateSize();
        }

        private void updateSize() {
            Rectangle rectangle = this.getBounds();
            Font font = this.getFont();
            this.setFont(new Font(font.getFontName(), font.getStyle(), font.getSize()));
            Dimension dimension = this.getPreferredSize();
            this.setBounds(rectangle.x, rectangle.y, dimension.width, dimension.height);
            if (this.getParent() != null) {
                this.getParent().repaint();
            }
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            this.setCaretPosition(this.getText().length());
            if (this.getParent() != null) {
                this.getParent().remove(this);
            }
        }
    }
}

