/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.node;

import com.ef_prime.rflow.Rflow;
import com.ef_prime.rflow.core.app.base.Apps;
import com.ef_prime.rflow.core.app.r.base.R;
import com.ef_prime.rflow.core.app.r.base.RPackage;
import com.ef_prime.rflow.core.app.r.console.BasicCommand;
import com.ef_prime.rflow.core.app.r.console.Command;
import com.ef_prime.rflow.core.app.r.console.CommandUtility;
import com.ef_prime.rflow.core.common.keyvalue.ValueError;
import com.ef_prime.rflow.core.feature.search.SearchContext;
import com.ef_prime.rflow.core.feature.search.SearchResult;
import com.ef_prime.rflow.core.flow.ErrorLevel;
import com.ef_prime.rflow.core.flow.FlowError;
import com.ef_prime.rflow.core.flow.FlowNode;
import com.ef_prime.rflow.core.flow.FlowRunOption;
import com.ef_prime.rflow.core.task.Task;
import com.ef_prime.rflow.core.util.YamlEx;
import com.ef_prime.rflow.core.util.Yamlable;
import com.ef_prime.rflow.node.NodeModelEvent;
import com.ef_prime.rflow.node.NodeModelEventHandler;
import com.ef_prime.rflow.ui.app.r.script.RScriptUtility;
import com.ef_prime.rflow.ui.common.event.EventSupport;
import com.ef_prime.rflow.ui.common.item.ItemName;
import com.ef_prime.rflow.ui.flow.FlowViewer;
import com.ef_prime.rflow.ui.flow.rendering.FlowRenderer;
import com.ef_prime.rflow.ui.flow.rendering.NodeRenderInterface;
import com.ef_prime.rflow.ui.flow.rendering.NodeShape;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.swing.Icon;
import org.w3c.dom.Element;

public abstract class NodeModel
implements NodeRenderInterface,
Yamlable {
    public static final Comparator<Integer> ABS_COMPARATOR = new AbsoluteComparator();
    public static final Color TRANSPARENT = new Color(0, 0, 0, 0);
    public static final Color FILLPAINT = new Color(0, 120, 120);
    public static final Color PICKED_FILLPAINT = new Color(100, 200, 100);
    private static final Color DISABLED_PICKED = new Color(205, 205, 154);
    public static final Color PICKED_FILLPAINT_LIGHT = new Color(9881237);
    private static final Color HIGHLIGHTENED = new Color(130, 130, 168);
    private static final Color DISABLED_HIGHLIGHTENED = new Color(173, 173, 185);
    public static final Stroke DEFAULT_STROKE = new BasicStroke(1.0f);
    private Element savedElement;
    private String savedCommand;
    private List<RPackage> savedPackages;
    private NodeMode nodeMode = NodeMode.NORMAL;
    private boolean restorable;
    private boolean disabled;
    protected List<Integer> breakpoints = new ArrayList<Integer>(1);
    private List<ItemName> resultCache;
    private ItemName primaryResultCache;
    private EventSupport<NodeModelEvent, NodeModelEventHandler> eventSupport = new EventSupport();
    private NodeModelEvent event;
    protected boolean modelChanged;

    public NodeModel() {
        this.init();
    }

    protected NodeModel(NodeModel nodeModel) {
        this.savedCommand = nodeModel.savedCommand;
        this.nodeMode = nodeModel.nodeMode;
        this.restorable = nodeModel.restorable;
        this.disabled = nodeModel.disabled;
        this.breakpoints = new ArrayList<Integer>(nodeModel.breakpoints);
        this.savedPackages = nodeModel.savedPackages;
        this.init();
    }

    private void init() {
        this.event = new NodeModelEvent(this);
        this.addNodeModelEventHandler(new ModelEventHandler());
    }

    public void run(Task task) throws Exception {
        FlowRunOption flowRunOption = task.getOption();
        Command command = this.getCommandObject(flowRunOption, true);
        if (flowRunOption.isCheckError()) {
            command.setCheckError(true);
        }
        R.receiver().passCommand(command);
        this.waitForCommand(command);
        if (command.isError()) {
            throw new Exception();
        }
        List<ItemName> list = this.getResults();
        if (list != null) {
            for (ItemName itemName : list) {
                itemName.registerAsNewObject();
            }
        }
    }

    protected void waitForCommand(Command command) {
        while (!command.isDone()) {
            try {
                command.waitForCommand(50L);
            }
            catch (InterruptedException interruptedException) {
                if (R.console().isDebugWaitingForInput()) break;
                Rflow.getInstance().getConsole().stopIfBusy();
                break;
            }
        }
    }

    public Command getCommandObject(FlowRunOption flowRunOption, boolean bl) {
        boolean bl2;
        boolean bl3 = bl2 = !flowRunOption.isExcludeDebugScript();
        if (bl2 && !flowRunOption.dontSplitCommand()) {
            return CommandUtility.getLineSeparatedCommand(R.client(), this.getCommand(bl2, flowRunOption));
        }
        return new BasicCommand(this.getCommand(bl2, flowRunOption));
    }

    public final String getCommand() {
        return this.getCommand(false, null);
    }

    public String getCommand(boolean bl, FlowRunOption flowRunOption) {
        return this.isSavedCommandMode() ? this.savedCommand : this.getCommandImpl(bl, flowRunOption);
    }

    public abstract String getCommandImpl(boolean var1, FlowRunOption var2);

    public final String getCommandNoTab() {
        return RScriptUtility.tabToSpace(this.getCommand(), this.getTabSize());
    }

    protected int getTabSize() {
        return 5;
    }

    public ErrorLevel getErrorLevel() {
        return ErrorLevel.NONE;
    }

    public List<FlowError> getErrors() {
        ArrayList<FlowError> arrayList = new ArrayList<FlowError>(4);
        return arrayList;
    }

    public Element getSavedElement() {
        return this.savedElement;
    }

    public void setSavedElement(Element element) {
        this.savedElement = element;
    }

    public String getSavedCommand() {
        return this.savedCommand;
    }

    public void setSavedCommand(String string) {
        this.savedCommand = string;
    }

    public boolean isSavedCommandMode() {
        return this.nodeMode == NodeMode.UPDATE || this.nodeMode == NodeMode.PRESERVED;
    }

    public void setSavedPackageList(List<RPackage> list) {
        this.savedPackages = list;
    }

    public final List<RPackage> getSavedPackageList() {
        return this.savedPackages;
    }

    public List<RPackage> getAutoPackageList() {
        return Collections.emptyList();
    }

    public final List<RPackage> getRequiredPackageList() {
        if (this.isDisabled()) {
            return Collections.emptyList();
        }
        if (this.isSavedCommandMode()) {
            return this.savedPackages == null ? Collections.emptyList() : this.savedPackages;
        }
        return this.getAutoPackageList();
    }

    public NodeMode getNodeMode() {
        return this.nodeMode;
    }

    public void setNodeMode(NodeMode nodeMode) {
        if (this.nodeMode != nodeMode) {
            this.nodeMode = nodeMode;
            this.fireNodeModelEvent();
        }
    }

    public boolean isRestorable() {
        return this.restorable;
    }

    public void setRestorable(boolean bl) {
        this.restorable = bl;
    }

    public boolean isModelChangedAfterUpgrade() {
        return this.modelChanged;
    }

    public String getDefaultTitle() {
        return "";
    }

    @Override
    public String getFunctionForGroup() {
        return null;
    }

    @Override
    public Icon getIcon() {
        return null;
    }

    @Override
    public Icon getSmallIcon() {
        return this.getNodeShape().getSmallIcon();
    }

    @Override
    public Shape getShape() {
        return this.getNodeShape().getShape();
    }

    protected NodeShape getNodeShape() {
        return NodeShape.RECTANGLE;
    }

    @Override
    public Shape getGlassShape() {
        return NodeShape.getGlassShape();
    }

    @Override
    public Component getComponent(boolean bl, boolean bl2) {
        return null;
    }

    @Override
    public Paint getDrawPaint(boolean bl) {
        return TRANSPARENT;
    }

    @Override
    public Paint getFillPaint(boolean bl, boolean bl2) {
        if (bl2) {
            return this.isDisabled() ? DISABLED_HIGHLIGHTENED : HIGHLIGHTENED;
        }
        if (bl) {
            return this.isDisabled() ? DISABLED_PICKED : PICKED_FILLPAINT;
        }
        return this.isDisabled() ? Color.LIGHT_GRAY : FILLPAINT;
    }

    @Override
    public Stroke getStroke() {
        return DEFAULT_STROKE;
    }

    @Override
    public void paintOnRollOver(FlowRenderer flowRenderer, Graphics2D graphics2D, int n, int n2) {
    }

    public boolean canSetBreakpoint() {
        return true;
    }

    public boolean canSetInnerBreakpoint() {
        return false;
    }

    public List<Integer> getBreakpoints() {
        return this.breakpoints;
    }

    protected boolean isBreakpointEnabled() {
        if (this.getBreakpoints().isEmpty()) {
            return false;
        }
        return this.getBreakpoints().get(0) > 0;
    }

    public boolean isAnyEnabledBreakpoint() {
        if (this.breakpoints == null || this.breakpoints.isEmpty()) {
            return false;
        }
        for (Integer n : this.breakpoints) {
            if (n <= 0) continue;
            return true;
        }
        return false;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public void setDisabled(boolean bl) {
        if (this.disabled != bl) {
            this.disabled = bl;
            this.fireNodeModelEvent();
        }
    }

    public boolean canBeDisabled() {
        return true;
    }

    public boolean isEditable() {
        return false;
    }

    public void setCommand(String string) {
        if (!this.isEditable()) {
            throw new UnsupportedOperationException("cannot invoke this method if not editable");
        }
    }

    public boolean isConnectable() {
        return true;
    }

    public boolean isInsertionEnabled() {
        return true;
    }

    public boolean isModifiable() {
        return true;
    }

    public boolean isExecutable() {
        return true;
    }

    public boolean isSubflow() {
        return false;
    }

    public boolean isOpenSubflow() {
        return false;
    }

    public boolean isProperty() {
        return true;
    }

    public boolean hasCommand() {
        return true;
    }

    public boolean exportDefaultTitle() {
        return false;
    }

    public SearchResult[] search(SearchContext searchContext) {
        return null;
    }

    public boolean replace(SearchContext searchContext, String string, SearchResult[] searchResultArray, int n) {
        return false;
    }

    @Override
    public int getTitleLineCount() {
        return 2;
    }

    @Override
    public int getTitleWidth() {
        return 100;
    }

    @Override
    public Rectangle getTitleRectangle(Component component, Rectangle2D rectangle2D, int n, int n2) {
        return null;
    }

    @Override
    public Rectangle getBreakpointRectangle(int n, int n2) {
        int n3 = 10;
        return new Rectangle(n - n3 / 2, n2 - 26, n3, n3);
    }

    @Override
    public boolean mousePressed(FlowViewer flowViewer, FlowNode flowNode, Point point) {
        return flowNode.isFirstBreakpoint() && this.getBreakpointRectangle(0, 0).contains(point);
    }

    @Override
    public boolean mouseClicked(FlowViewer flowViewer, FlowNode flowNode, Point point) {
        return false;
    }

    @Override
    public boolean mouseEntered(FlowNode flowNode) {
        return false;
    }

    @Override
    public boolean mouseExited(FlowNode flowNode) {
        return false;
    }

    public List<ItemName> getResults() {
        if (this.resultCache == null) {
            this.resultCache = R.client().findNewVariables(Apps.R.getId(), this.getCommand());
        }
        return this.resultCache;
    }

    public ItemName getPrimaryResult() {
        if (this.primaryResultCache == null) {
            String string = CommandUtility.getLastCommand(this.getCommand());
            List<ItemName> list = R.client().findNewVariables(Apps.R.getId(), string);
            if (list.size() > 0) {
                this.primaryResultCache = list.get(list.size() - 1);
            }
        }
        return this.primaryResultCache;
    }

    public ValueError getValueError() {
        return null;
    }

    public abstract NodeModel copy();

    public NodeModel fullCopy() {
        return this.copy();
    }

    public int hashCode() {
        return this.getCommand().hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof NodeModel) {
            NodeModel nodeModel = (NodeModel)object;
            return Objects.equals(this.getCommand(), nodeModel.getCommand());
        }
        return false;
    }

    public String getTypeID() {
        return this.getClass().getCanonicalName();
    }

    @Override
    public Object toYamlValue(YamlEx yamlEx) {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put("script", this.getCommand());
        return linkedHashMap;
    }

    @Override
    public void loadYamlValue(YamlEx yamlEx, Object object) {
        Map map = (Map)YamlEx.typeCheck(Map.class, object);
        String string = (String)map.get("script");
        if (this.isEditable()) {
            this.setCommand(string);
        }
    }

    public void addNodeModelEventHandler(NodeModelEventHandler nodeModelEventHandler) {
        this.eventSupport.addEventHandler(nodeModelEventHandler);
    }

    public void removeNodeModelEventHandler(NodeModelEventHandler nodeModelEventHandler) {
        this.eventSupport.removeEventHandler(nodeModelEventHandler);
    }

    protected void fireNodeModelEvent() {
        this.eventSupport.dispatchEvent(this.event);
    }

    public static enum NodeMode {
        NORMAL,
        UPDATE,
        PRESERVED;

    }

    private class ModelEventHandler
    implements NodeModelEventHandler {
        private ModelEventHandler() {
        }

        @Override
        public void nodeModelChanged(NodeModelEvent nodeModelEvent) {
            NodeModel.this.resultCache = null;
            NodeModel.this.primaryResultCache = null;
        }
    }

    private static class AbsoluteComparator
    implements Comparator<Integer> {
        private AbsoluteComparator() {
        }

        @Override
        public int compare(Integer n, Integer n2) {
            int n3;
            int n4 = Math.abs(n);
            if (n4 < (n3 = Math.abs(n2))) {
                return -1;
            }
            if (n4 > n3) {
                return 1;
            }
            return 0;
        }
    }
}

