/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.node;

import com.ef_prime.rflow.core.common.util.ThreadUtility;
import com.ef_prime.rflow.core.flow.FlowNode;
import com.ef_prime.rflow.ui.flow.FlowNodeView;
import java.lang.reflect.InvocationTargetException;
import javax.swing.SwingUtilities;

public abstract class NodeOptionView
extends FlowNodeView {
    protected boolean lockModelChanged = false;
    private ModelChangedDispatcher changedDispatcher;

    public NodeOptionView(FlowNode flowNode, boolean bl) {
        super(flowNode, bl);
    }

    @Override
    public String getTitle() {
        return this.getNode().getTitle();
    }

    @Override
    public void unloadView() {
        super.unloadView();
        this.fireWaitingModelChanged();
        this.changedDispatcher = null;
    }

    @Override
    protected boolean isToolBar() {
        return true;
    }

    public void initFocus() {
    }

    protected void fireModelChanged() {
        if (this.lockModelChanged) {
            return;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            this.modelChanged();
            this.lockModelChanged = true;
            FlowNode.fireNodeModelChanged(this.getNode());
            this.lockModelChanged = false;
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    NodeOptionView.this.fireModelChanged();
                }
            });
        }
    }

    protected abstract void modelChanged();

    protected void fireWaitingModelChanged() {
        if (this.changedDispatcher != null && this.changedDispatcher.alive()) {
            this.changedDispatcher.dispatchNow();
        }
    }

    protected void fireWaitingModelChanged2() {
        if (this.changedDispatcher != null && this.changedDispatcher.alive()) {
            this.changedDispatcher.kill();
            if (SwingUtilities.isEventDispatchThread()) {
                this.fireModelChanged();
            } else {
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            NodeOptionView.this.fireModelChanged();
                        }
                    });
                }
                catch (InterruptedException interruptedException) {
                }
                catch (InvocationTargetException invocationTargetException) {
                    // empty catch block
                }
            }
        }
    }

    protected void requestModelChanged(boolean bl) {
        if (this.lockModelChanged) {
            return;
        }
        if (this.changedDispatcher == null || !this.changedDispatcher.alive()) {
            if (bl) {
                this.fireModelChanged();
            } else {
                this.changedDispatcher = new ModelChangedDispatcher();
                ThreadUtility.execute(this.changedDispatcher);
            }
        } else if (bl) {
            this.changedDispatcher.dispatchNow();
        } else {
            this.changedDispatcher.reset();
        }
    }

    private class ModelChangedDispatcher
    implements Runnable {
        private boolean alive = true;
        private boolean waitAgain = false;

        public synchronized void reset() {
            this.waitAgain = true;
            this.notifyAll();
        }

        public synchronized void dispatchNow() {
            this.waitAgain = false;
            this.notifyAll();
        }

        public synchronized void kill() {
            this.waitAgain = true;
            this.alive = false;
            this.notifyAll();
        }

        public synchronized boolean alive() {
            return this.alive;
        }

        @Override
        public void run() {
            while (this.alive) {
                this.doWait();
            }
        }

        private synchronized void doWait() {
            try {
                this.wait(700L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.waitAgain) {
                this.waitAgain = false;
            } else {
                this.alive = false;
                NodeOptionView.this.fireModelChanged();
            }
        }
    }
}

