/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.node;

import com.ef_prime.rflow.core.common.keyvalue.BoolKey;
import com.ef_prime.rflow.core.common.keyvalue.BoolKeyTest;
import com.ef_prime.rflow.core.common.keyvalue.Choice;
import com.ef_prime.rflow.core.common.keyvalue.ChoiceKey;
import com.ef_prime.rflow.core.common.keyvalue.Key;
import com.ef_prime.rflow.core.common.keyvalue.KeyLink;
import com.ef_prime.rflow.core.common.keyvalue.StrKey;
import com.ef_prime.rflow.core.common.keyvalue.ValueMap;
import com.ef_prime.rflow.node.group.AppearanceGroup;
import com.ef_prime.rflow.node.group.DefaultAppearanceGroup;
import com.ef_prime.rflow.resource.Messages;
import java.util.ArrayList;
import java.util.Objects;

public class NodeProperty
extends ValueMap {
    private static final String GROUP_DEFAULT = "default";
    public static final BoolKey DEFAULT_TITLE;
    public static final StrKey TITLE;
    public static final ChoiceKey GROUP;

    public NodeProperty() {
        this.registerKeys(DEFAULT_TITLE, TITLE, GROUP);
    }

    public static NodeProperty createDefaultProperty() {
        return new NodeProperty();
    }

    public String getTitle() {
        if (this.getValue(DEFAULT_TITLE).booleanValue()) {
            return null;
        }
        return this.getValue(TITLE);
    }

    public void setTitle(String string) {
        if (string == null) {
            this.putValue(DEFAULT_TITLE, Boolean.TRUE);
        } else {
            this.putValue(DEFAULT_TITLE, Boolean.FALSE);
            this.putValue(TITLE, string);
        }
    }

    public AppearanceGroup getAppearanceGroup() {
        String string = this.getValue(GROUP);
        if (GROUP_DEFAULT.equals(string)) {
            return null;
        }
        return DefaultAppearanceGroup.getGroup(string);
    }

    public void setAppearanceGroup(AppearanceGroup appearanceGroup) {
        DefaultAppearanceGroup defaultAppearanceGroup;
        String string = GROUP_DEFAULT;
        if (appearanceGroup != null && (defaultAppearanceGroup = DefaultAppearanceGroup.valueOf(appearanceGroup)) != null) {
            string = defaultAppearanceGroup.name();
        }
        this.putValue(GROUP, string);
    }

    @Override
    public NodeProperty copy() {
        return (NodeProperty)super.copy();
    }

    public boolean equals(Object object) {
        if (!(object instanceof NodeProperty)) {
            return false;
        }
        NodeProperty nodeProperty = (NodeProperty)object;
        return Objects.equals(this.getTitle(), nodeProperty.getTitle()) && Objects.equals(this.getAppearanceGroup(), nodeProperty.getAppearanceGroup());
    }

    static {
        DefaultAppearanceGroup[] defaultAppearanceGroupArray;
        DEFAULT_TITLE = ((BoolKey.Builder)BoolKey.builder("default_title", "").setDefaultValue(Boolean.TRUE)).build();
        TITLE = ((StrKey.Builder)((StrKey.Builder)StrKey.builder("title", "").addKeyLink(KeyLink.disabled(BoolKeyTest.ignoreEnabled(DEFAULT_TITLE, true)))).setLabelPosition("none")).build();
        ArrayList<Choice> arrayList = new ArrayList<Choice>();
        arrayList.add(new Choice(GROUP_DEFAULT, Messages.getString("NodePropertyPanel.default")));
        for (DefaultAppearanceGroup defaultAppearanceGroup : defaultAppearanceGroupArray = DefaultAppearanceGroup.values()) {
            arrayList.add(new Choice(defaultAppearanceGroup.name(), defaultAppearanceGroup.getAppearanceGroup().getTitle(), defaultAppearanceGroup.getAppearanceGroup().getSmallIcon()));
        }
        GROUP = ((ChoiceKey.Builder)((Key.Builder)ChoiceKey.builder("group", "").setChoices(arrayList)).setLabelPosition("none")).build();
    }
}

