/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.node;

import com.ef_prime.rflow.Rflow;
import com.ef_prime.rflow.core.app.r.base.RPackage;
import com.ef_prime.rflow.core.base.Settings;
import com.ef_prime.rflow.core.common.keyvalue.KeyWidgetNode;
import com.ef_prime.rflow.core.common.keyvalue.PanelWidgetNode;
import com.ef_prime.rflow.core.common.keyvalue.SeparatorWidgetNode;
import com.ef_prime.rflow.core.common.keyvalue.StrKey;
import com.ef_prime.rflow.core.common.keyvalue.ValueChangeEvent;
import com.ef_prime.rflow.core.common.keyvalue.ValueChangeEventHandler;
import com.ef_prime.rflow.core.common.keyvalue.ValueMap;
import com.ef_prime.rflow.core.common.keyvalue.ViewOptions;
import com.ef_prime.rflow.core.common.keyvalue.ViewWidgetNode;
import com.ef_prime.rflow.core.common.keyvalue.WidgetNode;
import com.ef_prime.rflow.core.flow.CacheData;
import com.ef_prime.rflow.core.flow.FlowNode;
import com.ef_prime.rflow.node.NodeModelChangeListener;
import com.ef_prime.rflow.node.NodeProperty;
import com.ef_prime.rflow.resource.Messages;
import com.ef_prime.rflow.ui.base.Icons;
import com.ef_prime.rflow.ui.common.keyvalue.StrKeyWidget;
import com.ef_prime.rflow.ui.common.keyvalue.Widget;
import com.ef_prime.rflow.ui.common.keyvalue.WidgetFactory;
import com.ef_prime.rflow.ui.common.view.LazyLoadView;
import com.ef_prime.rflow.ui.common.view.View;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.DateFormat;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.SpringLayout;
import javax.swing.border.EmptyBorder;
import net.miginfocom.layout.CC;
import net.miginfocom.layout.LC;
import net.miginfocom.swing.MigLayout;

public class NodePropertyView
extends LazyLoadView {
    private FlowNode node;
    private JLabel autoPackages = new JLabel("");

    public NodePropertyView(FlowNode flowNode) {
        this.setIcon(Icons.getIcon("16/cog.png"));
        this.setIconOnly(true);
        this.setTitle(Messages.getString("DefaultNodeModelController.property"));
        this.node = flowNode;
    }

    @Override
    protected void loadContent() {
        Widget widget = (Widget)WidgetFactory.getInstance().create(new CacheProperties(this.node.getCacheData()));
        widget.setBorder(new EmptyBorder(4, 0, 0, 0));
        FlowNode.addNodeModelChangeListener(new PackageUpdater());
        Rflow.settings().addEventHandler(new ValueChangeEventHandler(){

            @Override
            public void valueChanged(ValueChangeEvent valueChangeEvent) {
                if (Settings.AUTO_DETECT_PACKAGES.equals(valueChangeEvent.getKey())) {
                    NodePropertyView.this.updatePackages();
                }
            }
        });
        this.updatePackages();
        Component component = WidgetFactory.getInstance().create(this.node.getProperty(), new PanelWidgetNode().add(new SeparatorWidgetNode(Messages.getString("NodePropertyPanel.title"))).add(new ViewWidgetNode(TitleView.class)).add(new SeparatorWidgetNode(Messages.getString("View.RequiredPackagesView.required_packages"))));
        SpringLayout springLayout = new SpringLayout();
        JPanel jPanel = new JPanel(springLayout);
        springLayout.putConstraint("North", component, 0, "North", (Component)jPanel);
        springLayout.putConstraint("East", component, 0, "East", (Component)jPanel);
        springLayout.putConstraint("West", component, 0, "West", (Component)jPanel);
        springLayout.putConstraint("North", (Component)this.autoPackages, 0, "South", component);
        springLayout.putConstraint("East", (Component)this.autoPackages, 0, "East", (Component)jPanel);
        springLayout.putConstraint("West", (Component)this.autoPackages, 0, "West", (Component)jPanel);
        springLayout.putConstraint("North", (Component)widget, 0, "South", (Component)this.autoPackages);
        springLayout.putConstraint("East", (Component)widget, 0, "East", (Component)jPanel);
        springLayout.putConstraint("West", (Component)widget, 0, "West", (Component)jPanel);
        jPanel.add(component);
        jPanel.add(this.autoPackages);
        jPanel.add(widget);
        JScrollPane jScrollPane = new JScrollPane(jPanel, 20, 31);
        jScrollPane.setBorder(null);
        this.add(jScrollPane);
    }

    private void updatePackages() {
        this.autoPackages.setText(RPackage.packageListToString(this.node.getModel().getRequiredPackageList()));
    }

    private static class CacheProperties
    extends ValueMap {
        private static final StrKey NAME = ((StrKey.Builder)StrKey.builder("name", Messages.getString("NodePropertyPanel.file")).setFixed(true)).build();
        private static final StrKey PATH = ((StrKey.Builder)StrKey.builder("path", Messages.getString("NodePropertyPanel.address")).setFixed(true)).build();
        private static final StrKey CREATED = ((StrKey.Builder)StrKey.builder("last_modified", Messages.getString("NodePropertyPanel.created_datetime")).setFixed(true)).build();

        public CacheProperties(CacheData cacheData) {
            this.registerKeys(NAME, PATH, CREATED);
            if (cacheData != null && cacheData.isValid()) {
                this.putValue(NAME, cacheData.getFile().getName());
                this.putValue(PATH, cacheData.getFile().getPath());
                this.putValue(CREATED, DateFormat.getDateTimeInstance().format(cacheData.getDate().getTime()));
            }
        }

        @Override
        public WidgetNode getWidgetNode(ViewOptions viewOptions) {
            return new PanelWidgetNode().add(new SeparatorWidgetNode(Messages.getString("NodePropertyPanel.cache"))).addKeys(NAME, PATH, CREATED);
        }
    }

    private class PackageUpdater
    implements NodeModelChangeListener {
        private PackageUpdater() {
        }

        @Override
        public void nodeModelChanged(FlowNode flowNode) {
            if (flowNode == NodePropertyView.this.node) {
                NodePropertyView.this.updatePackages();
            }
        }

        @Override
        public void subflowNodeModelChanged(FlowNode flowNode) {
            if (flowNode == NodePropertyView.this.node) {
                NodePropertyView.this.updatePackages();
            }
        }
    }

    public static class TitleView
    extends View
    implements ItemListener,
    MouseListener,
    ValueChangeEventHandler {
        private NodeProperty property;
        private JRadioButton def;
        private JRadioButton custom;
        private StrKeyWidget titleWidget;

        public TitleView(ValueMap valueMap, WidgetNode widgetNode) {
            this.property = (NodeProperty)valueMap;
            Boolean bl = this.property.getValue(NodeProperty.DEFAULT_TITLE);
            this.def = new JRadioButton(Messages.getString("NodePropertyPanel.default_title"), (boolean)bl);
            this.custom = new JRadioButton("", bl == false);
            this.custom.addItemListener(this);
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(this.def);
            buttonGroup.add(this.custom);
            this.titleWidget = (StrKeyWidget)WidgetFactory.getInstance().create(valueMap, new KeyWidgetNode(NodeProperty.TITLE));
            this.titleWidget.getInput().addMouseListener(this);
            this.setLayout((LayoutManager)new MigLayout(new LC().insetsAll("0").fill().gridGapY("0")));
            this.add((Component)this.def, new CC().wrap());
            this.add((Component)this.custom, new CC().split(2).gapRight("0"));
            this.add((Component)this.titleWidget, new CC().minWidth(Integer.toString(NodeProperty.TITLE.getMinWidth())));
        }

        @Override
        protected void viewDidBecomeDisplayable() {
            super.viewDidBecomeDisplayable();
            this.property.addEventHandler(this);
        }

        @Override
        protected void viewDidBecomeUndisplayable() {
            super.viewDidBecomeUndisplayable();
            this.property.removeEventHandler(this);
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            this.property.putValue(NodeProperty.DEFAULT_TITLE, !this.custom.isSelected());
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (!this.custom.isSelected()) {
                this.custom.setSelected(true);
                this.titleWidget.startEditing();
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        @Override
        public void valueChanged(ValueChangeEvent valueChangeEvent) {
            if (valueChangeEvent.getKey() == NodeProperty.DEFAULT_TITLE) {
                Boolean bl = (Boolean)valueChangeEvent.getValue();
                if (bl.booleanValue()) {
                    this.def.setSelected(true);
                } else {
                    this.custom.setSelected(true);
                }
            }
        }
    }
}

