/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.node;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.builder.EqualsBuilder;

public class PreviewOption {
    public static final PreviewOption OFF = new PreviewOption();
    private boolean enabled;
    private long number;
    private Map<Object, Object> properties;

    public PreviewOption() {
        this.enabled = false;
    }

    public PreviewOption(long l) {
        this.enabled = true;
        this.number = Math.max(0L, l);
    }

    private PreviewOption(PreviewOption previewOption) {
        this.enabled = previewOption.enabled;
        this.number = previewOption.number;
        if (previewOption.properties != null) {
            this.properties = new HashMap<Object, Object>(previewOption.properties);
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean useAllRows() {
        return this.number == 0L;
    }

    public long getNumber() {
        return this.number;
    }

    public String getNumberString() {
        return Long.toString(this.number);
    }

    public void setProperty(Object object, Object object2) {
        if (this.properties == null) {
            this.properties = new HashMap<Object, Object>(2);
        }
        this.properties.put(object, object2);
    }

    public Object getProperty(Object object) {
        if (this.properties == null) {
            return null;
        }
        return this.properties.get(object);
    }

    public PreviewOption setNumber(long l) {
        PreviewOption previewOption = new PreviewOption(this);
        previewOption.number = l;
        return previewOption;
    }

    public int hashCode() {
        return Objects.hash(this.enabled, this.number);
    }

    public boolean equals(Object object) {
        if (!(object instanceof PreviewOption)) {
            return false;
        }
        PreviewOption previewOption = (PreviewOption)object;
        return new EqualsBuilder().append(this.enabled, previewOption.enabled).append(this.number, previewOption.number).build();
    }
}

