/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.node;

import com.ef_prime.rflow.core.app.r.base.RPackage;
import com.ef_prime.rflow.core.common.keyvalue.PanelWidgetNode;
import com.ef_prime.rflow.core.common.keyvalue.SeparatorWidgetNode;
import com.ef_prime.rflow.core.common.keyvalue.ValueChangeEvent;
import com.ef_prime.rflow.core.common.keyvalue.ValueChangeEventHandler;
import com.ef_prime.rflow.core.common.keyvalue.ValueMap;
import com.ef_prime.rflow.core.flow.FlowNode;
import com.ef_prime.rflow.node.NodeModelChangeListener;
import com.ef_prime.rflow.resource.Messages;
import com.ef_prime.rflow.ui.base.Icons;
import com.ef_prime.rflow.ui.common.keyvalue.WidgetFactory;
import com.ef_prime.rflow.ui.common.view.LazyLoadView;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SpringLayout;

public class RequiredPackageView
extends LazyLoadView
implements ValueChangeEventHandler,
NodeModelChangeListener {
    private FlowNode node;
    private JLabel detectedPackages;

    public RequiredPackageView(FlowNode flowNode) {
        this.setIcon(Icons.getIcon("16/package.png"));
        this.setIconOnly(true);
        this.setIconToolTip(Messages.getString("View.FlowProperties.r_package"));
        this.node = flowNode;
        this.detectedPackages = new JLabel(RPackage.packageListToString(RPackage.getDetectedPackages(flowNode)));
    }

    @Override
    protected void loadContent() {
        Component component = null;
        FlowNode.addNodeModelChangeListener(this);
        component = WidgetFactory.getInstance().create(new ValueMap(), new PanelWidgetNode().add(new SeparatorWidgetNode(Messages.getString("View.RequiredPackagesView.required_packages"))));
        SpringLayout springLayout = new SpringLayout();
        JPanel jPanel = new JPanel(springLayout);
        springLayout.putConstraint("North", component, 0, "North", (Component)jPanel);
        springLayout.putConstraint("East", component, 0, "East", (Component)jPanel);
        springLayout.putConstraint("West", component, 0, "West", (Component)jPanel);
        springLayout.putConstraint("North", (Component)this.detectedPackages, 0, "South", component);
        springLayout.putConstraint("East", (Component)this.detectedPackages, 0, "East", (Component)jPanel);
        springLayout.putConstraint("West", (Component)this.detectedPackages, 0, "West", (Component)jPanel);
        jPanel.add(component);
        jPanel.add(this.detectedPackages);
        JScrollPane jScrollPane = new JScrollPane(jPanel, 20, 31);
        jScrollPane.setBorder(null);
        this.add(jScrollPane);
    }

    @Override
    public void valueChanged(ValueChangeEvent valueChangeEvent) {
        FlowNode.fireNodeModelChanged(this.node);
        FlowNode.fireSubflowNodeModelChanged(this.node);
    }

    @Override
    public void nodeModelChanged(FlowNode flowNode) {
        if (flowNode.equals(this.node)) {
            this.detectedPackages.setText(RPackage.packageListToString(RPackage.getDetectedPackages(this.node)));
        }
    }

    @Override
    public void subflowNodeModelChanged(FlowNode flowNode) {
        this.nodeModelChanged(flowNode);
    }
}

