/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.node;

import com.ef_prime.rflow.core.app.r.base.RPackage;
import com.ef_prime.rflow.core.app.r.keyvalue.RChoiceKey;
import com.ef_prime.rflow.core.app.r.keyvalue.RTableKey;
import com.ef_prime.rflow.core.common.keyvalue.BoolKey;
import com.ef_prime.rflow.core.common.keyvalue.Key;
import com.ef_prime.rflow.core.common.keyvalue.ValueMap;
import com.ef_prime.rflow.core.common.table.GeneralTableModel;
import com.ef_prime.rflow.core.common.table.KeysTableRow;
import com.ef_prime.rflow.resource.Messages;
import com.ef_prime.rflow.ui.app.r.RChoiceProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;

public class UserPackages
extends ValueMap {
    private static final RChoiceKey NAME = ((RChoiceKey.Builder)RChoiceKey.builder("package_column", Messages.getString("View.RequiredPackagesView.package_name")).setCompletionSupport(RChoiceProvider.packages())).build();
    private static final BoolKey ATTACH = ((BoolKey.Builder)BoolKey.builder("package_attach", Messages.getString("View.RequiredPackagesView.attach")).setDefaultValue(false)).build();
    public static final RTableKey TABLE = ((RTableKey.Builder)((RTableKey.Builder)((RTableKey.Builder)RTableKey.builder("user_package_list", "packages", NAME, ATTACH).setUiControls(GeneralTableModel.UI_DEFAULT)).setRowPredicate(UserPackages.getPackageNameRowPredicate())).setLabelPosition("none")).build();

    public UserPackages() {
        this.registerKeys(TABLE);
    }

    public List<RPackage> getRPackageList() {
        List<String> list = this.getValue(TABLE).getValidValues(NAME);
        List<Boolean> list2 = this.getValue(TABLE).getValidValues(ATTACH);
        ArrayList<RPackage> arrayList = new ArrayList<RPackage>();
        for (int i = 0; i < list.size(); ++i) {
            String string = list.get(i);
            boolean bl = list2.get(i);
            if (string.trim().isEmpty()) continue;
            arrayList.add(new RPackage(string, true, bl));
        }
        return arrayList;
    }

    public void setRPackageList(List<RPackage> list) {
        this.getValue(TABLE).removeAllRows();
        int n = 0;
        for (RPackage rPackage : list) {
            this.getValue(TABLE).insertNewRow(n++, rPackage.getName(), rPackage.isAttach());
        }
    }

    @Override
    public UserPackages copy() {
        return (UserPackages)super.copy();
    }

    private static final Predicate<KeysTableRow> getPackageNameRowPredicate() {
        return new Predicate<KeysTableRow>(){

            @Override
            public boolean test(KeysTableRow keysTableRow) {
                Key<?> key = keysTableRow.getColumnKey(0);
                return !key.isValueEmpty(keysTableRow.getValue(0));
            }
        };
    }
}

