/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.node.base;

import com.ef_prime.rflow.core.app.r.base.ArgEntry;
import com.ef_prime.rflow.core.app.r.base.ArgList;
import com.ef_prime.rflow.core.app.r.base.R;
import com.ef_prime.rflow.core.app.r.base.RObjectNameSet;
import com.ef_prime.rflow.core.app.r.base.RUtility;
import com.ef_prime.rflow.core.base.WorkingDirectory;
import com.ef_prime.rflow.resource.Messages;
import com.ef_prime.rflow.ui.common.component.RflowTextField;
import com.ef_prime.rflow.ui.common.component.SupportControl;
import com.ef_prime.rflow.ui.util.FontSupport;
import com.ef_prime.rflow.ui.util.PlatformUtility;
import com.ef_prime.rflow.ui.util.UIUtility;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.HashSet;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.DefaultCellEditor;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.text.JTextComponent;

public class ArgsTable
extends JTable
implements FocusListener {
    private String function;
    private Actions actions = new Actions();

    public ArgsTable() {
        this.setModel(new ArgsTableModel());
        this.setDefaultRenderer(String.class, new ArgsTableRenderer());
        this.setDefaultEditor(String.class, new ArgsTableCellEditor(new RflowTextField()));
        FontSupport.setCodeFont(this);
        this.setCellSelectionEnabled(true);
        this.setRowHeight(new ArgsTableRenderer().getPreferredSize().height);
        this.addKeyListener(new KeyHandler());
        this.addMouseListener(new MouseHandler());
        this.setSurrendersFocusOnKeystroke(true);
    }

    public TableCellEditor getTableCellEditor() {
        return this.getDefaultEditor(String.class);
    }

    public void setArgsList(ArgList argList) {
        ((ArgsTableModel)this.getModel()).setEntrys(argList);
    }

    public ArgList getArgsList() {
        return (ArgList)((ArgsTableModel)this.getModel()).entrys.clone();
    }

    public void setDefaultMap(ArgList argList) {
        ArgsTableModel argsTableModel = (ArgsTableModel)this.getModel();
        argsTableModel.entrys.setDefaultList(argList);
    }

    public void clearDefaultArgs() {
        ArgsTableModel argsTableModel = (ArgsTableModel)this.getModel();
        for (int i = argsTableModel.getRowCount() - 1; i >= 0; --i) {
            if (!argsTableModel.isRowDefaultValue(i)) continue;
            argsTableModel.removeRow(i);
        }
    }

    public ArgsTableModel getArgsModel() {
        return (ArgsTableModel)this.getModel();
    }

    public ArgList getDefaultList() {
        ArgsTableModel argsTableModel = (ArgsTableModel)this.getModel();
        return (ArgList)argsTableModel.entrys.getDefaultList().clone();
    }

    public void addRow(ArgEntry argEntry) {
        ArgsTableModel argsTableModel = (ArgsTableModel)this.getModel();
        argsTableModel.addRow(argEntry);
    }

    public void setFunction(String string) {
        this.function = string;
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        ((Component)((Object)this.getTableHeader().getDefaultRenderer())).setEnabled(bl);
        ((Component)((Object)this.getDefaultRenderer(String.class))).setEnabled(bl);
    }

    private JPopupMenu createPopup(int n, int n2) {
        this.actions.row = n;
        this.actions.col = n2;
        if (n < 0 || n2 < 0) {
            return null;
        }
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add(this.actions.get("insert"));
        jPopupMenu.add(this.actions.get("remove"));
        if (n2 == 1) {
            jPopupMenu.add(this.actions.get("choose_file"));
        }
        return jPopupMenu;
    }

    @Override
    public Component prepareEditor(TableCellEditor tableCellEditor, int n, int n2) {
        Component component = super.prepareEditor(tableCellEditor, n, n2);
        if (component != null) {
            component.addFocusListener(this);
        }
        return component;
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        Object object;
        if (this.isEditing() && (object = this.getCellEditor()) != null) {
            object.stopCellEditing();
        }
        object = focusEvent.getComponent();
        ((Component)object).removeFocusListener(this);
    }

    private class Actions
    extends ActionMap {
        int row = -1;
        int col = -1;

        public Actions() {
            this.put("insert", new Insert());
            this.put("remove", new Remove());
            this.put("choose_file", new ChooseFile());
        }

        private class Insert
        extends AbstractAction {
            public Insert() {
                this.putValue("Name", Messages.getString("Action.insert"));
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ArgsTable.this.getArgsModel().insertRow(Actions.this.row, new ArgEntry("", ""));
                ArgsTable.this.clearSelection();
                ArgsTable.this.addRowSelectionInterval(Actions.this.row, Actions.this.row);
            }
        }

        private class Remove
        extends AbstractAction {
            public Remove() {
                this.putValue("Name", Messages.getString("Action.remove"));
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int[] nArray = ArgsTable.this.getSelectedRows();
                ArgsTable.this.clearSelection();
                for (int i = nArray.length - 1; i >= 0; --i) {
                    ArgsTable.this.getArgsModel().removeRow(nArray[i]);
                }
            }
        }

        private class ChooseFile
        extends AbstractAction {
            public ChooseFile() {
                this.putValue("Name", Messages.getString("ArgsTable.choose_file"));
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                File file = UIUtility.chooseOpenFile(Messages.getString("ArgsTable.choose_file"), WorkingDirectory.getWorkingDirectory(), new FileFilter[0], ArgsTable.this);
                if (file == null) {
                    return;
                }
                File file2 = WorkingDirectory.toAbstractPath(file);
                ArgsTable.this.setValueAt(RUtility.quotedPath(file2.getPath()), Actions.this.row, Actions.this.col);
                ArgsTable.this.editCellAt(Actions.this.row, Actions.this.col);
                ArgsTable.this.getCellEditor(Actions.this.row, Actions.this.col).stopCellEditing();
            }
        }
    }

    private class ArgsTableModel
    extends AbstractTableModel
    implements TableModelListener {
        static final int COLUMN_PARAM = 0;
        static final int COLUMN_VALUE = 1;
        private final String[] colNames = new String[]{Messages.getString("ArgsTable.parameter"), Messages.getString("ArgsTable.value")};
        private ArgList entrys;

        public ArgsTableModel() {
            this(new ArgList());
        }

        public ArgsTableModel(ArgList argList) {
            this.entrys = argList;
            this.addTableModelListener(this);
        }

        public void setEntrys(ArgList argList) {
            this.entrys = argList;
            this.fireTableDataChanged();
        }

        public void addRow(ArgEntry argEntry) {
            this.entrys.add(argEntry);
            this.fireTableRowsInserted(this.entrys.size() - 1, this.entrys.size() - 1);
        }

        public void insertRow(int n, ArgEntry argEntry) {
            this.entrys.insertElementAt(argEntry, n);
            this.fireTableRowsInserted(n, n);
        }

        public boolean isRowDefaultValue(int n) {
            if (n < 0 || n > this.entrys.size() - 1) {
                return false;
            }
            return this.entrys.isDefaultValue(n);
        }

        @Override
        public String getColumnName(int n) {
            return this.colNames[n];
        }

        @Override
        public Class<?> getColumnClass(int n) {
            return String.class;
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return true;
        }

        @Override
        public int getColumnCount() {
            return this.colNames.length;
        }

        @Override
        public int getRowCount() {
            return this.entrys.size() + 1;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (this.entrys.size() <= n) {
                return null;
            }
            switch (n2) {
                case 0: {
                    return ((ArgEntry)this.entrys.get(n)).getParam();
                }
                case 1: {
                    return ((ArgEntry)this.entrys.get(n)).getValue();
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (this.entrys.size() <= n) {
                this.entrys.add(new ArgEntry("", ""));
                this.fireTableRowsInserted(this.entrys.size() - 1, this.entrys.size() - 1);
            }
            ArgEntry argEntry = (ArgEntry)this.entrys.get(n);
            switch (n2) {
                case 0: {
                    this.entrys.set(n, new ArgEntry(object.toString(), argEntry.getValue()));
                    break;
                }
                case 1: {
                    this.entrys.set(n, new ArgEntry(argEntry.getParam(), object.toString()));
                }
            }
            this.fireTableCellUpdated(n, n2);
        }

        public void removeRow(int n) {
            if (this.entrys.size() <= n) {
                return;
            }
            this.entrys.remove(n);
            this.fireTableRowsDeleted(n, n);
        }

        @Override
        public void tableChanged(TableModelEvent tableModelEvent) {
            switch (tableModelEvent.getType()) {
                case 0: 
                case 1: {
                    if (this.entrys.size() < 1) {
                        return;
                    }
                    HashSet<Integer> hashSet = new HashSet<Integer>();
                    int n = tableModelEvent.getLastRow() > this.entrys.size() - 1 ? this.entrys.size() - 1 : tableModelEvent.getLastRow();
                    for (int i = tableModelEvent.getFirstRow(); i <= n; ++i) {
                        ArgEntry object = (ArgEntry)this.entrys.get(i);
                        boolean bl = this.isRowDefaultValue(i);
                        for (int j = 0; j < this.entrys.size() - 1; ++j) {
                            if (i == j) continue;
                            ArgEntry argEntry = (ArgEntry)this.entrys.get(j);
                            if (object.getParam() == null || !object.getParam().equals(argEntry.getParam()) || bl == this.isRowDefaultValue(j)) continue;
                            hashSet.add(bl ? i : j);
                        }
                    }
                    for (Integer n2 : hashSet) {
                        this.removeRow(n2);
                    }
                    ArgsTable.this.repaint();
                }
            }
        }
    }

    private static class ArgsTableRenderer
    extends DefaultTableCellRenderer {
        public ArgsTableRenderer() {
            FontSupport.setCodeFont(this);
            this.setText(" ");
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            ArgsTable argsTable = (ArgsTable)jTable;
            ArgsTableModel argsTableModel = (ArgsTableModel)argsTable.getModel();
            if (argsTableModel.isRowDefaultValue(n)) {
                this.setForeground(Color.LIGHT_GRAY);
            } else {
                this.setForeground(Color.BLACK);
            }
            return this;
        }
    }

    private class ArgsTableCellEditor
    extends DefaultCellEditor {
        public boolean isValue;

        public ArgsTableCellEditor(JTextField jTextField) {
            super(jTextField);
            final SupportControl supportControl = new SupportControl(jTextField){

                @Override
                protected String[] getSupportWords(String string, int n) {
                    if (ArgsTableCellEditor.this.isValue) {
                        RObjectNameSet rObjectNameSet = R.client().supportList(string);
                        if (rObjectNameSet == null) {
                            return null;
                        }
                        rObjectNameSet.sort();
                        return rObjectNameSet.getNames();
                    }
                    if (ArgsTable.this.function == null) {
                        return null;
                    }
                    ArgList argList = R.client().argListChar(ArgsTable.this.function);
                    if (argList == null) {
                        return null;
                    }
                    return argList.paramSet().toArray(new String[0]);
                }

                @Override
                public void itemAccepted(JTextComponent jTextComponent, String string) {
                    if (ArgsTableCellEditor.this.isValue) {
                        super.itemAccepted(jTextComponent, string);
                    } else {
                        jTextComponent.setText(string);
                    }
                }
            };
            this.addCellEditorListener(new CellEditorListener(){

                @Override
                public void editingCanceled(ChangeEvent changeEvent) {
                    supportControl.removeSupportPopup();
                }

                @Override
                public void editingStopped(ChangeEvent changeEvent) {
                    supportControl.removeSupportPopup();
                }
            });
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            JComponent jComponent = (JComponent)this.getComponent();
            jComponent.setBorder(new LineBorder(Color.BLACK));
            FontSupport.setCodeFont(jComponent);
            this.isValue = n2 == 1;
            return super.getTableCellEditorComponent(jTable, object, bl, n, n2);
        }
    }

    private static class KeyHandler
    extends KeyAdapter {
        private KeyHandler() {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            ArgsTable argsTable = (ArgsTable)keyEvent.getSource();
            ArgsTableModel argsTableModel = (ArgsTableModel)argsTable.getModel();
            if (keyEvent.getKeyCode() == PlatformUtility.getDeleteVirtualKeyCode()) {
                int[] nArray = argsTable.getSelectedRows();
                argsTable.clearSelection();
                for (int i = nArray.length - 1; i >= 0; --i) {
                    argsTableModel.removeRow(nArray[i]);
                }
                keyEvent.consume();
            }
        }
    }

    private class MouseHandler
    extends MouseAdapter {
        private MouseHandler() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            ArgsTable argsTable = (ArgsTable)mouseEvent.getSource();
            if (UIUtility.isRightMouseButton(mouseEvent)) {
                int n = argsTable.columnAtPoint(mouseEvent.getPoint());
                int n2 = argsTable.rowAtPoint(mouseEvent.getPoint());
                JPopupMenu jPopupMenu = ArgsTable.this.createPopup(n2, n);
                if (jPopupMenu != null) {
                    jPopupMenu.show(argsTable, mouseEvent.getPoint().x, mouseEvent.getPoint().y);
                }
            }
        }
    }

    private static class ActionKey {
        static final String INSERT = "insert";
        static final String REMOVE = "remove";
        static final String CHOOSE_FILE = "choose_file";

        private ActionKey() {
        }
    }
}

