/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.node.base;

import com.ef_prime.rflow.core.common.keyvalue.Key;
import com.ef_prime.rflow.core.common.keyvalue.ValueChangeEvent;
import com.ef_prime.rflow.core.common.keyvalue.ValueChangeEventHandler;
import com.ef_prime.rflow.core.common.keyvalue.ValueMap;
import com.ef_prime.rflow.core.feature.search.KeySearchResult;
import com.ef_prime.rflow.core.feature.search.SearchContext;
import com.ef_prime.rflow.core.feature.search.SearchResult;
import com.ef_prime.rflow.core.feature.search.SearchUtility;
import com.ef_prime.rflow.core.feature.search.TextSearchResult;
import com.ef_prime.rflow.core.flow.FlowRunOption;
import com.ef_prime.rflow.core.flow.ViewLayout;
import com.ef_prime.rflow.node.base.SubflowNodeModel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class ClosedSubflowNodeModel
extends SubflowNodeModel
implements ValueChangeEventHandler {
    public ClosedSubflowNodeModel() {
    }

    public ClosedSubflowNodeModel(int n) {
        super(n);
    }

    public ClosedSubflowNodeModel(SubflowNodeModel subflowNodeModel, boolean bl) {
        super(subflowNodeModel, bl);
    }

    public ClosedSubflowNodeModel(ViewLayout viewLayout) {
        super(viewLayout);
    }

    public ClosedSubflowNodeModel(ViewLayout[] viewLayoutArray) {
        super(viewLayoutArray);
    }

    protected abstract ValueMap getValueMap();

    @Override
    public boolean isOpenSubflow() {
        return false;
    }

    @Override
    public SearchResult[] search(SearchContext searchContext) {
        if (searchContext.isScriptSearch()) {
            FlowRunOption flowRunOption = new FlowRunOption().setInsertNewLine(true);
            List<TextSearchResult> list = SearchUtility.searchRScript(searchContext, this.getCommand(false, flowRunOption));
            if (list.isEmpty()) {
                return null;
            }
            for (TextSearchResult textSearchResult : list) {
                textSearchResult.setCanReplace(false);
            }
            return list.toArray(new SearchResult[list.size()]);
        }
        ArrayList<SearchResult> arrayList = new ArrayList<SearchResult>();
        ValueMap valueMap = this.getValueMap();
        Iterator<Key<?>> iterator = valueMap.keyIterator();
        while (iterator.hasNext()) {
            Key<?> key = iterator.next();
            key.search(arrayList, searchContext, valueMap.getValue(key), valueMap);
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        return arrayList.toArray(new SearchResult[arrayList.size()]);
    }

    @Override
    public boolean replace(SearchContext searchContext, String string, SearchResult[] searchResultArray, int n) {
        SearchResult searchResult = searchResultArray[n];
        if (!(searchResult instanceof KeySearchResult)) {
            return false;
        }
        KeySearchResult keySearchResult = (KeySearchResult)searchResult;
        ArrayList<SearchResult> arrayList = new ArrayList<SearchResult>();
        for (SearchResult searchResult2 : searchResultArray) {
            KeySearchResult keySearchResult2;
            if (!(searchResult2 instanceof KeySearchResult) || !(keySearchResult2 = (KeySearchResult)searchResult2).getKey().equals(keySearchResult.getKey())) continue;
            arrayList.add(keySearchResult2.getResult());
        }
        return keySearchResult.getKey().replace(searchContext, string, keySearchResult.getResult(), arrayList, this.getValueMap().getValue(keySearchResult.getKey()), this.getValueMap());
    }

    @Override
    public void valueChanged(ValueChangeEvent valueChangeEvent) {
        this.fireNodeModelEvent();
    }
}

