/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.node.base;

import com.ef_prime.rflow.core.common.keyvalue.ValueChangeEvent;
import com.ef_prime.rflow.core.common.keyvalue.ValueChangeEventHandler;
import com.ef_prime.rflow.core.common.keyvalue.ValueMap;
import com.ef_prime.rflow.core.feature.search.KeySearchResult;
import com.ef_prime.rflow.core.feature.search.SearchResult;
import com.ef_prime.rflow.core.feature.search.TextSearchResult;
import com.ef_prime.rflow.core.flow.FlowNode;
import com.ef_prime.rflow.node.RequestNodeModelNotifyEvent;
import com.ef_prime.rflow.node.base.ClosedSubflowNodeModel;
import com.ef_prime.rflow.node.base.SubflowNodeView;
import com.ef_prime.rflow.ui.common.event.EventManager;
import com.ef_prime.rflow.ui.common.event.SimpleEvent;
import com.ef_prime.rflow.ui.common.event.SimpleEventHandler;
import com.ef_prime.rflow.ui.common.keyvalue.Widget;
import java.awt.Component;
import javax.swing.JTabbedPane;

public class ClosedSubflowNodeView
extends SubflowNodeView
implements ValueChangeEventHandler,
SimpleEventHandler {
    private Widget widget;

    public ClosedSubflowNodeView(FlowNode flowNode, boolean bl) {
        super(flowNode, bl);
    }

    protected void setWidget(Widget widget) {
        this.widget = widget;
    }

    protected Widget getWidget() {
        return this.widget;
    }

    @Override
    public void select(SearchResult searchResult) {
        if (searchResult instanceof KeySearchResult && this.widget != null) {
            Component component = this.getCenterTabbedPane();
            if (component instanceof JTabbedPane) {
                ((JTabbedPane)component).setSelectedIndex(0);
            }
            this.widget.clearSelection();
            this.widget.select(searchResult);
        } else if (searchResult instanceof TextSearchResult && this.getScriptView() != null) {
            this.getScriptView().toFront();
            this.getScriptView().select(searchResult);
        }
    }

    @Override
    public void loadView() {
        super.loadView();
        this.getValueMap().addEventHandler(this);
        EventManager.getInstance().registerEventHandler(RequestNodeModelNotifyEvent.class, this);
    }

    @Override
    public void unloadView() {
        super.unloadView();
        if (this.widget != null) {
            this.widget.updateImmediately();
        }
        this.getValueMap().removeEventHandler(this);
        EventManager.getInstance().removeEventHandler(RequestNodeModelNotifyEvent.class, this);
    }

    private ValueMap getValueMap() {
        return ((ClosedSubflowNodeModel)this.getNode().getModel()).getValueMap();
    }

    @Override
    public void valueChanged(ValueChangeEvent valueChangeEvent) {
        FlowNode.fireSubflowNodeModelChanged(this.getNode());
    }

    @Override
    public void onEvent(SimpleEvent simpleEvent) {
        if (simpleEvent.getClass().equals(RequestNodeModelNotifyEvent.class) && this.widget != null) {
            this.widget.updateImmediately();
        }
    }
}

