/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.node.base;

import com.ef_prime.rflow.core.flow.FlowNode;
import com.ef_prime.rflow.core.flow.FlowRunOption;
import com.ef_prime.rflow.node.NodeComment;
import com.ef_prime.rflow.node.NodeModel;
import com.ef_prime.rflow.ui.common.item.ItemName;
import com.ef_prime.rflow.ui.flow.FlowViewer;
import com.ef_prime.rflow.ui.flow.rendering.FlowRenderer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.util.Collections;
import java.util.List;

public class CommentNodeModel
extends NodeModel {
    private NodeComment comment;
    private boolean visible = true;
    private boolean rollOvered = false;

    public CommentNodeModel() {
        this.comment = NodeComment.createNoBorder();
        this.comment.createComment();
        this.comment.getCommentComponent();
        this.comment.getOffset().setLocation(0, 0);
        this.comment.setState("opened");
        this.setComment("");
    }

    private CommentNodeModel(CommentNodeModel commentNodeModel) {
        super(commentNodeModel);
        this.comment = commentNodeModel.comment.copy();
        this.visible = commentNodeModel.visible;
    }

    public String getComment() {
        return this.comment.getText();
    }

    public void setComment(String string) {
        this.comment.setText(string);
    }

    public NodeComment getNodeComment() {
        return this.comment;
    }

    public void setVisible(boolean bl) {
        this.visible = bl;
    }

    public boolean isOpened() {
        return this.comment.getState().equals("opened");
    }

    @Override
    public String getDefaultTitle() {
        if (!this.visible || this.comment.isCommentOpened() || this.rollOvered) {
            return null;
        }
        String string = this.getComment();
        int n = string.indexOf("\n");
        if (n < 0) {
            return string;
        }
        return string.substring(0, n);
    }

    @Override
    public Component getComponent(boolean bl, boolean bl2) {
        if (this.isOpened() && this.visible) {
            this.comment.setRollOvered(bl2);
            this.comment.setSelected(bl);
            return this.comment.getCommentComponent();
        }
        return null;
    }

    public Rectangle getRect(int n, int n2) {
        if (!this.visible) {
            return new Rectangle(n, n2, 0, 0);
        }
        if (this.isOpened()) {
            return this.getComponentRect(n, n2);
        }
        int n3 = 10;
        return new Rectangle(n, n2, n3, n3);
    }

    private Rectangle getComponentRect(int n, int n2) {
        Dimension dimension = this.comment.getCommentComponent().getPreferredSize();
        return new Rectangle(n, n2, dimension.width, dimension.height);
    }

    @Override
    public String getCommandImpl(boolean bl, FlowRunOption flowRunOption) {
        return "";
    }

    @Override
    public Shape getShape() {
        return this.getRect(0, 0);
    }

    @Override
    public Shape getGlassShape() {
        return this.getShape();
    }

    @Override
    public Paint getFillPaint(boolean bl, boolean bl2) {
        return NodeComment.FILL_COLOR;
    }

    @Override
    public Paint getDrawPaint(boolean bl) {
        return bl ? NodeComment.SELECTED_DRAW_COLOR : NodeComment.DRAW_COLOR;
    }

    @Override
    public void paintOnRollOver(FlowRenderer flowRenderer, Graphics2D graphics2D, int n, int n2) {
        if (!this.isOpened()) {
            this.comment.setRollOvered(false);
            flowRenderer.getRendererPane().paintComponent(graphics2D, this.comment.getCommentComponent(), flowRenderer.getScreenDevice(), this.getComponentRect(n, n2));
        }
    }

    @Override
    public boolean isConnectable() {
        return false;
    }

    @Override
    public boolean isExecutable() {
        return false;
    }

    @Override
    public boolean isProperty() {
        return false;
    }

    @Override
    public boolean canBeDisabled() {
        return false;
    }

    @Override
    public boolean canSetBreakpoint() {
        return false;
    }

    @Override
    public int getTitleLineCount() {
        return 1;
    }

    @Override
    public int getTitleWidth() {
        return 200;
    }

    @Override
    public Rectangle getTitleRectangle(Component component, Rectangle2D rectangle2D, int n, int n2) {
        Dimension dimension = component.getPreferredSize();
        Rectangle rectangle = this.getRect(n, n2);
        int n3 = dimension.width > 200 ? 200 : dimension.width;
        return new Rectangle(rectangle.x + rectangle.width + 5, rectangle.y + rectangle.height / 2 - dimension.height / 2, n3, dimension.height);
    }

    @Override
    public boolean mousePressed(FlowViewer flowViewer, FlowNode flowNode, Point point) {
        if (this.isOpened() && this.comment.getCloseButtonRect(0, 0).contains(point)) {
            this.comment.setState("closed");
            flowViewer.getState().setRollOverNode(null);
            flowViewer.repaint();
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseClicked(FlowViewer flowViewer, FlowNode flowNode, Point point) {
        if (!this.isOpened()) {
            this.comment.setState("opened");
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseEntered(FlowNode flowNode) {
        this.rollOvered = true;
        return true;
    }

    @Override
    public boolean mouseExited(FlowNode flowNode) {
        this.rollOvered = false;
        return true;
    }

    @Override
    public List<ItemName> getResults() {
        return Collections.EMPTY_LIST;
    }

    @Override
    public ItemName getPrimaryResult() {
        return null;
    }

    @Override
    public NodeModel copy() {
        return new CommentNodeModel(this);
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof CommentNodeModel) {
            return super.equals(object) && this.comment.equals(((CommentNodeModel)object).comment);
        }
        return false;
    }
}

