/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.node.base;

import com.ef_prime.rflow.core.flow.FlowNode;
import com.ef_prime.rflow.core.flow.ViewLayout;
import com.ef_prime.rflow.node.ModelCreationFailedException;
import com.ef_prime.rflow.node.NodeModel;
import com.ef_prime.rflow.node.base.CommentNodeModel;
import com.ef_prime.rflow.ui.flow.FlowViewer;
import com.ef_prime.rflow.ui.node.ShortNodeModelController;
import edu.uci.ics.jung.graph.ArchetypeVertex;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.geom.Point2D;
import java.util.Properties;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.JTextComponent;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Element;

public class CommentNodeModelController
extends ShortNodeModelController {
    private String KEY_COMMENT = "comment";
    private String KEY_STATE = "state";

    @Override
    public NodeModel createNewModel() {
        return new CommentNodeModel();
    }

    @Override
    public Properties getOptionProperties(NodeModel nodeModel) {
        CommentNodeModel commentNodeModel = (CommentNodeModel)nodeModel;
        Properties properties = new Properties();
        properties.setProperty(this.KEY_COMMENT, commentNodeModel.getComment());
        properties.setProperty(this.KEY_STATE, commentNodeModel.getNodeComment().getState());
        return properties;
    }

    @Override
    public NodeModel createModel(Properties properties, Element element, String string, ViewLayout[] viewLayoutArray) throws ModelCreationFailedException {
        CommentNodeModel commentNodeModel = new CommentNodeModel();
        commentNodeModel.setComment(properties.getProperty(this.KEY_COMMENT, ""));
        commentNodeModel.getNodeComment().setState(properties.getProperty(this.KEY_STATE, "opened"));
        return commentNodeModel;
    }

    @Override
    public Class<? extends NodeModel> getModelClass() {
        return CommentNodeModel.class;
    }

    @Override
    public Window createEditDialog(FlowViewer flowViewer, FlowNode flowNode, boolean bl, boolean bl2) {
        return null;
    }

    @Override
    public boolean canOpen() {
        return false;
    }

    @Override
    public boolean canEditOnViewer() {
        return true;
    }

    @Override
    public void editOnViewer(FlowViewer flowViewer, FlowNode flowNode) {
        CommentNodeModel commentNodeModel = (CommentNodeModel)flowNode.getModel();
        String string = commentNodeModel.getNodeComment().getState();
        commentNodeModel.getNodeComment().setState("opened");
        commentNodeModel.getNodeComment().setEditing(true);
        JTextComponent jTextComponent = (JTextComponent)commentNodeModel.getComponent(false, false);
        if (jTextComponent != null && jTextComponent.getParent() != flowViewer) {
            flowViewer.add(jTextComponent);
            Point2D point2D = flowViewer.getGraphLayout().getLocation((ArchetypeVertex)flowNode);
            if (point2D != null) {
                point2D = flowViewer.layoutTransform(point2D);
                jTextComponent.setBounds(commentNodeModel.getRect((int)point2D.getX(), (int)point2D.getY()));
                jTextComponent.requestFocusInWindow();
                commentNodeModel.setVisible(false);
                EditingHandler editingHandler = new EditingHandler(flowNode, commentNodeModel, string);
                editingHandler.install(jTextComponent, flowViewer);
            }
        }
    }

    private static class EditingHandler
    implements ChangeListener,
    FocusListener {
        private FlowNode node;
        private CommentNodeModel model;
        private String oldState;
        private Component c;
        private FlowViewer viewer;

        public EditingHandler(FlowNode flowNode, CommentNodeModel commentNodeModel, String string) {
            this.node = flowNode;
            this.model = commentNodeModel;
            this.oldState = string;
        }

        private void install(Component component, FlowViewer flowViewer) {
            this.c = component;
            this.viewer = flowViewer;
            component.addFocusListener(this);
            flowViewer.addChangeListener(this);
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            if (this.c.getParent() != null) {
                this.c.getParent().remove(this.c);
            }
            this.restoreCommentState();
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            this.restoreCommentState();
        }

        private void restoreCommentState() {
            this.model.setVisible(true);
            this.model.getNodeComment().setState(this.oldState);
            this.model.getNodeComment().setEditing(false);
            FlowNode.fireNodeModelChanged(this.node);
            this.c.removeFocusListener(this);
            this.viewer.removeChangeListener(this);
            if (StringUtils.isBlank((CharSequence)this.model.getComment())) {
                this.viewer.deleteNode(new FlowNode[]{this.node});
            }
        }
    }
}

