/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.node.base;

import com.ef_prime.rflow.core.app.r.base.R;
import com.ef_prime.rflow.core.app.r.keyvalue.RStrKey;
import com.ef_prime.rflow.core.common.keyvalue.ValueMap;
import com.ef_prime.rflow.core.common.keyvalue.ViewOptions;
import com.ef_prime.rflow.core.common.keyvalue.WidgetNode;
import com.ef_prime.rflow.core.common.keyvalue.XFlowPanelWidgetNode;
import com.ef_prime.rflow.core.common.xml.XmlContext;
import com.ef_prime.rflow.core.flow.FlowRunOption;
import com.ef_prime.rflow.core.flow.ViewLayout;
import com.ef_prime.rflow.core.util.ScriptBuilder;
import com.ef_prime.rflow.node.NodeModel;
import com.ef_prime.rflow.node.base.ClosedSubflowNodeModel;
import com.ef_prime.rflow.node.base.LoopNodeModel;
import com.ef_prime.rflow.resource.Messages;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ForNodeModel
extends ClosedSubflowNodeModel {
    private static final RStrKey VARIABLE = ((RStrKey.Builder)((RStrKey.Builder)((RStrKey.Builder)RStrKey.builder("var", Messages.getString("Node.For.variable")).setDefaultValue("i")).setRequired(true)).setMinWidth(80)).build();
    private static final RStrKey RANGE = ((RStrKey.Builder)((RStrKey.Builder)((RStrKey.Builder)RStrKey.builder("range", Messages.getString("Node.For.range")).setEmptyMessage(Messages.getString("Message.eg") + " 1:10")).setRequired(true)).setMinWidth(80)).build();
    private Condition condition;
    private String conditionString;

    public ForNodeModel() {
        this.condition = new Condition();
        this.condition.addEventHandler(this);
    }

    ForNodeModel(Element element, String string, ViewLayout viewLayout) {
        super(viewLayout);
        this.condition = new Condition();
        if (element != null) {
            this.condition.loadElement(element, (XmlContext)null);
        }
        this.condition.addEventHandler(this);
        if (element == null || this.condition.getValue(VARIABLE).isEmpty() && this.condition.getValue(RANGE).isEmpty()) {
            if (string != null && string.isEmpty()) {
                string = null;
            }
            this.conditionString = string;
            if (string != null) {
                R.queryQueue().addQuery(() -> this.readyCondition());
            }
        }
    }

    private ForNodeModel(ForNodeModel forNodeModel, boolean bl) {
        super(forNodeModel, bl);
        this.condition = (Condition)forNodeModel.condition.copy();
        this.condition.addEventHandler(this);
    }

    public String getConditionString() {
        if (this.conditionString != null) {
            return this.conditionString;
        }
        return this.condition.getValue(VARIABLE) + " in " + this.condition.getValue(RANGE);
    }

    public void readyCondition() {
        if (this.conditionString == null) {
            return;
        }
        try {
            String[] stringArray = R.client().getForElements(this.conditionString);
            if (stringArray != null) {
                this.condition.putValue(VARIABLE, stringArray[0]);
                this.condition.putValue(RANGE, stringArray[1]);
                this.conditionString = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public ValueMap getValueMap() {
        return this.condition;
    }

    @Override
    public String getCommandImpl(boolean bl, FlowRunOption flowRunOption) {
        ScriptBuilder scriptBuilder = new ScriptBuilder("\n");
        if (bl && this.isBreakpointEnabled()) {
            scriptBuilder.appendLn(R.client().getDebugCommand());
        }
        scriptBuilder.appendLn("for (" + this.getConditionString() + ") {");
        scriptBuilder.appendIndented(this.getFlowCommand(bl, flowRunOption));
        scriptBuilder.append("}");
        return scriptBuilder.toString();
    }

    @Override
    public String getDefaultTitle() {
        return "for";
    }

    @Override
    public NodeModel copy() {
        return new ForNodeModel(this, false);
    }

    @Override
    public NodeModel fullCopy() {
        return new ForNodeModel(this, true);
    }

    @Override
    public String getTypeID() {
        return LoopNodeModel.class.getCanonicalName();
    }

    public void storeToElement(Document document, Element element) {
        this.condition.storeToElement(null, document, element);
    }

    private static class Condition
    extends ValueMap {
        public Condition() {
            this.registerKeys(VARIABLE, RANGE);
        }

        @Override
        public WidgetNode getWidgetNode(ViewOptions viewOptions) {
            return new XFlowPanelWidgetNode().addKeys(VARIABLE, RANGE);
        }

        @Override
        public boolean isValidationEnabled() {
            return true;
        }

        @Override
        public ValueMap copy() {
            Condition condition = new Condition();
            condition.copyValues(this);
            return condition;
        }
    }
}

