/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.node.base;

import com.ef_prime.rflow.core.flow.FlowNode;
import com.ef_prime.rflow.core.flow.ViewLayout;
import com.ef_prime.rflow.node.ModelCreationFailedException;
import com.ef_prime.rflow.node.NodeModel;
import com.ef_prime.rflow.node.base.ClosedSubflowNodeView;
import com.ef_prime.rflow.node.base.ForNodeModel;
import com.ef_prime.rflow.node.base.LoopType;
import com.ef_prime.rflow.node.base.SubflowNodeModelController;
import com.ef_prime.rflow.ui.common.keyvalue.Widget;
import com.ef_prime.rflow.ui.common.keyvalue.WidgetFactory;
import com.ef_prime.rflow.ui.flow.FlowNodeView;
import com.ef_prime.rflow.ui.flow.FlowPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Properties;
import javax.swing.JPanel;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ForNodeModelController
extends SubflowNodeModelController {
    @Override
    public Class<? extends NodeModel> getModelClass() {
        return ForNodeModel.class;
    }

    @Override
    public Properties getOptionProperties(NodeModel nodeModel) {
        ForNodeModel forNodeModel = (ForNodeModel)nodeModel;
        Properties properties = new Properties();
        properties.setProperty("loop", LoopType.FOR.getCode());
        properties.setProperty("condition", forNodeModel.getConditionString());
        return properties;
    }

    @Override
    public boolean saveAsXMLElement() {
        return true;
    }

    @Override
    public void storeToXMLElement(NodeModel nodeModel, Document document, Element element) {
        ((ForNodeModel)nodeModel).storeToElement(document, element);
    }

    @Override
    public NodeModel createModel(Properties properties, Element element, String string, ViewLayout[] viewLayoutArray) throws ModelCreationFailedException {
        String string2 = properties.getProperty("condition");
        if (string2 == null && element == null || viewLayoutArray.length < 1) {
            throw new ModelCreationFailedException();
        }
        return new ForNodeModel(element, string2, viewLayoutArray[0]);
    }

    @Override
    public FlowNodeView createView(FlowNode flowNode, boolean bl) {
        return new ForView(flowNode, bl);
    }

    private static class ForView
    extends ClosedSubflowNodeView {
        public ForView(FlowNode flowNode, boolean bl) {
            super(flowNode, bl);
        }

        @Override
        protected boolean getTabIconOnly() {
            return false;
        }

        @Override
        protected String getTabTitle() {
            ForNodeModel forNodeModel = (ForNodeModel)this.getNode().getModel();
            return forNodeModel.getDefaultTitle();
        }

        @Override
        protected Component createSubflowView() {
            JPanel jPanel = new JPanel(new BorderLayout());
            ForNodeModel forNodeModel = (ForNodeModel)this.getNode().getModel();
            forNodeModel.readyCondition();
            Widget widget = (Widget)WidgetFactory.getInstance().create(forNodeModel.getValueMap());
            this.setWidget(widget);
            jPanel.add((Component)widget, "North");
            jPanel.add((Component)new FlowPanel(this.getNode(), this.getFirstViewer(), this.showCodeBar()), "Center");
            return jPanel;
        }
    }
}

