/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.node.base;

import com.ef_prime.rflow.Rflow;
import com.ef_prime.rflow.core.app.r.base.R;
import com.ef_prime.rflow.core.app.r.base.RPackage;
import com.ef_prime.rflow.core.app.r.base.RUtility;
import com.ef_prime.rflow.core.app.r.base.SentenceInfo;
import com.ef_prime.rflow.core.app.r.console.BasicCommand;
import com.ef_prime.rflow.core.app.r.console.Command;
import com.ef_prime.rflow.core.app.r.console.CommandUtility;
import com.ef_prime.rflow.core.app.r.script.RSyntaxDocumentWithIndentChanged;
import com.ef_prime.rflow.core.base.Settings;
import com.ef_prime.rflow.core.feature.search.SearchContext;
import com.ef_prime.rflow.core.feature.search.SearchResult;
import com.ef_prime.rflow.core.feature.search.SearchUtility;
import com.ef_prime.rflow.core.feature.search.TextSearchResult;
import com.ef_prime.rflow.core.flow.FlowRunOption;
import com.ef_prime.rflow.node.NodeModel;
import com.ef_prime.rflow.ui.app.r.script.RScriptUtility;
import com.ef_prime.rflow.ui.base.Icons;
import com.ef_prime.rflow.ui.flow.rendering.NodeShape;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import org.fife.ui.rsyntaxtextarea.RSyntaxDocument;
import org.fife.ui.rtextarea.RUndoManager;

public class FreeNodeModel
extends NodeModel
implements UndoableEditListener {
    private static final Icon ICON = Icons.getIcon("32/script.png");
    private static final Icon ICON_SMALL = Icons.getIcon("16/script.png");
    private static final Rectangle shape;
    private static final Logger LOGGER;
    private RSyntaxDocument document;
    private RUndoManager undoManager;
    private SentenceInfo sentenceInfo;
    private List<RPackage> autoPackages = Collections.emptyList();
    private List<RPackage> attachPackages = Collections.emptyList();

    public FreeNodeModel() {
        this("");
    }

    public FreeNodeModel(String string) {
        this.init(string);
        this.updateOneLineInfo();
    }

    private FreeNodeModel(FreeNodeModel freeNodeModel) {
        super(freeNodeModel);
        this.init(freeNodeModel.getCommand(false, null));
        this.sentenceInfo = freeNodeModel.sentenceInfo;
    }

    private void init(String string) {
        this.document = new RSyntaxDocumentWithIndentChanged("RSYNTAX");
        if (!string.isEmpty()) {
            try {
                this.document.insertString(0, string, null);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        this.undoManager = new RUndoManager(null);
        this.document.addUndoableEditListener((UndoableEditListener)this.undoManager);
        this.document.addUndoableEditListener((UndoableEditListener)this);
        this.updateAutoPackages();
    }

    private String getCommandString() {
        try {
            return this.document.getText(0, this.document.getLength());
        }
        catch (BadLocationException badLocationException) {
            return "";
        }
    }

    public RSyntaxDocument getDocument() {
        return this.document;
    }

    @Override
    public String getCommandImpl(boolean bl, FlowRunOption flowRunOption) {
        if (!bl) {
            return this.getCommandString();
        }
        StringBuilder stringBuilder = new StringBuilder();
        String[] stringArray = this.getCommandString().split("\n");
        for (int i = 0; i < stringArray.length; ++i) {
            if (this.getBreakpoints().contains(i + 1)) {
                stringBuilder.append(R.client().getDebugCommand() + "\n");
            }
            stringBuilder.append(stringArray[i] + "\n");
        }
        return stringBuilder.toString();
    }

    @Override
    public Command getCommandObject(FlowRunOption flowRunOption, boolean bl) {
        boolean bl2;
        boolean bl3 = bl2 = !flowRunOption.isExcludeDebugScript();
        if (flowRunOption.dontSplitCommand()) {
            return new BasicCommand(this.getCommand(bl2, null));
        }
        return CommandUtility.getLineSeparatedCommand(R.client(), this.getCommand(bl2, null));
    }

    @Override
    public boolean canSetBreakpoint() {
        return true;
    }

    @Override
    public boolean canSetInnerBreakpoint() {
        return true;
    }

    public void setBreakpoints(List<Integer> list) {
        this.breakpoints = list;
    }

    @Override
    public void setCommand(String string) {
        try {
            this.getUndoManager().beginInternalAtomicEdit();
            this.document.replace(0, this.document.getLength(), string, null);
            this.getUndoManager().endInternalAtomicEdit();
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        this.updateAutoPackages();
    }

    @Override
    public String getDefaultTitle() {
        String string;
        if (this.sentenceInfo != null && !(string = this.sentenceInfo.getFunction()).isEmpty() && !RUtility.isOperator(string)) {
            Object object = "";
            if (!this.sentenceInfo.getSymbol().isEmpty()) {
                object = (String)object + this.sentenceInfo.getSymbol() + "<-";
            }
            object = (String)object + string;
            return object;
        }
        return RUtility.titleForScript(this.getCommandString());
    }

    @Override
    public List<RPackage> getAutoPackageList() {
        if (Rflow.settings().getValue(Settings.AUTO_DETECT_PACKAGES).booleanValue()) {
            return this.autoPackages;
        }
        return Collections.emptyList();
    }

    public List<RPackage> getAttachPackageList() {
        return this.attachPackages;
    }

    public RUndoManager getUndoManager() {
        return this.undoManager;
    }

    public boolean isEmpty() {
        return this.document.getLength() == 0;
    }

    public boolean isOneLine() {
        Element element = this.document.getDefaultRootElement();
        int n = element.getElementCount();
        if (n > 2) {
            return false;
        }
        if (n <= 1) {
            return true;
        }
        Element element2 = element.getElement(1);
        return element2.getEndOffset() - element2.getStartOffset() == 1;
    }

    private String getFirstLine() {
        if (this.isEmpty()) {
            return "";
        }
        Element element = this.document.getDefaultRootElement();
        Element element2 = element.getElement(0);
        try {
            return this.document.getText(element2.getStartOffset(), element2.getEndOffset());
        }
        catch (BadLocationException badLocationException) {
            return "";
        }
    }

    private void updateOneLineInfo() {
        if (this.isOneLine()) {
            String string = this.getFirstLine();
            if (string.isEmpty()) {
                this.sentenceInfo = null;
            } else {
                R.queryQueue().addQuery(() -> {
                    SentenceInfo sentenceInfo = RScriptUtility.retrieveSentenceInfo(string);
                    if (sentenceInfo != null) {
                        this.sentenceInfo = sentenceInfo;
                    }
                });
            }
        } else {
            this.sentenceInfo = null;
        }
    }

    @Override
    public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
        this.updateOneLineInfo();
        this.updateAutoPackages();
        this.fireNodeModelEvent();
    }

    public void updateAutoPackages() {
        String string = this.getCommandString();
        this.autoPackages = RPackage.detectRequiredPackages(string, false);
        this.attachPackages = RPackage.detectRequiredPackages(string, true);
    }

    @Override
    public boolean isEditable() {
        return this.isOneLine();
    }

    @Override
    public SearchResult[] search(SearchContext searchContext) {
        List<TextSearchResult> list = SearchUtility.searchRScript(searchContext, this.document);
        if (list.isEmpty()) {
            return null;
        }
        return list.toArray(new SearchResult[list.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean replace(SearchContext searchContext, String string, SearchResult[] searchResultArray, int n) {
        SearchResult searchResult = searchResultArray[n];
        if (searchResult instanceof TextSearchResult) {
            TextSearchResult textSearchResult = (TextSearchResult)searchResult;
            if (searchContext.isRegularExpression() && (string = SearchUtility.replaceStringForRegex(searchContext, this.getCommandString(), textSearchResult.getOffset(), textSearchResult.getLength(), string)) == null) {
                return false;
            }
            this.getUndoManager().beginInternalAtomicEdit();
            try {
                try {
                    this.document.replace(textSearchResult.getOffset(), textSearchResult.getLength(), string, null);
                }
                catch (BadLocationException badLocationException) {
                    LOGGER.log(Level.SEVERE, "Failed to replace.", badLocationException);
                }
            }
            finally {
                this.getUndoManager().endInternalAtomicEdit();
            }
            SearchUtility.repositionSearchResultsAfterReplace(searchResultArray, textSearchResult, string.length());
            textSearchResult.setLength(string.length());
            return true;
        }
        return false;
    }

    @Override
    public Icon getSmallIcon() {
        return ICON_SMALL;
    }

    @Override
    public Icon getIcon() {
        return ICON;
    }

    @Override
    public Shape getShape() {
        return shape;
    }

    @Override
    protected NodeShape getNodeShape() {
        if (this.isOneLine()) {
            if (this.isEmpty() || this.sentenceInfo != null && this.sentenceInfo.getSymbol().length() > 0) {
                return NodeShape.CIRCLE;
            }
            return NodeShape.TRIANGLE;
        }
        return NodeShape.RECTANGLE;
    }

    @Override
    public Shape getGlassShape() {
        return super.getGlassShape();
    }

    @Override
    public NodeModel copy() {
        return new FreeNodeModel(this);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof FreeNodeModel) {
            FreeNodeModel freeNodeModel = (FreeNodeModel)object;
            return super.equals(object) && this.breakpoints.equals(freeNodeModel.breakpoints);
        }
        return false;
    }

    static {
        LOGGER = Logger.getLogger(FreeNodeModel.class.getName());
        int n = ICON.getIconWidth();
        int n2 = ICON.getIconHeight();
        shape = new Rectangle(-n / 2, -n2 / 2, n, n2);
    }
}

