/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.node.base;

import com.ef_prime.rflow.Rflow;
import com.ef_prime.rflow.core.app.r.script.RSyntaxError;
import com.ef_prime.rflow.core.feature.search.LineSearchResult;
import com.ef_prime.rflow.core.feature.search.SearchCursorEvent;
import com.ef_prime.rflow.core.feature.search.SearchNode;
import com.ef_prime.rflow.core.feature.search.SearchResult;
import com.ef_prime.rflow.core.feature.search.SearchStateChangedEvent;
import com.ef_prime.rflow.core.feature.search.TextSearchResult;
import com.ef_prime.rflow.core.flow.FlowError;
import com.ef_prime.rflow.core.flow.FlowModel;
import com.ef_prime.rflow.core.flow.FlowNode;
import com.ef_prime.rflow.core.flow.RSyntaxFlowError;
import com.ef_prime.rflow.core.flow.ViewLayout;
import com.ef_prime.rflow.node.ModelCreationFailedException;
import com.ef_prime.rflow.node.NodeModel;
import com.ef_prime.rflow.node.NodeModelChangeListener;
import com.ef_prime.rflow.node.NodeOptionView;
import com.ef_prime.rflow.node.NodePropertyView;
import com.ef_prime.rflow.node.RequestNodeModelNotifyEvent;
import com.ef_prime.rflow.node.base.FreeNodeModel;
import com.ef_prime.rflow.resource.Messages;
import com.ef_prime.rflow.ui.app.r.script.ErrorParser;
import com.ef_prime.rflow.ui.app.r.script.RCodingScrollPane;
import com.ef_prime.rflow.ui.app.r.script.RCodingTextAreaEx;
import com.ef_prime.rflow.ui.app.r.script.RScriptUtility;
import com.ef_prime.rflow.ui.base.CodeBar;
import com.ef_prime.rflow.ui.base.Icons;
import com.ef_prime.rflow.ui.base.MenuActionProvider;
import com.ef_prime.rflow.ui.base.UIColor;
import com.ef_prime.rflow.ui.common.component.CodingSearchBar;
import com.ef_prime.rflow.ui.common.component.CodingStatusBar;
import com.ef_prime.rflow.ui.common.event.EventManager;
import com.ef_prime.rflow.ui.common.event.SimpleEvent;
import com.ef_prime.rflow.ui.common.event.SimpleEventHandler;
import com.ef_prime.rflow.ui.common.view.View;
import com.ef_prime.rflow.ui.common.view.ViewTabbedPane;
import com.ef_prime.rflow.ui.flow.FlowErrorEvent;
import com.ef_prime.rflow.ui.flow.FlowNodeView;
import com.ef_prime.rflow.ui.flow.FlowViewer;
import com.ef_prime.rflow.ui.node.DefaultNodeModelController;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import org.fife.ui.rsyntaxtextarea.DocumentRange;
import org.fife.ui.rsyntaxtextarea.ErrorStrip;
import org.fife.ui.rsyntaxtextarea.parser.Parser;
import org.fife.ui.rtextarea.RTextArea;
import org.w3c.dom.Element;

public class FreeNodeModelController
extends DefaultNodeModelController {
    @Override
    public String getModelName() {
        return Messages.getString("FreeNodeModelController.model_name");
    }

    @Override
    public Class<? extends NodeModel> getModelClass() {
        return FreeNodeModel.class;
    }

    @Override
    public Properties getOptionProperties(NodeModel nodeModel) {
        return null;
    }

    @Override
    public NodeModel createModel(Properties properties, Element element, String string, ViewLayout[] viewLayoutArray) throws ModelCreationFailedException {
        return new FreeNodeModel(string);
    }

    @Override
    public void editOnViewer(FlowViewer flowViewer, FlowNode flowNode) {
        CodeBar codeBar;
        FreeNodeModel freeNodeModel = (FreeNodeModel)flowNode.getModel();
        if ((freeNodeModel.isEmpty() || freeNodeModel.isOneLine()) && (codeBar = flowViewer.getCodeBar()) != null) {
            codeBar.startEditing();
        }
    }

    @Override
    public FlowNodeView createView(FlowNode flowNode, boolean bl) {
        return new FreeNodeOptionPanel(flowNode, bl);
    }

    private static class FreeNodeOptionPanel
    extends NodeOptionView
    implements NodeModelChangeListener,
    SimpleEventHandler,
    CaretListener,
    DocumentListener,
    FocusListener,
    MenuActionProvider {
        private FreeNodeModel model;
        RCodingTextAreaEx textArea;
        private RCodingScrollPane scrollPane;
        private boolean isModelChanged;
        private ErrorParser errorParser;
        private SearchNode searchNode;

        FreeNodeOptionPanel(FlowNode flowNode, boolean bl) {
            super(flowNode, bl);
        }

        @Override
        public void initFocus() {
            this.textArea.requestFocusInWindow();
        }

        @Override
        protected Component createCenterView() {
            this.model = (FreeNodeModel)this.getNode().getModel();
            this.textArea = new RCodingTextAreaEx();
            this.textArea.setModel((Document)this.model.getDocument(), this.model.getUndoManager());
            this.textArea.setMarkAllHighlightColor(UIColor.MARK_ALL);
            this.textArea.startAutoCompletionNotifier();
            if (this.model.isOneLine()) {
                this.textArea.setCaretPosition(this.textArea.getDocument().getLength());
            }
            this.model.getUndoManager().setTextArea((RTextArea)this.textArea);
            this.textArea.setCodeFoldingEnabled(true);
            this.textArea.addFocusListener(this);
            this.scrollPane = new RCodingScrollPane(this.textArea, this.getNode());
            this.scrollPane.setPreferredSize(new Dimension(500, 300));
            ErrorStrip errorStrip = RScriptUtility.createErrorStrip(this.textArea);
            CodingStatusBar codingStatusBar = new CodingStatusBar(this.textArea);
            CodingSearchBar codingSearchBar = new CodingSearchBar(this.textArea);
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.add((Component)((Object)this.scrollPane), "Center");
            jPanel.add((Component)codingSearchBar, "South");
            JPanel jPanel2 = new JPanel(new BorderLayout());
            jPanel2.add((Component)jPanel, "Center");
            jPanel2.add((Component)errorStrip, "East");
            jPanel2.add((Component)codingStatusBar, "South");
            return jPanel2;
        }

        @Override
        protected Component createCenterTabbedPane(Component component) {
            if (this.getNode().isRootNode()) {
                return component;
            }
            View view2 = new View();
            view2.add(component);
            view2.setTitle(this.getTabTitle());
            view2.setIcon(this.getTabIcon());
            view2.setIconOnly(this.getTabIconOnly());
            ViewTabbedPane viewTabbedPane = new ViewTabbedPane(false);
            viewTabbedPane.openView(view2);
            viewTabbedPane.openView(new NodePropertyView(this.getNode()));
            return viewTabbedPane;
        }

        @Override
        protected String getTabTitle() {
            return Messages.getString("Widget.R.script");
        }

        @Override
        protected Icon getTabIcon() {
            return Icons.getIcon("16/script.png");
        }

        @Override
        protected void configureToolBar(JToolBar jToolBar) {
            super.configureToolBar(jToolBar);
            if (!this.isPreview()) {
                jToolBar.add(this.createToolBarButton(this.viewActions.get("RUN")));
                jToolBar.add(this.createToolBarButton(this.viewActions.get("RUN_CLEAR")));
            }
            jToolBar.add(this.createToolBarButton(this.textArea.getActionMap().get("CodingTextArea.RUN")));
        }

        @Override
        public Component getFirstFocusComponent() {
            return this.textArea;
        }

        @Override
        public void loadView() {
            List<FlowError> list;
            super.loadView();
            FlowNode.addNodeModelChangeListener(this);
            FlowNode.addNodeBreakpointChangeListener(this.scrollPane);
            this.model.getDocument().addDocumentListener((DocumentListener)this);
            EventManager.getInstance().registerEventHandler(RequestNodeModelNotifyEvent.class, this);
            EventManager.getInstance().registerEventHandler(SearchStateChangedEvent.class, this);
            EventManager.getInstance().registerEventHandler(FlowErrorEvent.class, this);
            SearchStateChangedEvent searchStateChangedEvent = Rflow.mainView().getSearchExplorer().createStateChangedEvent();
            this.onEvent(searchStateChangedEvent);
            this.textArea.addCaretListener(this);
            Optional<FlowModel> optional = this.getFlowModel();
            if (optional.isPresent() && (list = optional.get().getState().getError(this.getNode())) != null) {
                for (FlowError flowError : list) {
                    if (!(flowError instanceof RSyntaxFlowError)) continue;
                    this.addErrorParser((RSyntaxFlowError)flowError);
                    break;
                }
            }
        }

        @Override
        public void unloadView() {
            super.unloadView();
            FlowNode.removeNodeModelChangeListener(this);
            FlowNode.removeNodeBreakpointChangeListener(this.scrollPane);
            this.model.getDocument().removeDocumentListener((DocumentListener)this);
            this.textArea.removeCaretListener(this);
            EventManager.getInstance().removeEventHandler(RequestNodeModelNotifyEvent.class, this);
            EventManager.getInstance().removeEventHandler(SearchStateChangedEvent.class, this);
            EventManager.getInstance().removeEventHandler(FlowErrorEvent.class, this);
            this.textArea.endAutoCompletionNotifier();
            this.scrollPane.uninstall();
        }

        @Override
        public void onEvent(SimpleEvent simpleEvent) {
            if (simpleEvent.getClass().equals(RequestNodeModelNotifyEvent.class)) {
                this.fireWaitingModelChanged2();
            } else if (simpleEvent.getClass().equals(SearchStateChangedEvent.class)) {
                SearchStateChangedEvent searchStateChangedEvent = (SearchStateChangedEvent)simpleEvent;
                this.searchNode = searchStateChangedEvent.getSearchNodeMap().get(this.getNode());
                ArrayList<DocumentRange> arrayList = new ArrayList<DocumentRange>();
                if (this.searchNode != null && this.searchNode.getHitCount() > 0) {
                    SearchResult[] searchResultArray;
                    for (SearchResult searchResult : searchResultArray = this.searchNode.getSearchResults()) {
                        if (!searchResult.isEnabled() || !(searchResult instanceof TextSearchResult)) continue;
                        TextSearchResult textSearchResult = (TextSearchResult)searchResult;
                        int n = textSearchResult.getOffset();
                        int n2 = n + textSearchResult.getLength();
                        arrayList.add(new DocumentRange(n, n2));
                    }
                }
                this.textArea.clearMarkAllHighlights();
                this.textArea.markAll(arrayList);
            } else if (simpleEvent.getClass().equals(FlowErrorEvent.class)) {
                FlowErrorEvent flowErrorEvent = (FlowErrorEvent)simpleEvent;
                if (this.getNode() == flowErrorEvent.getNode()) {
                    if (this.errorParser != null) {
                        this.textArea.removeParser((Parser)this.errorParser);
                    }
                    if (flowErrorEvent.getType() == 0 && flowErrorEvent.getError() instanceof RSyntaxFlowError) {
                        RSyntaxFlowError rSyntaxFlowError = (RSyntaxFlowError)flowErrorEvent.getError();
                        this.addErrorParser(rSyntaxFlowError);
                    }
                }
            }
        }

        private void addErrorParser(RSyntaxFlowError rSyntaxFlowError) {
            RSyntaxError rSyntaxError = rSyntaxFlowError.getRSyntaxError();
            if (rSyntaxError.isDetailedInfomation()) {
                this.errorParser = new ErrorParser(rSyntaxError, this.textArea.getFontMetrics(this.textArea.getFont()));
                this.textArea.addParser((Parser)this.errorParser);
                this.textArea.forceReparsing((Parser)this.errorParser);
            }
        }

        @Override
        public void caretUpdate(CaretEvent caretEvent) {
            if (this.searchNode != null && this.searchNode.getHitCount() > 0) {
                int n = Math.min(caretEvent.getDot(), caretEvent.getMark());
                if (n != this.textArea.getSelectionStart()) {
                    return;
                }
                TextSearchResult textSearchResult = new TextSearchResult(n, 0);
                SearchResult[] searchResultArray = this.searchNode.getSearchResults();
                TextSearchResult[] textSearchResultArray = new TextSearchResult[searchResultArray.length];
                System.arraycopy(searchResultArray, 0, textSearchResultArray, 0, searchResultArray.length);
                int n2 = Arrays.binarySearch(textSearchResultArray, textSearchResult, new SearchResultComparator());
                boolean bl = false;
                if (n2 < 0) {
                    bl = (n2 = Math.abs(n2) - 1) != searchResultArray.length;
                }
                EventManager.getInstance().dispatchEvent(new SearchCursorEvent(this.searchNode, n2, bl, this));
            }
        }

        @Override
        public void nodeModelChanged(FlowNode flowNode) {
            if (this.lockModelChanged) {
                return;
            }
            if (this.getNode() != flowNode) {
                return;
            }
            this.lockModelChanged = true;
            this.scrollPane.updateBreakpointIcons();
            this.lockModelChanged = false;
        }

        @Override
        public void subflowNodeModelChanged(FlowNode flowNode) {
        }

        @Override
        protected void modelChanged() {
            List<Integer> list;
            List<Integer> list2 = this.model.getBreakpoints();
            if (!list2.equals(list = this.scrollPane.getBreakpoints())) {
                this.model.setBreakpoints(list);
                FlowNode.fireNodeBreakpointChanged(this.getNode(), 3, 3, false);
            }
            this.updateTab();
        }

        @Override
        public void select(SearchResult searchResult) {
            if (searchResult instanceof TextSearchResult) {
                TextSearchResult textSearchResult = (TextSearchResult)searchResult;
                this.textArea.select(textSearchResult.getOffset(), textSearchResult.getOffset() + textSearchResult.getLength());
                this.textArea.requestFocusInWindow();
            } else if (searchResult instanceof LineSearchResult) {
                LineSearchResult lineSearchResult = (LineSearchResult)searchResult;
                int n = lineSearchResult.getLine() - 1;
                if (n < 0) {
                    return;
                }
                javax.swing.text.Element element = this.textArea.getDocument().getDefaultRootElement().getElement(n);
                this.textArea.setCaretPosition(element.getStartOffset());
            }
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.documentChanged();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.documentChanged();
        }

        private void documentChanged() {
            this.textArea.getHighlighter().removeAllHighlights();
            if (this.isModelChanged) {
                this.requestModelChanged(false);
            } else {
                this.isModelChanged = true;
                Optional<FlowModel> optional = this.getFlowModel();
                if (optional.isPresent()) {
                    optional.get().setDirty(true);
                }
                this.fireModelChanged();
            }
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            this.fireWaitingModelChanged();
        }

        @Override
        public Action getAction(String string) {
            if (this.textArea != null) {
                return this.textArea.getAction(string);
            }
            return null;
        }

        private static class SearchResultComparator
        implements Comparator<TextSearchResult> {
            private SearchResultComparator() {
            }

            @Override
            public int compare(TextSearchResult textSearchResult, TextSearchResult textSearchResult2) {
                if (textSearchResult.getOffset() > textSearchResult2.getOffset()) {
                    return 1;
                }
                if (textSearchResult.getOffset() < textSearchResult2.getOffset()) {
                    return -1;
                }
                return 0;
            }
        }
    }
}

