/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.node.base;

import com.ef_prime.rflow.core.app.r.base.ArgEntry;
import com.ef_prime.rflow.core.app.r.base.ArgList;
import com.ef_prime.rflow.core.app.r.base.R;
import com.ef_prime.rflow.core.app.r.keyvalue.RStrKey;
import com.ef_prime.rflow.core.app.r.keyvalue.RTableKey;
import com.ef_prime.rflow.core.common.keyvalue.ValueMap;
import com.ef_prime.rflow.core.common.table.GeneralTableModel;
import com.ef_prime.rflow.core.common.table.KeysTableModel;
import com.ef_prime.rflow.core.common.table.KeysTableRow;
import com.ef_prime.rflow.core.common.xml.XmlContext;
import com.ef_prime.rflow.core.flow.FlowRunOption;
import com.ef_prime.rflow.core.flow.ViewLayout;
import com.ef_prime.rflow.core.util.ScriptBuilder;
import com.ef_prime.rflow.node.NodeModel;
import com.ef_prime.rflow.node.base.ClosedSubflowNodeModel;
import com.ef_prime.rflow.resource.Messages;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class FunctionNodeModel
extends ClosedSubflowNodeModel {
    public static final RStrKey NAME = ((RStrKey.Builder)RStrKey.builder("name", Messages.getString("Message.function_name")).setRequired(true)).build();
    private static final RStrKey ARG_NAME = ((RStrKey.Builder)((RStrKey.Builder)((RStrKey.Builder)RStrKey.builder("arg_name", Messages.getString("ArgsTable.parameter")).setRequired(true)).setMultiLine(true)).setSyntaxCheckPreprocessor(string -> "")).build();
    private static final RStrKey ARG_VALUE = ((RStrKey.Builder)RStrKey.builder("arg_value", Messages.getString("ArgsTable.value")).setMultiLine(true)).build();
    public static final RTableKey ARGS = ((RTableKey.Builder)((RTableKey.Builder)((RTableKey.Builder)RTableKey.builder("args", "Arguments", ARG_NAME, ARG_VALUE).setUiControls(GeneralTableModel.UI_DEFAULT2)).setDefaultRowPredicate()).noLabel()).build();
    private ValueMap values;
    private String argsString;

    public FunctionNodeModel() {
        this.values = new FunctionValueMap();
        this.values.addEventHandler(this);
    }

    FunctionNodeModel(Element element, String string, String string2, ViewLayout viewLayout) {
        super(viewLayout);
        this.values = new FunctionValueMap();
        if (element != null) {
            this.values.loadElement(element, (XmlContext)null);
        }
        this.values.addEventHandler(this);
        if (element == null || this.values.getValue(ARGS).getRowCount() == 0) {
            this.setFunctionName(string);
            this.argsString = string2;
            if (this.argsString != null && (this.argsString.isEmpty() || this.argsString.equals("()"))) {
                this.argsString = null;
            }
            if (this.argsString != null) {
                R.queryQueue().addQuery(() -> this.readyArguments());
            }
        }
    }

    private FunctionNodeModel(FunctionNodeModel functionNodeModel, boolean bl) {
        super(functionNodeModel, bl);
        this.values = (FunctionValueMap)functionNodeModel.values.copy();
        this.values.addEventHandler(this);
        this.argsString = functionNodeModel.argsString;
    }

    @Override
    public ValueMap getValueMap() {
        return this.values;
    }

    public String getFunctionName() {
        return this.values.getValue(NAME);
    }

    private void setFunctionName(String string) {
        this.values.putValue(NAME, string);
    }

    public String getArgsString() {
        if (this.argsString != null) {
            return this.argsString;
        }
        ScriptBuilder scriptBuilder = new ScriptBuilder();
        this.appendArguments(scriptBuilder);
        return scriptBuilder.toString();
    }

    private List<KeysTableRow> getArgRows() {
        return this.values.getValue(ARGS).validRows();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readyArguments() {
        ArgList argList;
        if (this.argsString != null && (argList = FunctionNodeModel.toArgList(this.argsString)) != null) {
            this.argsString = null;
            KeysTableModel keysTableModel = this.values.getValue(ARGS);
            keysTableModel.beginValueChange();
            try {
                keysTableModel.removeAllRows();
                for (ArgEntry argEntry : argList) {
                    keysTableModel.addNewRow(argEntry.getParam(), argEntry.getValue());
                }
            }
            finally {
                keysTableModel.endValueChange();
            }
        }
    }

    private void appendArguments(ScriptBuilder scriptBuilder) {
        if (this.argsString != null) {
            scriptBuilder.append(this.argsString);
        } else {
            scriptBuilder.append('(');
            List<KeysTableRow> list = this.getArgRows();
            for (int i = 0; i < list.size(); ++i) {
                KeysTableRow keysTableRow = list.get(i);
                String string = keysTableRow.getValue(ARG_NAME);
                String string2 = keysTableRow.getValue(ARG_VALUE);
                scriptBuilder.append(string);
                if (!string2.isEmpty()) {
                    scriptBuilder.append(" = ");
                    scriptBuilder.append(string2);
                }
                if (i == list.size() - 1) continue;
                scriptBuilder.append(", ");
            }
            scriptBuilder.append(')');
        }
    }

    private static ArgList toArgList(String string) {
        String string2 = "function" + string + "{}";
        return R.client().argList(string2);
    }

    @Override
    public String getCommandImpl(boolean bl, FlowRunOption flowRunOption) {
        String string;
        ScriptBuilder scriptBuilder = new ScriptBuilder("\n");
        if (bl && this.isBreakpointEnabled()) {
            scriptBuilder.appendLn(R.client().getDebugCommand());
        }
        if ((string = this.getFunctionName()).length() > 0) {
            scriptBuilder.append(string + " <- ");
        }
        scriptBuilder.append("function");
        this.appendArguments(scriptBuilder);
        scriptBuilder.appendLn(" {");
        scriptBuilder.appendIndented(this.getFlowCommand(bl, flowRunOption));
        scriptBuilder.append("}");
        return scriptBuilder.toString();
    }

    @Override
    public String getDefaultTitle() {
        return this.getFunctionName() + "()";
    }

    @Override
    public NodeModel copy() {
        return new FunctionNodeModel(this, false);
    }

    @Override
    public NodeModel fullCopy() {
        return new FunctionNodeModel(this, true);
    }

    public void storeToElement(Document document, Element element) {
        this.values.storeToElement(null, document, element);
    }

    private static class FunctionValueMap
    extends ValueMap {
        public FunctionValueMap() {
            this.registerKeys(NAME, ARGS);
        }

        @Override
        public ValueMap copy() {
            FunctionValueMap functionValueMap = new FunctionValueMap();
            functionValueMap.copyValues(this);
            return functionValueMap;
        }
    }
}

