/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.node.base;

import com.ef_prime.rflow.core.flow.FlowNode;
import com.ef_prime.rflow.core.flow.ViewLayout;
import com.ef_prime.rflow.node.ModelCreationFailedException;
import com.ef_prime.rflow.node.NodeModel;
import com.ef_prime.rflow.node.base.ClosedSubflowNodeView;
import com.ef_prime.rflow.node.base.FunctionNodeModel;
import com.ef_prime.rflow.node.base.SubflowNodeModelController;
import com.ef_prime.rflow.ui.common.keyvalue.Widget;
import com.ef_prime.rflow.ui.common.keyvalue.WidgetFactory;
import com.ef_prime.rflow.ui.flow.FlowNodeView;
import com.ef_prime.rflow.ui.flow.FlowPanel;
import java.awt.Component;
import java.util.Properties;
import javax.swing.JSplitPane;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class FunctionNodeModelController
extends SubflowNodeModelController {
    @Override
    public Class<? extends NodeModel> getModelClass() {
        return FunctionNodeModel.class;
    }

    @Override
    public Properties getOptionProperties(NodeModel nodeModel) {
        FunctionNodeModel functionNodeModel = (FunctionNodeModel)nodeModel;
        Properties properties = new Properties();
        properties.setProperty("function", functionNodeModel.getFunctionName());
        properties.setProperty("args", functionNodeModel.getArgsString());
        return properties;
    }

    @Override
    public boolean saveAsXMLElement() {
        return true;
    }

    @Override
    public void storeToXMLElement(NodeModel nodeModel, Document document, Element element) {
        ((FunctionNodeModel)nodeModel).storeToElement(document, element);
    }

    @Override
    public NodeModel createModel(Properties properties, Element element, String string, ViewLayout[] viewLayoutArray) throws ModelCreationFailedException {
        if (viewLayoutArray.length < 1) {
            throw new ModelCreationFailedException();
        }
        String string2 = properties.getProperty("function");
        String string3 = properties.getProperty("args");
        if ((string2 == null || string3 == null) && element == null) {
            throw new ModelCreationFailedException();
        }
        FunctionNodeModel functionNodeModel = new FunctionNodeModel(element, string2, string3, viewLayoutArray[0]);
        return functionNodeModel;
    }

    @Override
    public FlowNodeView createView(FlowNode flowNode, boolean bl) {
        return new FunctionView(flowNode, bl);
    }

    private static class FunctionView
    extends ClosedSubflowNodeView {
        public FunctionView(FlowNode flowNode, boolean bl) {
            super(flowNode, bl);
        }

        @Override
        protected boolean getTabIconOnly() {
            return false;
        }

        @Override
        protected String getTabTitle() {
            return "function";
        }

        @Override
        protected Component createSubflowView() {
            FunctionNodeModel functionNodeModel = (FunctionNodeModel)this.getNode().getModel();
            functionNodeModel.readyArguments();
            Widget widget = (Widget)WidgetFactory.getInstance().create(functionNodeModel.getValueMap());
            this.setWidget(widget);
            JSplitPane jSplitPane = new JSplitPane(1, widget, new FlowPanel(this.getNode(), this.getFirstViewer(), this.showCodeBar()));
            jSplitPane.setDividerLocation(250);
            return jSplitPane;
        }
    }
}

