/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.node.base;

import com.ef_prime.rflow.core.app.r.base.R;
import com.ef_prime.rflow.core.app.r.base.RPackage;
import com.ef_prime.rflow.core.app.r.keyvalue.RStrKey;
import com.ef_prime.rflow.core.common.keyvalue.PanelWidgetNode;
import com.ef_prime.rflow.core.common.keyvalue.ValueMap;
import com.ef_prime.rflow.core.common.keyvalue.ViewOptions;
import com.ef_prime.rflow.core.common.keyvalue.WidgetNode;
import com.ef_prime.rflow.core.flow.FlowRunOption;
import com.ef_prime.rflow.core.flow.ViewLayout;
import com.ef_prime.rflow.core.util.ScriptBuilder;
import com.ef_prime.rflow.node.NodeModel;
import com.ef_prime.rflow.node.base.ClosedSubflowNodeModel;
import com.ef_prime.rflow.node.base.SubflowNodeModel;
import com.ef_prime.rflow.resource.Messages;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;

public class IfNodeModel
extends ClosedSubflowNodeModel {
    private static RStrKey CONDITION_KEY = ((RStrKey.Builder)((RStrKey.Builder)RStrKey.builder("condition", Messages.getString("Message.condition")).setEmptyMessage(Messages.getString("Message.eg") + " x > 10")).setRequired(true)).build();
    private Condition condition;

    public IfNodeModel() {
        super(2);
        this.condition = new Condition();
        this.condition.addEventHandler(this);
    }

    IfNodeModel(String string, ViewLayout[] viewLayoutArray) {
        super(viewLayoutArray);
        this.condition = new Condition();
        this.condition.putValue(CONDITION_KEY, string);
        this.condition.addEventHandler(this);
    }

    private IfNodeModel(IfNodeModel ifNodeModel, boolean bl) {
        super(ifNodeModel, bl);
        this.condition = (Condition)ifNodeModel.condition.copy();
        this.condition.addEventHandler(this);
    }

    @Override
    public String getDefaultTitle() {
        Object object = "if";
        if (this.getElseSubflowSet().isInOutConnected()) {
            object = (String)object + " else";
        }
        return object;
    }

    @Override
    public String getCommandImpl(boolean bl, FlowRunOption flowRunOption) {
        List<SubflowNodeModel.SubflowSet> list = this.getValidSubflowSets();
        ScriptBuilder scriptBuilder = new ScriptBuilder("\n");
        if (bl && this.isBreakpointEnabled()) {
            scriptBuilder.appendLn(R.client().getDebugCommand());
        }
        if (list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                if (i != list.size() - 1 || list.size() == 1) {
                    if (i > 0) {
                        scriptBuilder.append(" ");
                    }
                    scriptBuilder.appendLn("if (" + this.getConditionString() + ") {");
                    scriptBuilder.appendIndented(this.subflowSets[i].getCommand(bl, flowRunOption));
                    scriptBuilder.append("}");
                    if (list.size() == 1) continue;
                    scriptBuilder.append(" else ");
                    continue;
                }
                scriptBuilder.appendLn("{");
                scriptBuilder.appendIndented(this.subflowSets[i].getCommand(bl, flowRunOption));
                scriptBuilder.append("}");
            }
        } else {
            scriptBuilder.append("if (FALSE) {}");
        }
        return scriptBuilder.toString();
    }

    @Override
    public List<RPackage> getAutoPackageList() {
        return this.getInternalPackageList(true, false);
    }

    protected final List<RPackage> getInternalPackageList(boolean bl, boolean bl2) {
        ArrayList<RPackage> arrayList = new ArrayList<RPackage>();
        TreeMap<String, Boolean> treeMap = new TreeMap<String, Boolean>();
        List<SubflowNodeModel.SubflowSet> list = this.getValidSubflowSets();
        for (SubflowNodeModel.SubflowSet object : list) {
            for (RPackage rPackage : object.getInternalPackageList()) {
                String string = rPackage.getName();
                Boolean bl3 = rPackage.isAttach();
                if (treeMap.containsKey(string)) {
                    if (!bl3.booleanValue()) continue;
                    treeMap.remove(string);
                    treeMap.put(string, bl3);
                    continue;
                }
                treeMap.put(string, bl3);
            }
        }
        for (String string : treeMap.keySet()) {
            RPackage rPackage = new RPackage(string, true, (Boolean)treeMap.get(string));
            arrayList.add(rPackage);
        }
        return arrayList;
    }

    @Override
    public ValueMap getValueMap() {
        return this.condition;
    }

    public String getConditionString() {
        return this.condition.getValue(CONDITION_KEY);
    }

    private List<SubflowNodeModel.SubflowSet> getValidSubflowSets() {
        ArrayList<SubflowNodeModel.SubflowSet> arrayList = new ArrayList<SubflowNodeModel.SubflowSet>();
        for (int i = 0; i < this.subflowSets.length; ++i) {
            SubflowNodeModel.SubflowSet subflowSet = this.subflowSets[i];
            if (i != 0 && !subflowSet.isInOutConnected()) continue;
            arrayList.add(subflowSet);
        }
        return arrayList;
    }

    private SubflowNodeModel.SubflowSet getElseSubflowSet() {
        return this.subflowSets[this.subflowSets.length - 1];
    }

    @Override
    public NodeModel copy() {
        return new IfNodeModel(this, false);
    }

    @Override
    public NodeModel fullCopy() {
        return new IfNodeModel(this, true);
    }

    private static class Condition
    extends ValueMap {
        public Condition() {
            this.registerKeys(CONDITION_KEY);
        }

        @Override
        public WidgetNode getWidgetNode(ViewOptions viewOptions) {
            return new PanelWidgetNode().setNoScroll(true).addKeys(CONDITION_KEY);
        }

        @Override
        public boolean isValidationEnabled() {
            return true;
        }

        @Override
        public ValueMap copy() {
            Condition condition = new Condition();
            condition.copyValues(this);
            return condition;
        }
    }
}

