/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.node.base;

import com.ef_prime.rflow.core.common.util.Utility;
import com.ef_prime.rflow.core.flow.FlowEdge;
import com.ef_prime.rflow.core.flow.FlowGraph;
import com.ef_prime.rflow.core.flow.FlowLayout;
import com.ef_prime.rflow.core.flow.FlowNode;
import com.ef_prime.rflow.core.flow.ListViewLayout;
import com.ef_prime.rflow.core.flow.ViewLayout;
import com.ef_prime.rflow.node.NodeModel;
import com.ef_prime.rflow.node.base.SubflowNodeModel;
import com.ef_prime.rflow.ui.base.Icons;
import com.ef_prime.rflow.ui.flow.UndoableEditFactory;
import edu.uci.ics.jung.graph.Edge;
import edu.uci.ics.jung.graph.Vertex;
import java.awt.Dimension;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.swing.Icon;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.UndoableEditListener;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoableEditSupport;

public class ListNodeModel
extends SubflowNodeModel
implements ListModel<FlowNode> {
    private Queue<ListDataListener> listDataListeners = new ConcurrentLinkedQueue<ListDataListener>();
    private UndoableEditFactory undoableEditFactory;
    private UndoableEditSupport undoableEditSupport;

    public ListNodeModel() {
        super(1);
        this.getGraph().addEdge((Edge)new FlowEdge((Vertex)this.getIn(), (Vertex)this.getOut()));
    }

    ListNodeModel(ViewLayout viewLayout) {
        super(new ListViewLayout(viewLayout));
    }

    private ListNodeModel(ListNodeModel listNodeModel, boolean bl) {
        super(listNodeModel, bl);
    }

    private UndoableEditFactory getUndoableEditFactory() {
        if (this.undoableEditFactory == null) {
            this.undoableEditFactory = new UndoableEditFactory(this.getViewLayout(), null);
        }
        return this.undoableEditFactory;
    }

    private UndoableEditSupport getUndoableEditSupport() {
        if (this.undoableEditSupport == null) {
            this.undoableEditSupport = new UndoableEditSupport();
        }
        return this.undoableEditSupport;
    }

    @Override
    protected ViewLayout createDefaultViewLayout(FlowLayout flowLayout, Dimension dimension, Point point) {
        return new ListViewLayout(flowLayout, dimension, point);
    }

    @Override
    public String getDefaultTitle() {
        return "List";
    }

    @Override
    public Icon getSmallIcon() {
        return Icons.getIcon("16/text_list_bullets.png");
    }

    @Override
    public Icon getIcon() {
        return Icons.getIcon("32/text_list_bullets.png");
    }

    @Override
    public NodeModel copy() {
        return new ListNodeModel(this, false);
    }

    @Override
    public NodeModel fullCopy() {
        return new ListNodeModel(this, true);
    }

    public ViewLayout getViewLayout() {
        return this.getSubflowSet().getLayout();
    }

    private FlowGraph getGraph() {
        return this.getViewLayout().getGraph();
    }

    public void addNode(FlowNode flowNode, CompoundEdit compoundEdit) {
        this.addNode(this.getSize(), flowNode, compoundEdit);
    }

    public void addNode(int n, FlowNode flowNode, CompoundEdit compoundEdit) {
        FlowNode flowNode2 = this.getSize() == 0 || n >= this.getSize() ? this.getOut() : this.getElementAt(n);
        FlowNode flowNode3 = flowNode2.getPreviousNode();
        FlowEdge flowEdge = flowNode2.getInEdge();
        this.getViewLayout().getLayout().initLocation((Vertex)flowNode);
        this.getGraph().removeEdge((Edge)flowEdge);
        this.getGraph().addVertex((Vertex)flowNode);
        FlowEdge[] flowEdgeArray = new FlowEdge[]{(FlowEdge)this.getGraph().addEdge((Edge)new FlowEdge((Vertex)flowNode3, (Vertex)flowNode)), (FlowEdge)this.getGraph().addEdge((Edge)new FlowEdge((Vertex)flowNode, (Vertex)flowNode2))};
        if (compoundEdit != null) {
            UndoableEditFactory undoableEditFactory = this.getUndoableEditFactory();
            compoundEdit.addEdit(undoableEditFactory.createDeleteEdit(null, new FlowEdge[]{flowEdge}));
            compoundEdit.addEdit(undoableEditFactory.createAddNodeEdit(flowNode));
            compoundEdit.addEdit(undoableEditFactory.createAddEdgeEdit(flowEdgeArray));
        }
        this.fireIntervalAdded(n, n);
    }

    public void remove(int n, CompoundEdit compoundEdit) {
        FlowNode flowNode = this.getElementAt(n);
        FlowNode flowNode2 = flowNode.getPreviousNode();
        FlowNode flowNode3 = flowNode.getNextNode();
        Set set = (Set)Utility.cast(flowNode.getIncidentEdges());
        ArrayList arrayList = new ArrayList(set);
        this.getGraph().removeVertex((Vertex)flowNode);
        FlowEdge flowEdge = (FlowEdge)this.getGraph().addEdge((Edge)new FlowEdge((Vertex)flowNode2, (Vertex)flowNode3));
        if (compoundEdit != null) {
            UndoableEditFactory undoableEditFactory = this.getUndoableEditFactory();
            compoundEdit.addEdit(undoableEditFactory.createDeleteEdit(new FlowNode[]{flowNode}, arrayList.toArray(new FlowEdge[0])));
            compoundEdit.addEdit(undoableEditFactory.createAddEdgeEdit(new FlowEdge[]{flowEdge}));
        }
        this.fireIntervalRemoved(n, n);
    }

    @Override
    public int getSize() {
        return this.getGraph().getVertices().size() - 2;
    }

    @Override
    public FlowNode getElementAt(int n) {
        FlowNode flowNode = this.getIn();
        for (int i = 0; i < n + 1; ++i) {
            if ((flowNode = flowNode.getNextNode()) != null) continue;
            throw new IndexOutOfBoundsException();
        }
        return flowNode;
    }

    @Override
    public String getTypeID() {
        return "com.ef_prime.rflow.node.base.SubflowNodeModel";
    }

    @Override
    public void addListDataListener(ListDataListener listDataListener) {
        this.listDataListeners.add(listDataListener);
    }

    @Override
    public void removeListDataListener(ListDataListener listDataListener) {
        this.listDataListeners.remove(listDataListener);
    }

    public void fireContentsChanged() {
        this.fireContentsChanged(0, this.getSize() - 1);
    }

    public void fireContentsChanged(int n, int n2) {
        ListDataEvent listDataEvent = new ListDataEvent(this, 0, n, n2);
        for (ListDataListener listDataListener : this.listDataListeners) {
            listDataListener.contentsChanged(listDataEvent);
        }
    }

    private void fireIntervalAdded(int n, int n2) {
        ListDataEvent listDataEvent = new ListDataEvent(this, 1, n, n2);
        for (ListDataListener listDataListener : this.listDataListeners) {
            listDataListener.intervalAdded(listDataEvent);
        }
    }

    private void fireIntervalRemoved(int n, int n2) {
        ListDataEvent listDataEvent = new ListDataEvent(this, 2, n, n2);
        for (ListDataListener listDataListener : this.listDataListeners) {
            listDataListener.intervalRemoved(listDataEvent);
        }
    }

    public void addUndoableEditListener(UndoableEditListener undoableEditListener) {
        this.getUndoableEditSupport().addUndoableEditListener(undoableEditListener);
    }

    public void removeUndoableEditListener(UndoableEditListener undoableEditListener) {
        this.getUndoableEditSupport().removeUndoableEditListener(undoableEditListener);
    }

    public void beginUpdate() {
        this.getUndoableEditSupport().beginUpdate();
    }

    public void endUpdate() {
        this.getUndoableEditSupport().endUpdate();
    }
}

