/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.node.base;

import com.ef_prime.rflow.core.feature.history.FlowNodeFlavor;
import com.ef_prime.rflow.core.feature.history.FlowNodeTransferable;
import com.ef_prime.rflow.core.flow.FlowNode;
import com.ef_prime.rflow.node.base.ListNodeModel;
import com.ef_prime.rflow.resource.Messages;
import com.ef_prime.rflow.ui.common.component.Actions;
import com.ef_prime.rflow.ui.common.component.FlatSplitPane;
import com.ef_prime.rflow.ui.common.component.LoggableAction;
import com.ef_prime.rflow.ui.common.component.NamedCompoundEdit;
import com.ef_prime.rflow.ui.common.event.EventSupport;
import com.ef_prime.rflow.ui.common.item.Item;
import com.ef_prime.rflow.ui.common.item.ItemSelectable;
import com.ef_prime.rflow.ui.common.item.ItemSelectionEvent;
import com.ef_prime.rflow.ui.common.item.ItemSelectionEventHandler;
import com.ef_prime.rflow.ui.flow.FlowNodeView;
import com.ef_prime.rflow.ui.flow.FlowUndoManager;
import com.ef_prime.rflow.ui.flow.FlowViewer;
import com.ef_prime.rflow.ui.util.PlatformUtility;
import com.ef_prime.rflow.ui.util.UIUtility;
import com.ef_prime.rflow.ui.view.ListNodePreviewView;
import java.awt.Component;
import java.awt.Font;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.DropMode;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.TransferHandler;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.commons.lang3.ArrayUtils;
import org.pushingpixels.substance.api.renderers.SubstanceDefaultListCellRenderer;

public class ListNodeView
extends FlowNodeView
implements ItemSelectable,
ListSelectionListener {
    private JList<FlowNode> list;
    private ListActions actions;
    private ListNodePreviewView previewView;
    private EventSupport<ItemSelectionEvent, ItemSelectionEventHandler> eventSupport = new EventSupport();

    public ListNodeView(FlowNode flowNode, boolean bl) {
        super(flowNode, bl);
    }

    private ListNodeModel getModel() {
        return (ListNodeModel)this.getNode().getModel();
    }

    private FlowUndoManager getUndoManager() {
        return this.getModel().getViewLayout().getUndoManager();
    }

    public JList<FlowNode> getList() {
        return this.list;
    }

    @Override
    protected Component createCenterView() {
        ListNodeModel listNodeModel = this.getModel();
        this.list = new JList<FlowNode>(listNodeModel);
        this.list.setFont(new Font("Monospaced", 0, this.list.getFont().getSize()));
        this.list.setCellRenderer((ListCellRenderer<FlowNode>)((Object)new ListRenderer()));
        this.list.addListSelectionListener(this);
        this.list.addMouseListener(new MouseHandler());
        this.list.setDragEnabled(true);
        this.list.setDropMode(DropMode.INSERT);
        this.list.setTransferHandler(new NodeTransferHandler());
        this.actions = new ListActions();
        this.actions.installActions(this.list, false, 1);
        JScrollPane jScrollPane = new JScrollPane(this.list);
        if (this.isPreview()) {
            return jScrollPane;
        }
        this.previewView = new ListNodePreviewView(this);
        return new FlatSplitPane(jScrollPane, (Component)this.previewView, 200);
    }

    @Override
    protected boolean isToolBar() {
        return false;
    }

    @Override
    public final FlowViewer getActiveViewer() {
        if (this.previewView != null) {
            return this.previewView.getActiveViewer();
        }
        return null;
    }

    private JPopupMenu createPopup() {
        this.actions.get(ListActions.Undo.class).setEnabled(this.getUndoManager().canUndo());
        this.actions.get(ListActions.Redo.class).setEnabled(this.getUndoManager().canRedo());
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add(this.actions.get(ListActions.Remove.class));
        jPopupMenu.addSeparator();
        jPopupMenu.add(this.actions.get(ListActions.Undo.class));
        jPopupMenu.add(this.actions.get(ListActions.Redo.class));
        return jPopupMenu;
    }

    protected void open() {
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        this.eventSupport.dispatchEvent(new ItemSelectionEvent(this.getSelectedItem(), false, false));
    }

    @Override
    public Item getSelectedItem() {
        List<FlowNode> list = this.list.getSelectedValuesList();
        if (list.isEmpty()) {
            return null;
        }
        return new FlowNodeTransferable(list);
    }

    @Override
    public void addItemEventHandler(ItemSelectionEventHandler itemSelectionEventHandler) {
        this.eventSupport.addEventHandler(itemSelectionEventHandler);
    }

    @Override
    public void removeItemEventHandler(ItemSelectionEventHandler itemSelectionEventHandler) {
        this.eventSupport.removeEventHandler(itemSelectionEventHandler);
    }

    private static class ListRenderer
    extends SubstanceDefaultListCellRenderer {
        private ListRenderer() {
        }

        public Component getListCellRendererComponent(JList<?> jList, Object object, int n, boolean bl, boolean bl2) {
            super.getListCellRendererComponent(jList, object, n, bl, bl2);
            FlowNode flowNode = (FlowNode)object;
            if (flowNode != null) {
                this.setText(flowNode.getTitle());
                this.setIcon(flowNode.getSmallIcon());
            }
            return this;
        }
    }

    private class MouseHandler
    extends MouseAdapter {
        private MouseHandler() {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            int n;
            int n2 = ListNodeView.this.list.locationToIndex(mouseEvent.getPoint());
            int[] nArray = ListNodeView.this.list.getSelectedIndices();
            if (nArray == null) {
                nArray = ArrayUtils.EMPTY_INT_ARRAY;
            }
            if ((n = Arrays.binarySearch(nArray, n2)) < 0) {
                ListNodeView.this.list.setSelectedIndex(n2);
            }
            if (UIUtility.isRightMouseButton(mouseEvent)) {
                ListNodeView.this.createPopup().show(ListNodeView.this.list, mouseEvent.getPoint().x, mouseEvent.getPoint().y);
            } else if (UIUtility.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() == 2) {
                ListNodeView.this.open();
            }
        }
    }

    private class NodeTransferHandler
    extends TransferHandler {
        private int[] draggedIndices = null;
        private boolean internalTransfer;

        private NodeTransferHandler() {
        }

        @Override
        public int getSourceActions(JComponent jComponent) {
            return 3;
        }

        @Override
        protected Transferable createTransferable(JComponent jComponent) {
            JList jList = (JList)jComponent;
            this.draggedIndices = jList.getSelectedIndices();
            if (ArrayUtils.isEmpty((int[])this.draggedIndices)) {
                this.draggedIndices = null;
                return null;
            }
            ArrayList<FlowNode> arrayList = new ArrayList<FlowNode>(this.draggedIndices.length);
            for (int i = 0; i < this.draggedIndices.length; ++i) {
                arrayList.add((FlowNode)jList.getModel().getElementAt(this.draggedIndices[i]));
            }
            return new FlowNodeTransferable(arrayList);
        }

        @Override
        protected void exportDone(JComponent jComponent, Transferable transferable, int n) {
            if (this.internalTransfer) {
                // empty if block
            }
            this.draggedIndices = null;
            this.internalTransfer = false;
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport transferSupport) {
            if (!transferSupport.isDrop()) {
                return false;
            }
            if (!transferSupport.isDataFlavorSupported(FlowNodeFlavor.getInstance())) {
                return false;
            }
            List<FlowNode> list = FlowNodeFlavor.getFlowNodes(transferSupport.getTransferable());
            return list != null;
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport transferSupport) {
            int n;
            List<FlowNode> list;
            if (!this.canImport(transferSupport)) {
                return false;
            }
            boolean bl = (transferSupport.getDropAction() & 2) == 2;
            JList jList = (JList)transferSupport.getComponent();
            List<FlowNode> list2 = list = bl ? FlowNodeFlavor.getFlowNodes(transferSupport.getTransferable()) : FlowNodeFlavor.getFlowNodesCopied(transferSupport.getTransferable());
            if (list == null) {
                return false;
            }
            JList.DropLocation dropLocation = (JList.DropLocation)transferSupport.getDropLocation();
            int n2 = dropLocation.getIndex();
            if (n2 < 0 || n2 > jList.getModel().getSize()) {
                n2 = jList.getModel().getSize();
            }
            NamedCompoundEdit namedCompoundEdit = new NamedCompoundEdit("Move");
            if (bl && this.draggedIndices != null) {
                int n3 = 0;
                for (n = this.draggedIndices.length - 1; n >= 0; --n) {
                    ListNodeView.this.getModel().remove(this.draggedIndices[n], namedCompoundEdit);
                    if (this.draggedIndices[n] > n2) continue;
                    ++n3;
                }
                n2 -= n3;
                this.internalTransfer = true;
            }
            ListNodeModel listNodeModel = ListNodeView.this.getModel();
            for (n = list.size() - 1; n >= 0; --n) {
                listNodeModel.addNode(n2, list.get(n), namedCompoundEdit);
            }
            jList.setSelectionInterval(n2, n2 + list.size() - 1);
            namedCompoundEdit.end();
            ListNodeView.this.getUndoManager().addEdit(namedCompoundEdit);
            return true;
        }
    }

    private class ListActions
    extends Actions {
        public ListActions() {
            this.put(new Remove());
            this.put(new Undo());
            this.put(new Redo());
        }

        private class Remove
        extends LoggableAction {
            public Remove() {
                this.putValue("Name", Messages.getString("Action.remove"));
                this.putValue("AcceleratorKey", PlatformUtility.getDeleteKeyStroke());
            }

            @Override
            public void action(ActionEvent actionEvent) {
                int[] nArray = ListNodeView.this.list.getSelectedIndices();
                if (ArrayUtils.isEmpty((int[])nArray)) {
                    return;
                }
                NamedCompoundEdit namedCompoundEdit = new NamedCompoundEdit((String)this.getValue("Name"));
                for (int i = nArray.length - 1; i >= 0; --i) {
                    ListNodeView.this.getModel().remove(nArray[i], namedCompoundEdit);
                }
                namedCompoundEdit.end();
                ListNodeView.this.getUndoManager().addEdit(namedCompoundEdit);
            }
        }

        private class Undo
        extends LoggableAction {
            public Undo() {
                this.putValue("Name", Messages.getString("Action.undo"));
            }

            @Override
            public void action(ActionEvent actionEvent) {
                if (ListNodeView.this.getUndoManager().canUndo()) {
                    ListNodeView.this.getUndoManager().undo();
                    ListNodeView.this.getModel().fireContentsChanged();
                }
            }
        }

        private class Redo
        extends LoggableAction {
            public Redo() {
                this.putValue("Name", Messages.getString("Action.redo"));
            }

            @Override
            public void action(ActionEvent actionEvent) {
                if (ListNodeView.this.getUndoManager().canRedo()) {
                    ListNodeView.this.getUndoManager().redo();
                    ListNodeView.this.getModel().fireContentsChanged();
                }
            }
        }
    }
}

