/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.node.base;

import com.ef_prime.rflow.core.app.r.base.R;
import com.ef_prime.rflow.core.app.r.keyvalue.RStrKey;
import com.ef_prime.rflow.core.common.keyvalue.PanelWidgetNode;
import com.ef_prime.rflow.core.common.keyvalue.ValueMap;
import com.ef_prime.rflow.core.common.keyvalue.ViewOptions;
import com.ef_prime.rflow.core.common.keyvalue.WidgetNode;
import com.ef_prime.rflow.core.flow.FlowRunOption;
import com.ef_prime.rflow.core.flow.ViewLayout;
import com.ef_prime.rflow.core.util.ScriptBuilder;
import com.ef_prime.rflow.node.NodeModel;
import com.ef_prime.rflow.node.base.ClosedSubflowNodeModel;
import com.ef_prime.rflow.node.base.LoopType;
import com.ef_prime.rflow.resource.Messages;

public class LoopNodeModel
extends ClosedSubflowNodeModel {
    private static final RStrKey CONDITION_KEY = ((RStrKey.Builder)((RStrKey.Builder)RStrKey.builder("condition", Messages.getString("Message.condition")).setEmptyMessage(Messages.getString("Message.eg") + " i < 10")).setRequired(true)).build();
    private LoopType loopType;
    private Condition condition;

    public LoopNodeModel(LoopType loopType) {
        this.init(loopType);
    }

    LoopNodeModel(LoopType loopType, String string, ViewLayout viewLayout) {
        super(viewLayout);
        this.init(loopType);
        if (loopType.isCondition()) {
            this.condition.putValue(CONDITION_KEY, string);
        }
    }

    private LoopNodeModel(LoopNodeModel loopNodeModel, boolean bl) {
        super(loopNodeModel, bl);
        this.loopType = loopNodeModel.loopType;
        this.condition = (Condition)loopNodeModel.condition.copy();
        this.condition.addEventHandler(this);
    }

    private void init(LoopType loopType) {
        this.loopType = loopType;
        this.condition = new Condition();
        this.condition.addEventHandler(this);
    }

    public LoopType getLoopType() {
        return this.loopType;
    }

    public String getConditionString() {
        return this.condition.getValue(CONDITION_KEY);
    }

    @Override
    public ValueMap getValueMap() {
        return this.condition;
    }

    @Override
    public String getCommandImpl(boolean bl, FlowRunOption flowRunOption) {
        ScriptBuilder scriptBuilder = new ScriptBuilder("\n");
        if (bl && this.isBreakpointEnabled()) {
            scriptBuilder.appendLn(R.client().getDebugCommand());
        }
        if (this.getLoopType().isCondition()) {
            scriptBuilder.appendLn(this.getLoopType().getCode() + " (" + this.getConditionString() + ") {");
        } else {
            scriptBuilder.appendLn(this.getLoopType().getCode() + " {");
        }
        scriptBuilder.appendIndented(this.getFlowCommand(bl, flowRunOption));
        scriptBuilder.append("}");
        return scriptBuilder.toString();
    }

    @Override
    public String getDefaultTitle() {
        return this.getLoopType().getCode();
    }

    @Override
    public NodeModel copy() {
        return new LoopNodeModel(this, false);
    }

    @Override
    public NodeModel fullCopy() {
        return new LoopNodeModel(this, true);
    }

    private static class Condition
    extends ValueMap {
        public Condition() {
            this.registerKeys(CONDITION_KEY);
        }

        @Override
        public WidgetNode getWidgetNode(ViewOptions viewOptions) {
            return PanelWidgetNode.noScroll().addKeys(CONDITION_KEY);
        }

        @Override
        public boolean isValidationEnabled() {
            return true;
        }

        @Override
        public ValueMap copy() {
            Condition condition = new Condition();
            condition.copyValues(this);
            return condition;
        }
    }
}

