/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.node.base;

import com.ef_prime.rflow.core.flow.FlowNode;
import com.ef_prime.rflow.core.flow.ViewLayout;
import com.ef_prime.rflow.node.ModelCreationFailedException;
import com.ef_prime.rflow.node.NodeModel;
import com.ef_prime.rflow.node.NodeModelManager;
import com.ef_prime.rflow.node.base.ClosedSubflowNodeView;
import com.ef_prime.rflow.node.base.ForNodeModel;
import com.ef_prime.rflow.node.base.LoopNodeModel;
import com.ef_prime.rflow.node.base.LoopType;
import com.ef_prime.rflow.node.base.SubflowNodeModelController;
import com.ef_prime.rflow.ui.common.keyvalue.Widget;
import com.ef_prime.rflow.ui.common.keyvalue.WidgetFactory;
import com.ef_prime.rflow.ui.flow.FlowNodeView;
import com.ef_prime.rflow.ui.flow.FlowPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Properties;
import javax.swing.JPanel;
import org.w3c.dom.Element;

public class LoopNodeModelController
extends SubflowNodeModelController {
    @Override
    public Class<? extends NodeModel> getModelClass() {
        return LoopNodeModel.class;
    }

    @Override
    public Properties getOptionProperties(NodeModel nodeModel) {
        LoopNodeModel loopNodeModel = (LoopNodeModel)nodeModel;
        Properties properties = new Properties();
        properties.setProperty("loop", loopNodeModel.getLoopType().getCode());
        if (loopNodeModel.getLoopType().isCondition()) {
            properties.setProperty("condition", loopNodeModel.getConditionString());
        }
        return properties;
    }

    @Override
    public NodeModel createModel(Properties properties, Element element, String string, ViewLayout[] viewLayoutArray) throws ModelCreationFailedException {
        LoopType loopType = LoopType.toLoopType(properties.getProperty("loop"));
        if (loopType == LoopType.FOR) {
            return NodeModelManager.getModelController(ForNodeModel.class).createModel(properties, element, string, viewLayoutArray);
        }
        String string2 = properties.getProperty("condition");
        if (viewLayoutArray.length < 1 || loopType == null || loopType.isCondition() && string2 == null) {
            throw new ModelCreationFailedException();
        }
        return new LoopNodeModel(loopType, string2, viewLayoutArray[0]);
    }

    @Override
    public FlowNodeView createView(FlowNode flowNode, boolean bl) {
        return new LoopView(flowNode, bl);
    }

    private static class LoopView
    extends ClosedSubflowNodeView {
        public LoopView(FlowNode flowNode, boolean bl) {
            super(flowNode, bl);
        }

        @Override
        protected boolean getTabIconOnly() {
            return false;
        }

        @Override
        protected String getTabTitle() {
            LoopNodeModel loopNodeModel = (LoopNodeModel)this.getNode().getModel();
            return loopNodeModel.getLoopType().getCode();
        }

        @Override
        protected Component createSubflowView() {
            JPanel jPanel = new JPanel(new BorderLayout());
            LoopNodeModel loopNodeModel = (LoopNodeModel)this.getNode().getModel();
            if (loopNodeModel.getLoopType().isCondition()) {
                Widget widget = (Widget)WidgetFactory.getInstance().create(loopNodeModel.getValueMap());
                this.setWidget(widget);
                jPanel.add((Component)widget, "North");
            }
            jPanel.add((Component)new FlowPanel(this.getNode(), this.getFirstViewer(), this.showCodeBar()), "Center");
            return jPanel;
        }
    }
}

