/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.node.base;

import com.ef_prime.rflow.core.app.r.base.RPackage;
import com.ef_prime.rflow.core.app.r.console.Executor;
import com.ef_prime.rflow.core.base.FileResource;
import com.ef_prime.rflow.core.flow.FlowEdge;
import com.ef_prime.rflow.core.flow.FlowGraph;
import com.ef_prime.rflow.core.flow.FlowLayout;
import com.ef_prime.rflow.core.flow.FlowNode;
import com.ef_prime.rflow.core.flow.FlowRunOption;
import com.ef_prime.rflow.core.flow.FlowUtil;
import com.ef_prime.rflow.core.flow.ViewLayout;
import com.ef_prime.rflow.node.NodeModel;
import com.ef_prime.rflow.node.NodeModelEvent;
import com.ef_prime.rflow.node.NodeModelEventHandler;
import com.ef_prime.rflow.node.base.TunnelNodeModel;
import com.ef_prime.rflow.resource.Messages;
import edu.uci.ics.jung.graph.Edge;
import edu.uci.ics.jung.graph.Vertex;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import javax.swing.Icon;

public class SubflowNodeModel
extends NodeModel {
    protected SubflowSet[] subflowSets;
    private static Rectangle shapeRect = new Rectangle(-16, -16, 32, 32);

    public SubflowNodeModel() {
        this(1);
    }

    protected SubflowNodeModel(int n) {
        this.subflowSets = new SubflowSet[n];
        for (int i = 0; i < n; ++i) {
            SubflowSet subflowSet = new SubflowSet();
            subflowSet.in = new FlowNode(TunnelNodeModel.inModel);
            subflowSet.out = new FlowNode(TunnelNodeModel.outModel);
            FlowGraph flowGraph = new FlowGraph();
            flowGraph.addVertex((Vertex)subflowSet.in);
            flowGraph.addVertex((Vertex)subflowSet.out);
            FlowLayout flowLayout = new FlowLayout(flowGraph);
            flowLayout.addVertex((Vertex)subflowSet.in, 50.0, 100.0);
            flowLayout.addVertex((Vertex)subflowSet.out, 450.0, 100.0);
            subflowSet.layout = this.createDefaultViewLayout(flowLayout, new Dimension(300, 200), new Point(0, 0));
            this.subflowSets[i] = subflowSet;
        }
        this.init();
    }

    public SubflowNodeModel(ViewLayout viewLayout, FlowNode[] flowNodeArray, FlowNode flowNode) {
        this.subflowSets = new SubflowSet[]{new SubflowSet()};
        SubflowSet subflowSet = this.getSubflowSet();
        subflowSet.layout = viewLayout;
        subflowSet.in = (FlowNode)viewLayout.getGraph().addVertex((Vertex)new FlowNode(TunnelNodeModel.inModel));
        subflowSet.out = (FlowNode)viewLayout.getGraph().addVertex((Vertex)new FlowNode(TunnelNodeModel.outModel));
        int n = 80;
        FlowNode flowNode2 = flowNodeArray[0];
        Point2D point2D = viewLayout.getLocation((Vertex)flowNode2);
        viewLayout.getLayout().addVertex((Vertex)subflowSet.in, point2D.getX() - (double)n, point2D.getY());
        for (FlowNode flowNode3 : flowNodeArray) {
            viewLayout.getGraph().addEdge((Edge)new FlowEdge((Vertex)subflowSet.in, (Vertex)flowNode3));
        }
        viewLayout.getGraph().addEdge((Edge)new FlowEdge((Vertex)flowNode, (Vertex)subflowSet.out));
        Point2D point2D2 = viewLayout.getLocation((Vertex)flowNode);
        viewLayout.getLayout().addVertex((Vertex)subflowSet.out, point2D2.getX() + (double)n, point2D2.getY());
        this.init();
    }

    public SubflowNodeModel(ViewLayout viewLayout) {
        this(new ViewLayout[]{viewLayout});
    }

    public SubflowNodeModel(ViewLayout[] viewLayoutArray) {
        this.subflowSets = new SubflowSet[viewLayoutArray.length];
        for (int i = 0; i < viewLayoutArray.length; ++i) {
            this.subflowSets[i] = new SubflowSet();
            this.subflowSets[i].layout = viewLayoutArray[i];
        }
        this.setInOutNode();
        this.init();
    }

    SubflowNodeModel(SubflowNodeModel subflowNodeModel, boolean bl) {
        super(subflowNodeModel);
        this.subflowSets = new SubflowSet[subflowNodeModel.subflowSets.length];
        for (int i = 0; i < this.subflowSets.length; ++i) {
            this.subflowSets[i] = new SubflowSet();
            ViewLayout viewLayout = subflowNodeModel.subflowSets[i].getLayout();
            this.subflowSets[i].layout = bl ? viewLayout.fullCopy() : viewLayout.copy();
        }
        this.setInOutNode();
        this.init();
    }

    private void init() {
        SubflowNodeModelHandler subflowNodeModelHandler = new SubflowNodeModelHandler();
        for (SubflowSet subflowSet : this.subflowSets) {
            subflowSet.getGraph().addNodeModelEventHandler(subflowNodeModelHandler);
        }
    }

    protected ViewLayout createDefaultViewLayout(FlowLayout flowLayout, Dimension dimension, Point point) {
        return new ViewLayout(flowLayout, dimension, point);
    }

    protected SubflowSet getSubflowSet() {
        return this.subflowSets[0];
    }

    public SubflowSet[] getSubflowSets() {
        return this.subflowSets;
    }

    private void setInOutNode() {
        block0: for (SubflowSet subflowSet : this.subflowSets) {
            boolean bl = false;
            boolean bl2 = false;
            for (Object e : subflowSet.getGraph().getVertices()) {
                FlowNode flowNode = (FlowNode)e;
                if (!bl && flowNode.getModel() == TunnelNodeModel.inModel) {
                    subflowSet.in = flowNode;
                    bl = true;
                }
                if (!bl2 && flowNode.getModel() == TunnelNodeModel.outModel) {
                    subflowSet.out = flowNode;
                    bl2 = true;
                }
                if (!bl || !bl2) continue;
                continue block0;
            }
        }
    }

    @Override
    public List<RPackage> getAutoPackageList() {
        return this.getSubflowSet().getInternalPackageList();
    }

    @Override
    public String getDefaultTitle() {
        return Messages.getString("Node.box.default");
    }

    @Override
    public String getCommandImpl(boolean bl, FlowRunOption flowRunOption) {
        return this.getFlowCommand(bl, flowRunOption);
    }

    protected String getFlowCommand(boolean bl, FlowRunOption flowRunOption) {
        return this.getSubflowSet().getCommand(bl, flowRunOption);
    }

    @Override
    public boolean isAnyEnabledBreakpoint() {
        if (this.isOpenSubflow()) {
            return super.isAnyEnabledBreakpoint();
        }
        if (this.isBreakpointEnabled()) {
            return true;
        }
        for (List<FlowNode> list : this.getFlows()) {
            for (FlowNode flowNode : list) {
                if (!flowNode.getModel().isAnyEnabledBreakpoint()) continue;
                return true;
            }
        }
        return false;
    }

    private List<List<FlowNode>> getFlows() {
        ArrayList<List<FlowNode>> arrayList = new ArrayList<List<FlowNode>>();
        for (SubflowSet subflowSet : this.subflowSets) {
            arrayList.add(subflowSet.getFlow());
        }
        return arrayList;
    }

    public FlowNode getIn() {
        return this.getSubflowSet().in;
    }

    public FlowNode getOut() {
        return this.getSubflowSet().out;
    }

    public FlowNode getParentNode() {
        return this.getSubflowSet().getGraph().getParentNode();
    }

    public void setParentNode(FlowNode flowNode) {
        for (SubflowSet subflowSet : this.subflowSets) {
            subflowSet.getGraph().setParentNode(flowNode);
        }
    }

    public boolean isInOutConnected() {
        return this.getSubflowSet().isInOutConnected();
    }

    public boolean isInConnected() {
        return this.getSubflowSet().isInConnected();
    }

    public boolean isOutConnected() {
        return this.getSubflowSet().isOutConnected();
    }

    @Override
    public NodeModel copy() {
        return new SubflowNodeModel(this, false);
    }

    @Override
    public NodeModel fullCopy() {
        return new SubflowNodeModel(this, true);
    }

    public FlowGraph[] getGraphs() {
        FlowGraph[] flowGraphArray = new FlowGraph[this.subflowSets.length];
        for (int i = 0; i < flowGraphArray.length; ++i) {
            flowGraphArray[i] = this.subflowSets[i].getGraph();
        }
        return flowGraphArray;
    }

    public ViewLayout[] getLayouts() {
        ViewLayout[] viewLayoutArray = new ViewLayout[this.subflowSets.length];
        for (int i = 0; i < viewLayoutArray.length; ++i) {
            viewLayoutArray[i] = this.subflowSets[i].getLayout();
        }
        return viewLayoutArray;
    }

    @Override
    public Shape getShape() {
        return shapeRect;
    }

    @Override
    public Icon getIcon() {
        return FileResource.getIcon("img/node/box.png");
    }

    @Override
    public Icon getSmallIcon() {
        return FileResource.getIcon("img/node/box.png", 16);
    }

    @Override
    public boolean isSubflow() {
        return true;
    }

    @Override
    public boolean isOpenSubflow() {
        return true;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object object) {
        return false;
    }

    public static class SubflowSet {
        private ViewLayout layout;
        FlowNode in;
        FlowNode out;

        public FlowGraph getGraph() {
            return this.layout.getGraph();
        }

        protected final List<RPackage> getInternalPackageList() {
            ArrayList<RPackage> arrayList = new ArrayList<RPackage>();
            if (this.isInOutConnected()) {
                Object object;
                TreeMap<String, Boolean> treeMap = new TreeMap<String, Boolean>();
                ArrayDeque<NodeModel> arrayDeque = new ArrayDeque<NodeModel>();
                for (Iterator iterator = this.out.getPreviousNode(); iterator != this.in; iterator = ((FlowNode)((Object)iterator)).getPreviousNode()) {
                    NodeModel object2 = ((FlowNode)((Object)iterator)).getModel();
                    if (object2 == null) continue;
                    arrayDeque.push(object2);
                }
                for (NodeModel nodeModel : arrayDeque) {
                    object = new ArrayList<RPackage>();
                    object.addAll(nodeModel.getAutoPackageList());
                    Iterator iterator = object.iterator();
                    while (iterator.hasNext()) {
                        RPackage rPackage = (RPackage)iterator.next();
                        String string = rPackage.getName();
                        Boolean bl = rPackage.isAttach();
                        if (treeMap.containsKey(string)) {
                            if (!bl.booleanValue()) continue;
                            treeMap.remove(string);
                            treeMap.put(string, bl);
                            continue;
                        }
                        treeMap.put(string, bl);
                    }
                }
                for (String string : treeMap.keySet()) {
                    object = new RPackage(string, true, (Boolean)treeMap.get(string));
                    arrayList.add((RPackage)object);
                }
            }
            return arrayList;
        }

        public ViewLayout getLayout() {
            return this.layout;
        }

        public List<FlowNode> getFlow() {
            return FlowUtil.getStreamSimple(this.out);
        }

        public String getCommand(boolean bl, FlowRunOption flowRunOption) {
            if (!this.isInOutConnected()) {
                return "";
            }
            FlowNode flowNode = this.out.getPreviousNode();
            FlowRunOption flowRunOption2 = new FlowRunOption().setExcludeDebugScript(!bl).setDontSplitCommand(true).setInsideBoxMode(true).setInsertNewLine(true);
            if (flowRunOption != null) {
                flowRunOption2.setIncludeComment(flowRunOption.isIncludeComment()).setIncludeTitle(flowRunOption.isIncludeTitle());
            }
            return Executor.getScriptExecutor().getScript(flowNode, this.in, flowRunOption2);
        }

        public boolean isInOutConnected() {
            for (FlowNode flowNode : this.getFlow()) {
                SubflowNodeModel subflowNodeModel;
                if (!flowNode.getModel().isSubflow() || (subflowNodeModel = (SubflowNodeModel)flowNode.getModel()).isInOutConnected()) continue;
                return false;
            }
            return FlowUtil.isHeadInNode(this.out);
        }

        public boolean isInConnected() {
            return this.in.outDegree() > 0;
        }

        public boolean isOutConnected() {
            return this.out.inDegree() > 0;
        }
    }

    private class SubflowNodeModelHandler
    implements NodeModelEventHandler {
        private SubflowNodeModelHandler() {
        }

        @Override
        public void nodeModelChanged(NodeModelEvent nodeModelEvent) {
            SubflowNodeModel.this.fireNodeModelEvent();
        }
    }
}

