/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.node.base;

import com.ef_prime.rflow.core.base.FileResource;
import com.ef_prime.rflow.core.flow.FlowModel;
import com.ef_prime.rflow.core.flow.FlowNode;
import com.ef_prime.rflow.core.flow.FlowSegment;
import com.ef_prime.rflow.core.flow.FlowUtil;
import com.ef_prime.rflow.core.flow.ViewLayout;
import com.ef_prime.rflow.node.NodeModelChangeListener;
import com.ef_prime.rflow.node.base.SubflowNodeModel;
import com.ef_prime.rflow.resource.Messages;
import com.ef_prime.rflow.ui.app.r.RMultiNodesScriptView;
import com.ef_prime.rflow.ui.base.Icons;
import com.ef_prime.rflow.ui.base.MenuActionProvider;
import com.ef_prime.rflow.ui.common.view.ViewOpenType;
import com.ef_prime.rflow.ui.common.view.ViewTabbedPane;
import com.ef_prime.rflow.ui.flow.FlowNodeView;
import com.ef_prime.rflow.ui.flow.FlowPanel;
import com.ef_prime.rflow.ui.flow.FlowViewer;
import com.google.common.collect.Sets;
import edu.uci.ics.jung.visualization.transform.MutableTransformer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.image.BufferedImage;
import java.util.HashSet;
import java.util.Optional;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JToolBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SubflowNodeView
extends FlowNodeView
implements NodeModelChangeListener,
MenuActionProvider {
    private static final Icon RUN_BOX_ICON;
    private FlowViewer[] viewers;
    private ViewerListener[] listeners;
    private int activeViewerIndex = 0;
    private JToolBar[] toolBars;
    private RMultiNodesScriptView scriptView;

    public SubflowNodeView(FlowNode flowNode, boolean bl) {
        super(flowNode, bl);
    }

    @Override
    public String getTitle() {
        if (!this.getNode().isRootNode()) {
            return super.getTitle();
        }
        StringBuilder stringBuilder = new StringBuilder();
        Optional<FlowModel> optional = this.getFlowModel();
        if (optional.isPresent() && optional.get().isDirty()) {
            stringBuilder.append("*");
        }
        stringBuilder.append(this.getNode().getTitle());
        return stringBuilder.toString();
    }

    @Override
    protected Icon getTabIcon() {
        return FileResource.getIcon("img/node/box.png", 16);
    }

    @Override
    protected Component createCenterView() {
        SubflowNodeModel subflowNodeModel = (SubflowNodeModel)this.getNode().getModel();
        SubflowNodeModel.SubflowSet[] subflowSetArray = subflowNodeModel.getSubflowSets();
        this.viewers = new FlowViewer[subflowSetArray.length];
        this.listeners = new ViewerListener[this.viewers.length];
        for (int i = 0; i < subflowSetArray.length; ++i) {
            SubflowNodeModel.SubflowSet subflowSet = subflowSetArray[i];
            Optional<FlowModel> optional = this.getFlowModel();
            if (!optional.isPresent()) {
                throw new RuntimeException("The node doesn't belong to a FlowModel");
            }
            FlowViewer flowViewer = new FlowViewer(optional.get());
            flowViewer.loadModel(subflowSet.getLayout());
            flowViewer.setPreferredSize(subflowSet.getLayout().getSize());
            this.viewers[i] = flowViewer;
            this.listeners[i] = new ViewerListener(subflowSet.getLayout());
        }
        Component component = this.createSubflowView();
        return component;
    }

    @Override
    protected Component createCenterTabbedPane(Component component) {
        Component component2 = super.createCenterTabbedPane(component);
        if (component2 instanceof ViewTabbedPane) {
            HashSet hashSet = Sets.newHashSet((Object[])new FlowNode[]{this.getNode()});
            FlowSegment flowSegment = FlowUtil.getFlowSegment(hashSet);
            ViewTabbedPane viewTabbedPane = (ViewTabbedPane)component2;
            this.scriptView = new RMultiNodesScriptView(hashSet, flowSegment, false);
            viewTabbedPane.openView(this.scriptView, ViewOpenType.OPEN_NEW, false, viewTabbedPane.getTabCount() - 1);
        }
        return component2;
    }

    @Override
    protected boolean isToolBar() {
        return true;
    }

    @Override
    protected void configureToolBar(JToolBar jToolBar) {
        this.toolBars = new JToolBar[this.viewers.length];
        for (int i = 0; i < this.toolBars.length; ++i) {
            Object object;
            JToolBar jToolBar2 = null;
            if (i == 0) {
                jToolBar2 = jToolBar;
            } else {
                jToolBar2 = new JToolBar();
                jToolBar2.setFloatable(false);
            }
            this.toolBars[i] = jToolBar2;
            FlowViewer.ViewerActions viewerActions = this.viewers[i].getViewerActions();
            if (!this.getNode().isRootNode()) {
                object = this.viewActions.get("RUN_SELECTED");
                object.putValue("Name", Messages.getString("Action.run_box"));
                object.putValue("SmallIcon", RUN_BOX_ICON);
                jToolBar2.add(this.createToolBarButton((Action)object));
            }
            if (this.getNode().getModel().isOpenSubflow()) {
                object = this.createToolBarButton(viewerActions.get("RUN"));
                JButton jButton = this.createToolBarButton(viewerActions.get("RUN_CLEAR"));
                jToolBar2.add((Component)object);
                jToolBar2.add(jButton);
            }
            jToolBar2.add(this.createToolBarButton(viewerActions.get("RUN_SELECTED")));
            if (!this.getNode().getModel().isOpenSubflow()) continue;
            object = this.createToolBarButton(viewerActions.get("EDGE_MODE"));
            jToolBar2.add((Component)object);
        }
    }

    @Override
    protected JButton createToolBarButton(Action action) {
        JButton jButton = super.createToolBarButton(action);
        String string = (String)action.getValue("Name");
        if (string != null) {
            jButton.setHideActionText(true);
            jButton.setText((String)action.getValue("Name"));
        }
        return jButton;
    }

    protected Component createSubflowView() {
        return new FlowPanel(this.getNode(), this.getFirstViewer(), this.showCodeBar());
    }

    public FlowViewer[] getViewers() {
        return this.viewers;
    }

    public FlowViewer getFirstViewer() {
        return this.viewers[0];
    }

    protected RMultiNodesScriptView getScriptView() {
        return this.scriptView;
    }

    @Override
    public FlowViewer getActiveViewer() {
        FlowViewer flowViewer = this.viewers[this.activeViewerIndex];
        return flowViewer;
    }

    protected void setActiveViewerIndex(int n) {
        if (this.activeViewerIndex == n) {
            return;
        }
        this.activeViewerIndex = n;
        BorderLayout borderLayout = (BorderLayout)this.getCenterPanel().getLayout();
        this.getCenterPanel().remove(borderLayout.getLayoutComponent("North"));
        this.getCenterPanel().add((Component)this.toolBars[n], "North");
        this.getCenterPanel().revalidate();
        this.getCenterPanel().repaint();
    }

    protected boolean showCodeBar() {
        return this.isPreview();
    }

    @Override
    public void loadView() {
        super.loadView();
        for (int i = 0; i < this.viewers.length; ++i) {
            FlowViewer flowViewer = this.viewers[i];
            flowViewer.addChangeListener(this.listeners[i]);
            flowViewer.addComponentListener(this.listeners[i]);
        }
        FlowNode.addNodeModelChangeListener(this);
    }

    @Override
    public void unloadView() {
        super.unloadView();
        for (int i = 0; i < this.viewers.length; ++i) {
            FlowViewer flowViewer = this.viewers[i];
            flowViewer.removeChangeListener(this.listeners[i]);
            flowViewer.removeComponentListener(this.listeners[i]);
            flowViewer.unloadModel();
        }
        FlowNode.removeNodeModelChangeListener(this);
    }

    @Override
    public void nodeModelChanged(FlowNode flowNode) {
    }

    @Override
    public void subflowNodeModelChanged(FlowNode flowNode) {
        if (this.getNode().equals(flowNode)) {
            this.modelChanged();
        }
    }

    protected void modelChanged() {
    }

    @Override
    public Action getAction(String string) {
        FlowViewer flowViewer = this.getActiveViewer();
        return flowViewer.getAction(string);
    }

    static {
        BufferedImage bufferedImage = new BufferedImage(16, 16, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage(FileResource.getIcon("img/node/box.png").getImage(), 0, 0, 12, 12, null);
        graphics2D.dispose();
        RUN_BOX_ICON = Icons.getOverlaidIcon(new ImageIcon(bufferedImage), "16/resultset_next.png", 14, 4, 2);
    }

    private static class ViewerListener
    implements ComponentListener,
    ChangeListener {
        private ViewLayout layout;

        public ViewerListener(ViewLayout viewLayout) {
            this.layout = viewLayout;
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            FlowViewer flowViewer = (FlowViewer)changeEvent.getSource();
            MutableTransformer mutableTransformer = flowViewer.getLayoutTransformer();
            Point point = new Point((int)(mutableTransformer.getTranslateX() + 0.5), (int)(mutableTransformer.getTranslateY() + 0.5));
            this.layout.setOffset(point);
        }

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            this.layout.setSize(componentEvent.getComponent().getSize());
        }

        @Override
        public void componentMoved(ComponentEvent componentEvent) {
        }

        @Override
        public void componentShown(ComponentEvent componentEvent) {
        }

        @Override
        public void componentHidden(ComponentEvent componentEvent) {
        }
    }
}

